#pragma once

#include <array>
#include <util/generic/iterator_range.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>

template <size_t clustersNum, class T> constexpr std::array<T, clustersNum> MakeLevels(T minVal, T maxVal) {
    const auto step = (maxVal - minVal) / T(clustersNum);

    std::array<T, clustersNum> levels{};
    for(size_t i = 1; i <= clustersNum; i++) {
        levels[i - 1] = minVal + step * i;
    }

    return levels;
};

template<size_t clustersNum, class TIter>
TVector<double> ClusterifyValues(TIter b, TIter e) {

    TVector<double> weightsByClusters(clustersNum, 0);

    const auto minMax = std::minmax_element(b, e);

    if(minMax.first != minMax.second) {
        const auto levels = MakeLevels<clustersNum>(*minMax.first, *minMax.second);
        for(auto p : MakeIteratorRange<TIter>(b, e)) {
            for(size_t i = 0; i < levels.size(); i++) {
                if(p <= levels[i]) {
                    weightsByClusters[i] += p;
                    break;
                }
            }
        }
    }

    return weightsByClusters;
}

