#pragma once

#include "matrix.h"

namespace NLSA{

    struct TW2VTrait{
        TMatrix coordinate;
        size_t cluster{};

        bool operator==(const TW2VTrait& rhs) const {
            return coordinate == rhs.coordinate &&
                   cluster == rhs.cluster;
        }

        Y_SAVELOAD_DEFINE(coordinate, cluster)
    };

    struct TW2VViewTrait{
        TViewMatrixData coordinate;
        size_t cluster{};

        bool operator==(const TW2VViewTrait& rhs) const {
            return coordinate.data == rhs.coordinate.data &&
                   cluster == rhs.cluster;
        }

        Y_SAVELOAD_DEFINE(coordinate, cluster)
    };

    using TDictionary = THashMap<TString, TW2VTrait >;
    using TViewDictionary = THashMap<TString, TW2VViewTrait >;

    inline void NormalizeDict(TDictionary& dict) {
        for(auto& [_, trait]: dict)
            trait.coordinate.normalize();
    }
    inline void NormalizeDict(TViewDictionary& dict) {
        for(auto& [_, trait]: dict)
            trait.coordinate.view->normalize();
    }
}
