

#include "hnsw.h"
#include <library/cpp/hnsw/index_builder/build_options.h>
#include <cstddef>
#include <util/generic/utility.h>
#include <library/cpp/hnsw/index_builder/build_options.h>
#include <contrib/libs/cblas/cblas.h>

namespace NLSA{
    NHnsw::THnswBuildOptions BuildOptions(size_t samplesNum) {
        NHnsw::THnswBuildOptions opts;
        opts.MaxNeighbors = Min<size_t>(3, samplesNum);
        opts.BatchSize = 31;
        opts.UpperLevelBatchSize = 63;
        opts.SearchNeighborhoodSize = 15;
        opts.NumExactCandidates = 17;
        opts.NumThreads = 4;
        // LevelSizeDecay set to 2 means that each level will contain at most half of items
        // of the previous level. In that way our index will represent an ordinary skip-list.
        opts.LevelSizeDecay = 2;
        return opts;
    }

    TDistance::TResult TDistance::operator()(const TItemStorage::TItem &a, const TItemStorage::TItem &b) const {
        if(a.view->rows() != 1)
            ythrow yexception() << a.view->rows() << " x " << a.view->cols();
        if(b.view->rows() != 1)
            ythrow yexception() << b.view->rows() << " x " << b.view->cols();
        if(a.view->cols() != b.view->cols())
            ythrow yexception() << a.view->cols() << " x " << b.view->cols();

        return 1 - cblas_sdot(a.data.size(), a.data.data(), 1, b.data.data(), 1);
    }

    TVector<THnswIndex::TNeighbor> THnswIndex::GetNearestNeighbors(const TItemStorage::TItem &query, size_t topSize,
                                                                   size_t searchNeighborhoodSize) const {
            return TBase::GetNearestNeighbors<TItemStorage, TDistance>(query, topSize, searchNeighborhoodSize, ItemStorage);
    }

    const TItemStorage::TItem & THnswIndex::GetItem(ui32 id) const {
            return ItemStorage.GetItem(id);
    }

    THnswIndex::THnswIndex(const TBlob& indexBlob, TItemStorage itemStorage)
            : TBase(indexBlob)
            , ItemStorage(std::move(itemStorage))
    {
    }
}
