#pragma once

#include "matrix.h"
#include <library/cpp/hnsw/index_builder/build_options.h>
#include <library/cpp/hnsw/index/index_item_storage_base.h>
#include <util/memory/blob.h>
#include <util/system/yassert.h>
#include <util/generic/vector.h>
#include <util/generic/buffer.h>
#include <util/stream/buffer.h>
#include <library/cpp/hnsw/index_builder/index_data.h>
#include <library/cpp/hnsw/index_builder/index_writer.h>
#include <library/cpp/hnsw/index/dense_vector_distance.h>

namespace NLSA{

    class TItemStorage {
    public:
        using TItem = TViewMatrixData;

        TItemStorage() = default;

        explicit TItemStorage(TVector<TItem> Items) : Items(std::move(Items)) {}

        const TVector<TItem> & GetItems() const { return Items; }

        const TItem & GetItem(size_t id) const {
            return Items[id];
        }

        size_t GetNumItems() const {
            return Items.size();
        }

        Y_SAVELOAD_DEFINE(Items)
    private:
        TVector<TItem> Items{};
    };


    struct TDistance {
        using TResult = float;

        using TLess = ::TLess<TResult>;

        TResult operator()(const TItemStorage::TItem & a, const TItemStorage::TItem & b) const;
    };

    NHnsw::THnswBuildOptions BuildOptions(size_t samplesNum);

    class THnswIndex : public NHnsw::THnswIndexBase {
        using TBase = NHnsw::THnswIndexBase;
    public:
        using TNeighbor = TBase::TNeighbor<TDistance::TResult>;

        TVector<TNeighbor> GetNearestNeighbors(const TItemStorage::TItem & query, size_t topSize, size_t searchNeighborhoodSize) const;

        const TItemStorage::TItem & GetItem(ui32 id) const;

        THnswIndex(const TBlob& indexBlob, TItemStorage itemStorage);

    private:
        const TItemStorage ItemStorage;
    };

    struct THnswContext{
        THnswContext() = default;
        THnswContext(TBuffer indexData, TItemStorage storage) :
                indexData(std::move(indexData)), storage(std::move(storage)) {}

        Y_SAVELOAD_DEFINE(indexData, storage)

        TBuffer indexData;
        TItemStorage storage;
    };
}   //namespace NLSA
