#include "theme_tree.h"

namespace NLSA{

    TTheme *TThemeTree::GetThemeById(int id)
    {
        auto it = nodes.find(id);
        if(nodes.cend() == it)
            ythrow yexception() << "cannot find theme with id " << id;

        return it->second;
    }
    const TTheme * TThemeTree::GetThemeById(int id) const
    {
        auto it = nodes.find(id);
        if(nodes.cend() == it)
            ythrow yexception() << "cannot find theme with id " << id;

        return it->second;
    }

    const TTheme * TThemeTree::GetParentById(int id) const
    {
        auto t = GetThemeById(id);
        return GetThemeById(t->parentId);
    }

    const TTheme * TThemeTree::GetRoot() const
    {
        return GetThemeById(0);
    }

    void TThemeTree::AddTheme(const TTheme & theme)
    {
        TTheme & t = themes.emplace_back(theme);
        nodes.emplace(theme.themeId, &t);
    }

    bool TThemeTree::operator==(const TThemeTree & tree) const
    {
        return std::equal(themes.cbegin(), themes.cend(), tree.themes.cbegin(), tree.themes.cend());
    }

    void TThemeTree::clear()
    {
        themes.clear();
        nodes.clear();
    }
}
