#pragma once

#include <util/generic/deque.h>
#include "theme.h"

namespace NLSA{
    class TThemeTree : TMoveOnly {
    public:
        const TDeque<TTheme> & GetThemes() const { return themes; }
        TTheme * GetThemeById(int id);
        const TTheme * GetThemeById(int id) const;
        const TTheme * GetParentById(int id) const;
        const TTheme * GetRoot() const;

        void AddTheme(const TTheme & theme);

        friend class TSerializer<TThemeTree>;

        bool operator==(const TThemeTree & tree) const;

        void clear();
    private:
        TDeque<TTheme> themes{};
        THashMap<int, TTheme*> nodes{};
    };
}

template<>
class TSerializer<NLSA::TThemeTree> {
public:
    static inline void Save(IOutputStream* rh, const NLSA::TThemeTree & v) {
        ::Save(rh, v.themes);
    }
    static inline void Load(IInputStream* in, NLSA::TThemeTree& t) {
        ::Load(in, t.themes);
        t.nodes.reserve(t.themes.size());

        for(auto & p : t.themes)
            t.nodes.emplace_noresize(p.themeId, &p);
    }
};
