#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/buffer.h>
#include <util/stream/buffer.h>
#include "matrix.h"

Y_UNIT_TEST_SUITE(Matrix) {
    Y_UNIT_TEST(SaveLoad) {
        NLSA::TMatrix m(480,640);

        for(size_t y = 0; y < (size_t)m.rows(); y++) for(size_t x = 0; x < (size_t)m.cols(); x++)
            m(y, x) = y + x;

        TBuffer buffer;
        {
            TBufferOutput s(buffer);
            ::Save(&s, m);
        }

        NLSA::TMatrix loaded;
        {
            TBufferInput s(buffer);
            ::Load(&s, loaded);
        }

        UNIT_ASSERT_EQUAL(m, loaded);
    }
}
