#include "web.h"

namespace NLSA{


    TVector<double> TWeb::Process(const TMatrix &coord) const {
        Y_VERIFY(!layers.empty());

        const size_t layersNumber = layers.size();

        TMatrix result = (coord * layers.front() + offsets.front()).unaryExpr([] (float v) {
            return std::max(0.f, v);
        });

        for (size_t i = 1; i < layersNumber - 1; i++) {
            result = (result * layers[i] + offsets[i]).unaryExpr([] (float v) {
                return std::max(0.f, v);
            });
        }

        result = (result * layers.back() + offsets.back());

        return TVector<double>(result.data(), result.data() + result.cols());
    }
}
