#pragma once

#include <util/generic/vector.h>
#include <util/generic/hash.h>
#include "matrix.h"

namespace NLSA{
    struct TWeb {
        TVector<TMatrix> layers;
        TVector<TMatrix> offsets;

        TVector<double> Process(const TMatrix &coord) const;

        Y_SAVELOAD_DEFINE(layers, offsets)
    };

    using TMlByIds = THashMap<int, TWeb>;
}
