#!/bin/bash
set -exo pipefail

source config.sh

while true
do
    date "+%F %T Check LSA status"
    if PORT=$SO_LSA_PORT timeout 60 ./check_http_status.sh
    then
        echo LSA is up and running, starting Ljinx
        break
    else
        echo LSA not started yet
        sleep 1
    fi
done

CORE_DIR="/cores"
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.:ljinx_service

source classpath.sh

ADDITIONAL_ARGS="-DPORTO=1"
MEM_ARGS="-Xmx1024M -Xms12M"
GC_ARGS="-XX:ActiveProcessorCount=$CPU_CORES -Xgcpolicy:gencon -verbose:gc -Xgcthreads10 -Xconcurrentbackground2 -Xverbosegclog:/dev/shm/gc#.log,5,2000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $ADDITIONAL_ARGS $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=$LD_LIBRARY_PATH \
    -cp $CLASSPATH ru.yandex.ljinx.Ljinx so-lsa-ljinx.conf

