#!/bin/bash
set -ex

# prepare environment
source lsa-config.sh

substitute_vars() {
    local file_path=$1
    for v in $(grep -ohE '\$\(\w+\)' $file_path | grep -ohE '\w+' | sort -u); do
        [ -z "$v" ] && continue
        eval val=\$$v
        sed -i "s#\$($v)#$val#g" $file_path
    done
}

mkdir -p ./state/vw

config_files=(lsa-${CTYPE}.conf)

for file_path in ${config_files[@]}; do
    cp "${HOME_DIR}/templates/${file_path}.template" "${HOME_DIR}/$file_path"
    # walk through all referenced vars and substitute by its values
    substitute_vars $file_path
done
[ ! -e "./lsa.conf" ] && ln -s lsa-${CTYPE}.conf lsa.conf
