#pragma once

#include <mail/so/spamstop/tools/so-common/StorageBase.h>
#include <mail/so/libs/curl/storage.h>

namespace NLucene{
    class TStorage : public TStorageBase {
    public:
        void SetReadTimeout(const TDuration& timeout) override;

        TDuration GetReadTimeout() const override;

        void SetWriteTimeout(const TDuration& /*timeout*/) override;

        TDuration GetWriteTimeout() const override;

        size_t Count(
                const TString& collectionName,
                const TFindAction& action) override;

        size_t Remove(
                const TString& collectionName,
                const TFindAction& action) override;

        size_t Update(
                const TString& collectionName,
                const TUpdateAction& action) override;

        void UpdateSeries(
                const TString& collectionName,
                const TActionSeries & actions,
                bool ordered) override;

        void UpdateBulk(
                const TString& collectionName,
                const TUpdateAction& action) override;

        void Find(
                const TString& collectionName,
                const TFindAction& action,
                TFindResults& result) override;

        void FindOne(
                const TString& collectionName,
                const TFindAction& action,
                NAnyValue::TScalarMap & result) override;

        THolder<IFuture> FindNonblock(
                TInstant deadline,
                const TString& collectionName,
                const TFindAction& action) override;

        void Connect(const TString& uri) override;
        void Connect(const NConfig::TConfig & config) override;

        explicit TStorage() :
                    poolTraits(
                            NCurl::TOptions()
                                    .SetParseHeaders(false)
                                    .SetParseBody(true)
                                    .SetMaxAliveConnections(32)
                    ),
                    masterPool(MakeHolder<NCurl::TStorage>(TPoolParams(32, TDuration::MilliSeconds(10000)))),
                    replicaPool(MakeHolder<NCurl::TStorage>(TPoolParams(32, TDuration::MilliSeconds(100))))
        {}
    private:
        void FindWithLimit(
                const TString &collectionName,
                const TFindAction &action,
                TFindResults &result,
                const TMaybe<size_t> &count);
    private:
        TString masterUrl, replicaUrl;
        TDuration requestTimeout = TDuration::MilliSeconds(120);
        TDuration connectTimeout = TDuration::MilliSeconds(100);

        NCurl::TPoolTraits poolTraits;
        THolder<NCurl::TStorage> masterPool, replicaPool;
        size_t prefix = 0;
    };
}   //namespace NLucene

