/*
 * Bulk.cpp
 *
 *  Created on: 15 февр. 2016 г.
 *      Author: luckybug
 */

#include "Bulk.h"

#include <contrib/libs/mongo-c-driver/libmongoc/src/mongoc/mongoc.h>

namespace mongo_v3 {
    void Bulk::setWriteTimeout(const TDuration& timeout) {
        WriteConcern concern = getWriteConcern();
        concern.setTimeout(timeout);
        setWriteConcern(concern);
    }

    TDuration Bulk::getWriteTimeout() const {
        return getWriteConcern().getTimeout();
    }

    Bulk& Bulk::insert(const Document& doc) {
        empty = false;
        mongoc_bulk_operation_insert(bulk, doc.bson);
        return *this;
    }

    Bulk& Bulk::update(const Document& query, const Document& action, bool upsert) {
        empty = false;
        mongoc_bulk_operation_update(bulk, query.bson, action.bson, upsert);
        return *this;
    }

    Bulk& Bulk::remove(const Document& query) {
        empty = false;
        mongoc_bulk_operation_remove(bulk, query.bson);
        return *this;
    }

    Document Bulk::exec() {
        if (empty)
            return Document();

        bson_t bson_reply;
        bson_error_t error;
        ui32 res = mongoc_bulk_operation_execute(bulk, &bson_reply, &error);

        Document reply(&bson_reply);
        bson_destroy(&bson_reply);

        if (!res)
            throw Error(error) << " Reply: " << reply.toStr();

        return reply;
    }

    Bulk::Bulk(const Collection& collection, bool ordered)
        : empty(true)
        , bulk(mongoc_collection_create_bulk_operation(collection.collection, ordered, NULL))
    {
        setWriteConcern(collection.getWriteConcern());
        mongoc_bulk_operation_set_bypass_document_validation(bulk, false);
    }
    Bulk::~Bulk() {
        mongoc_bulk_operation_destroy(bulk);
    }

    void Bulk::setWriteConcern(const WriteConcern& writeConcern) {
        if (!writeConcern.isValid())
            throw Error() << "write concern isn't valid";
        mongoc_bulk_operation_set_write_concern(bulk, writeConcern.getRawConcern());
    }

    WriteConcern Bulk::getWriteConcern() const {
        return WriteConcern(mongoc_bulk_operation_get_write_concern(bulk));
    }

} /* namespace mongo_v3 */
