#pragma once

/*
 * Bulk.h
 *
 *  Created on: 15 февр. 2016 г.
 *      Author: luckybug
 */

#include "Document.h"
#include "Collection.h"
#include "Error.h"
#include <util/stream/str.h>

namespace mongo_v3 {
    class Bulk {
    public:
        void setWriteTimeout(const TDuration& timeout);
        TDuration getWriteTimeout() const;
        virtual Bulk& insert(const Document& doc);
        virtual Bulk& update(const Document& query, const Document& action, bool upsert = true);
        virtual Bulk& remove(const Document& query);
        virtual Document exec();

        Bulk(const Collection& collection, bool ordered = false);
        virtual ~Bulk();

    private:
        void setWriteConcern(const WriteConcern& writeConcern);
        WriteConcern getWriteConcern() const;

        Bulk(const Bulk&);
        Bulk& operator=(const Bulk&);

    private:
        bool empty;
        mongoc_bulk_operation_t* bulk;
    };

} /* namespace mongo_v3 */
