/*
 * Client.cpp
 *
 *  Created on: 15 февр. 2016 г.
 *      Author: luckybug
 */

#include "Client.h"
#include "Error.h"

#include <util/generic/yexception.h>

namespace mongo_v3 {
    std::string URI::toStr() const {
        return mongoc_uri_get_string(uri);
    }
    URI::URI(const URI& u) {
        uri = mongoc_uri_copy(u.uri);
    }
    URI& URI::operator=(const URI& u) {
        mongoc_uri_destroy(uri);
        uri = mongoc_uri_copy(u.uri);
        return *this;
    }
    URI::URI(const char* host) {
        uri = mongoc_uri_new(host);
    }
    URI::URI(const TString& host) {
        uri = mongoc_uri_new(host.c_str());
    }
    URI::~URI() {
        mongoc_uri_destroy(uri);
    }

    TSimpleSharedPtr<mongo_v3::Client> ClientPool::getConnection() {
        if (!pool && !connect()) {
            ythrow yexception() << "Not inited mongo pool: ptr is zero";
        }
        mongoc_client_t* client = mongoc_client_pool_pop(pool);

        if (!client)
            ythrow yexception() << "Cannot pop client";

        //    Cout << "Popped " << ++size << Endl;
        mongo_v3::Client* clientObj = new mongo_v3::Client(*this, client);

        clientObj->setReadTimeout(readTimeout);
        clientObj->setWriteTimeout(writeTimeout);

        return clientObj;
    }

    //CallOnce();

    bool ClientPool::connect() {
        static const int a = Init();
        pool = mongoc_client_pool_new(host.uri);
        return pool != NULL && a;
    }

    ClientPool::ClientPool(const URI& host)
        : host(host)
        , pool(0)
        , size()
    {
    }
    ClientPool::ClientPool(const Settings& settings)
        : host(settings.uri)
        , pool(0)
        , size()
        , readTimeout(settings.readTimeout)
        , writeTimeout(settings.writeTimeout)
    {
    }

    int ClientPool::Init() {
        mongoc_init();
        atexit(mongoc_cleanup);
        return 42;
    }
    ClientPool::~ClientPool() {
        if (pool != NULL)
            mongoc_client_pool_destroy(pool);
    }

    Document Client::getStatus() const {
        bson_error_t error;
        bson_t res;
        if (!mongoc_client_get_server_status(client, 0, &res, &error)) {
            Document d(&res);
            throw Error(error) << "client status; " << d.toStr();
        }
        return Document(&res);
    }

    Collection Client::getCollection(const char* db, const char* collectionName) const {
        Collection collection(client, db, collectionName);

        collection.setReadTimeout(readTimeout);
        collection.setWriteTimeout(writeTimeout);

        return collection;
    }

    Client::Client(ClientPool& parent, mongoc_client_t* client)
        : parent(parent)
        , client(client)
    {
        //    mongoc_read_concern_t * concern = mongoc_read_concern_new();
        //    mongoc_read_concern_set_level(concern, MONGOC_READ_CONCERN_LEVEL_MAJORITY);
        //    mongoc_client_set_read_concern(client, concern);
        //    mongoc_read_concern_destroy(concern);
    }
    //Client::Client(const char * host){
    //    volatile static const int init = Init();
    //    client = mongoc_client_new (host);
    //    if(!client)
    //        throw Error(std::string("Cannot connect to ") + std::string(host));
    //}
    Client::~Client() {
        mongoc_client_pool_push(parent.pool, client);
        //    Cout << "Pushed " << --parent.size << Endl;
    }

} /* namespace mongo_v3 */
