#pragma once

#include <contrib/libs/mongo-c-driver/libbson/src/bson/bson.h>
#include <contrib/libs/mongo-c-driver/libmongoc/src/mongoc/mongoc.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>

#include "Document.h"
#include "Collection.h"
#include "Client.h"

namespace mongo_v3 {

 enum KeyType {KT_OID, KT_STRING};

    class Client;

    class URI {
        mongoc_uri_t* uri;

        friend class ClientPool;

    public:
        bool isValid() const {
            return uri != NULL;
        }
        std::string toStr() const;
        URI(const URI& u);
        URI& operator=(const URI& u);
        URI()
            : uri(0){};
        URI(const char* host);
        URI(const TString& host);
        ~URI();
    };

    struct Settings {
        URI uri;
        TDuration readTimeout, writeTimeout;
        Settings() {
        }
        Settings(const URI& uri, const TDuration& readTimeout, const TDuration& writeTimeout)
            : uri(uri)
            , readTimeout(readTimeout)
            , writeTimeout(writeTimeout)
        {
        }
    };

    class ClientPool {
    public:
        void setReadTimeout(const TDuration& timeout) {
            readTimeout = timeout;
        }
        TDuration getReadTimeout() const {
            return readTimeout;
        }
        void setWriteTimeout(const TDuration& timeout) {
            writeTimeout = timeout;
        }
        TDuration getWriteTimeout() const {
            return writeTimeout;
        };

        TSimpleSharedPtr<mongo_v3::Client> getConnection();
        bool connect();
        ClientPool(const URI& host);
        ClientPool(const Settings& settings);
        ~ClientPool();

    private:
        ClientPool(const ClientPool&);
        ClientPool& operator=(const ClientPool&);
        static int Init();

    private:
        friend class Client;

        URI host;
        mongoc_client_pool_t* pool;
        size_t size;
        TDuration readTimeout, writeTimeout;
    };

    class Client {
        friend class Collection;

    public:
        void setReadTimeout(const TDuration& timeout) {
            readTimeout = timeout;
        }
        TDuration getReadTimeout() const {
            return readTimeout;
        }
        void setWriteTimeout(const TDuration& timeout) {
            writeTimeout = timeout;
        }
        TDuration getWriteTimeout() const {
            return writeTimeout;
        };

        Document getStatus() const;
        Collection getCollection(const char* db, const char* collectionName) const;
        Client(ClientPool& parent, mongoc_client_t* client);
        ~Client();

    private:
        ClientPool& parent;
        mongoc_client_t* client;
        TDuration readTimeout, writeTimeout;

        Client& operator=(const Client&);
    };

} /* namespace mongo_v3 */
