#pragma once

#include "Document.h"
#include "Cursor.h"
#include "Concern.h"

namespace mongo_v3 {
    class Client;
    class Collection {
        friend class Bulk;
        mongoc_collection_t* collection;
        TDuration readTimeout;

    public:
        void setReadTimeout(const TDuration& timeout) {
            readTimeout = timeout;
        }
        TDuration getReadTimeout() const {
            return readTimeout;
        }
        void setWriteTimeout(const TDuration& timeout);
        TDuration getWriteTimeout() const;

        void createIndex(const Document& keys);
        void remove(const Document& query);
        size_t size() const;
        size_t count(const Document& query) const;
        Cursor find(const Document& query, size_t limit = 0);
        void update(const Document& query, const Document& updateDoc, bool upsert);
        Document findAndModify(const Document& query, const Document& update, bool upsert = true, bool _new = false);

        Collection(mongoc_client_t* client, const char* db, const char* collectionName);
        Collection(const Collection&);
        Collection& operator=(const Collection&);
        ~Collection();

    private:
        void setWriteConcern(const WriteConcern& concern);
        WriteConcern getWriteConcern() const;
        void uninit();
    };

} /* namespace mongo_v3 */
