/*
 * Concern.cpp
 *
 *  Created on: 24 апр. 2017 г.
 *      Author: luckybug
 */

#include <contrib/libs/mongo-c-driver/libbson/src/bson/bson.h>
#include "Concern.h"

namespace mongo_v3 {
    void WriteConcern::setTimeout(const TDuration& timeout) {
        mongoc_write_concern_set_wtimeout(concern, timeout.MilliSeconds());
    }

    TDuration WriteConcern::getTimeout() const {
        return TDuration::MilliSeconds(mongoc_write_concern_get_wtimeout(concern));
    }

    bool WriteConcern::isValid() const {
        return mongoc_write_concern_is_valid(concern);
    }

    void WriteConcern::setW(i32 w) {
        mongoc_write_concern_set_w(concern, w);
    }

    i32 WriteConcern::getW() const {
        return mongoc_write_concern_get_w(concern);
    }

    void WriteConcern::setJournal(bool journal) {
        mongoc_write_concern_set_journal(concern, journal);
    }

    bool WriteConcern::getJournal() const {
        return mongoc_write_concern_get_journal(concern);
    }

    void WriteConcern::setFsync(bool fsync) {
        mongoc_write_concern_set_fsync(concern, fsync);
    }

    bool WriteConcern::getFsync() const {
        return mongoc_write_concern_get_fsync(concern);
    }

    WriteConcern::WriteConcern(const WriteConcern& another)
        : concern(mongoc_write_concern_copy(another.concern))
    {
    }

    WriteConcern::WriteConcern(const mongoc_write_concern_t* concern)
        : concern(mongoc_write_concern_copy(concern))
    {
    }

    WriteConcern::~WriteConcern() {
        mongoc_write_concern_destroy(concern);
    }

} /* namespace mongo_v3 */
