#pragma once

#include <util/datetime/base.h>

#include <contrib/libs/mongo-c-driver/libmongoc/src/mongoc/mongoc.h>

namespace mongo_v3 {
    class WriteConcern {
    public:
        const mongoc_write_concern_t* getRawConcern() const {
            return concern;
        }
        void setTimeout(const TDuration& timeout);
        TDuration getTimeout() const;
        bool isValid() const;
        void setW(i32 w);
        i32 getW() const;
        void setJournal(bool journal);
        bool getJournal() const;
        void setFsync(bool fsync);
        bool getFsync() const;

        WriteConcern(const WriteConcern& another);
        WriteConcern(const mongoc_write_concern_t* concern);
        ~WriteConcern();

    private:
        mongoc_write_concern_t* concern;
    };

} /* namespace mongo_v3 */
