/*
 * Cursor.cpp
 *
 *  Created on: 15 февр. 2016 г.
 *      Author: luckybug
 */

#include <util/generic/yexception.h>

#include "Error.h"
#include "Cursor.h"

namespace mongo_v3 {
    void Cursor::setTimeout(const TDuration& timeout) {
        mongoc_cursor_set_max_await_time_ms(cursor, timeout.MilliSeconds());
    }

    TDuration Cursor::getTimeout() const {
        return TDuration::MilliSeconds(mongoc_cursor_get_max_await_time_ms(cursor));
    }

    bool Cursor::nextDoc(Document& doc) {
        if (!cursor)
            return false;

        const bson_t* d;

        bool res = mongoc_cursor_next(cursor, &d);

        if (res) {
            doc = Document(d);
            return true;
        }

        bson_error_t error;
        if (mongoc_cursor_error(cursor, &error))
            throw Error(error);

        return false;
    }

    Cursor& Cursor::operator=(const Cursor& c) {
        cursor = mongoc_cursor_clone(c.cursor);
        return *this;
    }
    Cursor::Cursor(const Cursor& c) {
        cursor = mongoc_cursor_clone(c.cursor);
    }

    Cursor::~Cursor() {
        if (cursor)
            mongoc_cursor_destroy(cursor);
    }

} /* namespace mongo_v3 */
