#pragma once

#include <util/datetime/base.h>

#include "Document.h"

namespace mongo_v3 {
    class Cursor {
    public:
        void setTimeout(const TDuration& timeout);
        TDuration getTimeout() const;
        bool nextDoc(Document& doc);

        Cursor(mongoc_cursor_t* cursor)
            : cursor(cursor)
        {
        }
        Cursor& operator=(const Cursor&);
        Cursor(const Cursor& c);
        ~Cursor();

    private:
        mongoc_cursor_t* cursor;
    };

} /* namespace mongo_v3 */
