#pragma once

#include <util/generic/ptr.h>
#include <mail/so/spamstop/tools/so-common/StorageBase.h>

namespace mongo_v3 {
    class ClientPool;

    class TStorageMongo: public TStorageBase {
    public:
        void SetReadTimeout(const TDuration& timeout) override;

        TDuration GetReadTimeout() const override;

        void SetWriteTimeout(const TDuration& timeout) override;

        TDuration GetWriteTimeout() const override;

        size_t Count(
            const TString& collectionName,
            const TFindAction& action) override;

        size_t Remove(
            const TString& collectionName,
            const TFindAction& action) override;

        size_t Update(
            const TString& collectionName,
            const TUpdateAction& action) override;

        void UpdateSeries(
            const TString& collectionName,
            const TActionSeries & series,
            bool ordered) override;

        void UpdateBulk(
            const TString& /*collectionName*/,
            const TUpdateAction& /*action*/) override {
            throw yexception() << "not implemented";
        }

        void Find(
            const TString& collectionName,
            const TFindAction& action,
            TFindResults& result) override;

        void FindOne(
                const TString &collectionName,
                const TFindAction &action,
                NAnyValue::TScalarMap &result) override;


        THolder<IFuture> FindNonblock(
                TInstant /*deadline*/,
                const TString& /*collectionName*/,
                const TFindAction& /*action*/) override {
            ythrow TWithBackTrace<yexception>() << "not implemented";
        };

        void Connect(const TString& uri) override;
        void Connect(const NConfig::TConfig & config) override;

        TStorageMongo();
        explicit TStorageMongo(const TString& dbName);
        virtual ~TStorageMongo();

    private:
        TString dbName;
        THolder<mongo_v3::ClientPool> m_mongo_pool;
    };

} /* namespace mongo_v3 */
