/*
 * MongoNew.cpp
 *
 *  Created on: 4 февр. 2016 г.
 *      Author: luckybug
 */

#include "mongoclient.h"

#include <stdexcept>

#include <util/stream/format.h>
#include <util/stream/str.h>

#include <strstream>
#include <iostream>
#include <sstream>

namespace mongo_v3 {
    //TSimpleSharedPtr<mongo_v3::Client> getConnection()
    //{
    //        static mongo_v3::ClientPool pool(connectionString.c_str());
    //        return new mongo_v3::Client(pool);
    //}

    URI CreateConnectionString(TKConfig& configobjA, const TString& /*DBName*/, const TString& configSeed) {
        const TString& uriStr = configobjA.ReadStroka(configSeed, "uri", "");

        URI uri(uriStr.c_str());

        if (!uri.isValid())
            ythrow yexception() << "Cannot create uri from " << uriStr.c_str();
        else
            Cout << "result uri: " << uriStr.c_str() << Endl;

        return uri;
    }

    void FindByIDs(
        ClientPool& pool,
        const char* db,
        const char* collectionName,
        THashMap<ui64, nosql::HashMap*>& resultHashes) {
        const size_t shinglesCount = resultHashes.size();

        if (shinglesCount == 0)
            return;

        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Client& connect = *connectInstance;

        mongo_v3::Collection collection = connect.getCollection(db, collectionName);

        mongo_v3::Document query;

        if (shinglesCount > 1) {
            mongo_v3::DocumentArray shingles;
            for (THashMap<ui64, nosql::HashMap*>::iterator it = resultHashes.begin(); it != resultHashes.end(); ++it) {
                shingles.push_back(mongo_v3::Oid(ShingleToStroka24(it->first).c_str()));
            }
            query.append("_id", mongo_v3::Document("$in", shingles));
        } else {
            query.append("_id", mongo_v3::Oid(ShingleToStroka24(resultHashes.begin()->first).c_str()));
        }

        mongo_v3::Cursor cursor = collection.find(query);

        mongo_v3::Document doc;
        while (cursor.nextDoc(doc)) {
            std::pair<bool, mongo_v3::Document::Iterator> res = doc.find("_id");
            if (!res.first)
                continue;

            const mongo_v3::Oid& oid = res.second.getOid();

            ui64 shingle = 0;
            std::string strShingle = oid.toStr();
            if (sscanf(strShingle.c_str(), "%lx", &shingle) == EOF)
                continue;

            nosql::HashMap& hash = *resultHashes[shingle];

            FillHashMapFromDoc(doc, hash);
        }
    }

    void FindByIDsAndUids(
        ClientPool& pool,
        const char* db,
        const char* collectionName,
        THashMap<ui64, THashMap<ui64, nosql::HashMap*>>& resultHashes) {
        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));

        DocumentArray query;

        bool empty = true;

        for (THashMap<ui64, THashMap<ui64, nosql::HashMap*>>::iterator uidIt = resultHashes.begin(); uidIt != resultHashes.end(); ++uidIt) {
            ui64 uid = uidIt->first;
            THashMap<ui64, nosql::HashMap*>& shingles = uidIt->second;

            const size_t shinglesCount = resultHashes.size();

            if (shinglesCount == 0)
                continue;
            ;

            DocumentArray shinglesQuery;
            for (THashMap<ui64, nosql::HashMap*>::iterator it = shingles.begin(); it != shingles.end(); ++it) {
                shinglesQuery.push_back(mongo_v3::Oid(ShingleToStroka24(it->first).c_str()));
                empty = false;
            }

            Document uidQuery;
            uidQuery.append("uid", i64(uid));
            uidQuery.append("_id", mongo_v3::Document("$in", shinglesQuery));

            query.push_back(uidQuery);
        }

        if (empty)
            return;

        mongo_v3::Cursor cursor = collection.find(Document("$or", query));

        //Cout << query.toStr() << Endl;

        //mongo_v3::Cursor cursor = collection.find(query);

        mongo_v3::Document doc;
        while (cursor.nextDoc(doc)) {
            std::pair<bool, mongo_v3::Document::Iterator> res = doc.find("_id");
            if (!res.first)
                continue;

            const mongo_v3::Oid& oid = res.second.getOid();

            ui64 shingle = 0;
            std::string strShingle = oid.toStr();
            if (sscanf(strShingle.c_str(), "%lx", &shingle) == EOF)
                continue;

            res = doc.find("uid");
            if (!res.first)
                continue;

            ui64 uid = res.second.getI64();

            nosql::HashMap& hash = *(resultHashes[uid][shingle]);

            FillHashMapFromDoc(doc, hash);
        }
    }

    void AppendAnyValue(mongo_v3::Document& doc, const char* field, const nosql::AnyValue& value) {
        switch (value.Type()) {
            default:
                break;
            case nosql::AnyValue::INTEGER:
                doc.append(field, i32(value.Integer()));
                break;
            case nosql::AnyValue::INTEGER64:
                doc.append(field, value.Long());
                break;
            case nosql::AnyValue::DOUBLE:
                doc.append(field, value.Double());
                break;
            case nosql::AnyValue::STRING:
                doc.append(field, value.String().c_str());
                break;
            case nosql::AnyValue::VECTOR:
                doc.append(field, BinaryData(value.Vector().data(), value.Vector().size()));
                break;
        }
    }

    void AssignAnyValue(const mongo_v3::Document::Iterator& it, nosql::AnyValue& value) {
        switch (it.type()) {
            default:
                break;
            case mongo_v3::BT_DOUBLE:
                value = it.getDouble();
                break;
            case mongo_v3::BT_INT64:
                value = it.getI64();
                break;
            case mongo_v3::BT_INT32:
                value = it.getI32();
                break;
            case mongo_v3::BT_STRING:
                value = it.getString();
                break;
            case mongo_v3::BT_BINARY: {
                const BinaryData& binary = it.getBinary();
                const char* begin = static_cast<const char*>(binary.data());
                value = TVector<char>(begin, begin + binary.size());
                break;
            }
        }
    }

    void FillHashMapFromDoc(const mongo_v3::Document& doc, nosql::HashMap& hash) {
        mongo_v3::Document::Iterator it = doc.iter();

        //printf("%s\n", doc.str().c_str());
        while (it.next()) {
            AssignAnyValue(it, hash[it.key()]);
        }
    }

 mongo_v3::Document DocumentByKeyType(const char *key, const char* shingle, mongo_v3::KeyType key_type)
 {
  mongo_v3::Document res = mongo_v3::Document();

  switch (key_type)
  {
  case mongo_v3::KT_OID:
                         res = mongo_v3::Document(key, mongo_v3::Oid(shingle));
                         break;
  case mongo_v3::KT_STRING:
                         res = mongo_v3::Document(key, shingle);
                         break;
  };

  return res;
 }

    void Update(mongo_v3::ClientPool& pool, const char* db, const char* collectionName, const char* shingle, const nosql::HashMap& incrs, const nosql::HashMap& sets, mongo_v3::KeyType key_type) {
        if (incrs.empty() && sets.empty())
            return;

        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));

        //mongo_v3::Document selector("_id", mongo_v3::Oid(shingle));
  mongo_v3::Document selector = DocumentByKeyType("_id", shingle, key_type);

        mongo_v3::Document action;
        if (!sets.empty()) {
            mongo_v3::Document setsDoc;
            for (nosql::HashMap::const_iterator it = sets.begin(); it != sets.end(); ++it) {
                const char* field = it->first.c_str();
                const nosql::AnyValue& value = it->second;
                AppendAnyValue(setsDoc, field, value);
            }
            action.append("$set", setsDoc);
        }
        if (!incrs.empty()) {
            mongo_v3::Document incrsDoc;
            for (nosql::HashMap::const_iterator it = incrs.begin(); it != incrs.end(); ++it) {
                const char* field = it->first.c_str();
                const nosql::AnyValue& value = it->second;
                AppendAnyValue(incrsDoc, field, value);
            }
            action.append("$inc", incrsDoc);
        }

        mongo_v3::Bulk(collection)
            .update(selector, action)
            .exec();
    }

    bool FindOne(mongo_v3::ClientPool& pool, const char* db, const char* collectionName, const char* shingle, nosql::HashMap& hash, mongo_v3::KeyType key_type) {
        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));

        //const mongo_v3::Document query("_id", mongo_v3::Oid(shingle));
  mongo_v3::Document query = DocumentByKeyType("_id", shingle, key_type);

        mongo_v3::Cursor cursor = collection.find(query, 1);

        mongo_v3::Document doc;
        if (cursor.nextDoc(doc)) {
            FillHashMapFromDoc(doc, hash);
            return true;
        }
        return false;
    }

    void FindAll(mongo_v3::ClientPool& pool, const char* db, const char* collectionName, TVector<nosql::HashMap>& hashes) {
        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));

        mongo_v3::Cursor cursor = collection.find(mongo_v3::Document());

        mongo_v3::Document doc;
        while (cursor.nextDoc(doc)) {
            hashes.push_back(nosql::HashMap());
            FillHashMapFromDoc(doc, hashes.back());
        }
    }

    void FindAndModify(mongo_v3::ClientPool& pool, const char* db,
                       const char* collectionName, const char* shingle,
                       const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& reply,
                       bool upsert, bool _new, mongo_v3::KeyType key_type/* = mongo_v3::KT_OID*/) {
        if (incrs.empty() && sets.empty())
            return;

        //mongo_v3::Document query("_id", mongo_v3::Oid(shingle));
  mongo_v3::Document query = DocumentByKeyType("_id", shingle, key_type);

        mongo_v3::Document action;
        if (!sets.empty()) {
            mongo_v3::Document setsDoc;
            for (nosql::HashMap::const_iterator it = sets.begin(); it != sets.end(); ++it) {
                const char* field = it->first.c_str();
                const nosql::AnyValue& value = it->second;
                AppendAnyValue(setsDoc, field, value);
            }
            action.append("$set", setsDoc);
        }
        if (!incrs.empty()) {
            mongo_v3::Document incrsDoc;
            for (nosql::HashMap::const_iterator it = incrs.begin(); it != incrs.end(); ++it) {
                const char* field = it->first.c_str();
                const nosql::AnyValue& value = it->second;
                AppendAnyValue(incrsDoc, field, value);
            }
            action.append("$inc", incrsDoc);
        }

        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));
        const mongo_v3::Document& replyDoc = collection.findAndModify(query, action, upsert, _new);

        FillHashMapFromDoc(replyDoc, reply);
    }

    size_t GetCollectionSize(mongo_v3::ClientPool& pool, const char* db, const char* collectionName) {
        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));

        return collection.size();
    }

    void RemoveFromCollection(mongo_v3::ClientPool& pool, const char* db, const char* collectionName, ui64 shingle) {
        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));

        collection.remove(mongo_v3::Document("_id", mongo_v3::Oid(ShingleToStroka24(shingle).c_str())));
    }

 void RemoveFromCollection(mongo_v3::ClientPool& pool, const char* db, const char* collectionName, const char* shingle, mongo_v3::KeyType key_type) {
  TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
  mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));

  //collection.remove(mongo_v3::Document("_id", mongo_v3::Oid(shingle)));
  collection.remove(DocumentByKeyType("_id", shingle, key_type));
 }

    void RemoveFromCollection(mongo_v3::ClientPool& pool, const char* db, const char* collectionName, const TVector<ui64>& shingles) {
        mongo_v3::DocumentArray ids;
        for (size_t i = 0; i < shingles.size(); i++) {
            ids.push_back(mongo_v3::Oid(ShingleToStroka24(shingles[i]).c_str()));
        }

        const mongo_v3::Document query("_id", mongo_v3::Document("$in", ids));

        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));
        mongo_v3::Bulk(collection)
            .remove(query)
            .exec();
    }

    void Scan(mongo_v3::ClientPool& pool, const char* db,
              const char* collectionName, TScanner& scanner) {
        TSimpleSharedPtr<mongo_v3::Client> connectInstance = pool.getConnection();
        mongo_v3::Collection collection(connectInstance->getCollection(db, collectionName));

        mongo_v3::Cursor cursor = collection.find(mongo_v3::Document());

        mongo_v3::Document doc;
        if (cursor.nextDoc(doc)) {
            nosql::HashMap hash;
            FillHashMapFromDoc(doc, hash);
            scanner.scan(hash);
        }
    }
}
