#pragma once

#include "Document.h"
#include "Client.h"
#include "Collection.h"
#include "Cursor.h"
#include "Bulk.h"

#include <util/generic/ptr.h>
#include <util/generic/hash.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>

namespace mongo_v3 {
    //TSharedPtr<mongo_v3::Client> getConnection();
    URI CreateConnectionString(TKConfig& configobjA, const TString& DBName, const TString& configSeed);

    void FindByIDs(
        ClientPool& pool,
        const char* db,
        const char* collectionName,
        THashMap<ui64, nosql::HashMap*>& resultHashes);

    void FindByIDsAndUids(
        ClientPool& pool,
        const char* db,
        const char* collectionName,
        THashMap<ui64, THashMap<ui64, nosql::HashMap*>>& resultHashes);

    void AppendAnyValue(mongo_v3::Document& doc, const char* field, const nosql::AnyValue& value);

    void FillHashMapFromDoc(const mongo_v3::Document& doc, nosql::HashMap& hash);

    void Update(mongo_v3::ClientPool& pool, const char* db,
                const char* collection, const char* shingle,
                const nosql::HashMap& incrs,
          const nosql::HashMap& sets, mongo_v3::KeyType key_type = mongo_v3::KT_OID);

    bool FindOne(mongo_v3::ClientPool& pool, const char* db,
                 const char* collectionName, const char* shingle,
                 nosql::HashMap& hash,
           mongo_v3::KeyType key_type = mongo_v3::KT_OID);

    void FindAll(mongo_v3::ClientPool& pool, const char* db,
                 const char* collectionName, TVector<nosql::HashMap>& hashes);

    void FindAndModify(mongo_v3::ClientPool& pool, const char* db,
                       const char* collectionName, const char* shingle,
                       const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& reply,
                       bool upsert, bool _new,
                 mongo_v3::KeyType key_type = mongo_v3::KT_OID);

    size_t GetCollectionSize(mongo_v3::ClientPool& pool, const char* db,
                             const char* collectionName);

    void RemoveFromCollection(mongo_v3::ClientPool& pool, const char* db,
                              const char* collectionName, ui64 shingle);

 void RemoveFromCollection(mongo_v3::ClientPool& pool, const char* db,
                        const char* collectionName, const char* shingle,
                        mongo_v3::KeyType key_type = mongo_v3::KT_OID);

    void RemoveFromCollection(mongo_v3::ClientPool& pool, const char* db,
                              const char* collectionName, const TVector<ui64>& shingles);

    struct TScanner {
        virtual void scan(const nosql::HashMap& doc) = 0;
        virtual ~TScanner() {
        }
    };

    void Scan(mongo_v3::ClientPool& pool, const char* db,
              const char* collectionName, TScanner& scanner);
}
