#pragma once

#include <library/cpp/config/config.h>
#include <mail/so/spamstop/tools/so-common/regexp.h>
#include <library/cpp/charset/doccodes.h>

namespace NRegexp {

    struct TSettings {
        explicit TSettings(size_t matchLimit, size_t matchLimitRecursion, ECharset charset) noexcept
        : MatchLimit(matchLimit)
        , MatchLimitRecursion(matchLimitRecursion)
        , Charset(charset) {}

        explicit TSettings(ECharset charset) noexcept : TSettings(20000, 30, charset) {}

        TSettings() noexcept : TSettings(
#ifdef USE_WIN_CHARSET
             CODES_WIN
#else
            CODES_KOI8
#endif
        ) {}

        static TSettings FromConfig(const NConfig::TDict& section);

        size_t MatchLimit;
        size_t MatchLimitRecursion;
        ECharset Charset;
    };

    class TPcre : public IExpression {
    public:

        [[nodiscard]] EMatchResult Match(const TStringBuf &text) const override;

        EMatchResult Match(const TStringBuf &text, size_t maxN, TMatches &matches) const override;

        explicit TPcre(const TStringBuf &re, const TSettings &settings = {});

        TPcre(TPcre&&) noexcept  = default;

        ~TPcre() override;

    private:
        class TImpl;

        THolder<TImpl> impl;
    };

}   //  namespace NRegexp


