#pragma once

#include <util/generic/hash.h>
#include <util/generic/map.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include "pq/QueryGenerator.h"
#include "pq/Work.h"

namespace sql {
    namespace ProfKeys {
        static const TString total = "total";
        static const TString getConnect = "getconnect";
        static const TString createQuery = "createquery";
        static const TString exec = "exec";
        static const TString parseRes = "parseRes";
        static const TString runQuery = "runQuery";
    }

    enum Type { INT64 = 0,
        INT32,
        INT16,
        DOUBLE,
        TEXT,
        COUNT };

    struct Field {
        const TString& toString() const;

        Type type;
        TString name;
        bool primary;
        TString pgView;

        Field()
                : type(INT64)
                , primary(false)
        {
        }
        Field(Type type, const TString& name, bool primary = false);

        static const TString& primaryPG(bool primary);
        static const TString& defaultValue(Type type);
        static const TString& typeToPGType(Type type);
    };

    typedef TMap<TString, Field> table_t;

    TPoolParams PGMasterPoolParams();
    TPoolParams PGReplicaPoolParams();

    void PGInitPool(TPoolParams masterParams, TPoolParams replicaParams);

    TResWithError<bool> PGInit(
            const char* db,
            const char* user,
            const char* pwd,
            const char* hostname,
            size_t port,
            const TDuration& execTimeout = TDuration::Zero());

    TResWithError<bool> PGInitWOPass(
            const char* db,
            const char* user,
            const char* hostname,
            size_t port,
            const TDuration& execTimeout = TDuration::Zero());

    TResWithError<bool> PGInit(const TVector<TString>& connStrings, const TDuration& execTimeout = TDuration::Zero());

    TResWithError<TConnectionHolder> GetReplicaConnection(TInstant mustEndUntil = TInstant::Max());
    TResWithError<TConnectionHolder> GetMasterConnection(TInstant mustEndUntil = TInstant::Max());

    void PGSetPeriodForCheckingReplicas(int seconds);

    void PGPrepareStatements(const char* table);

    TResWithError<void> PGCheckConnection();

    TResWithError<void> PGCreateTable(const char* name, const table_t& table);
    //
    TResWithError<void> PGCreateIndex(const char* indexName, const char* table, const TVector<TString>& fields);

    TResWithError<void> runQuery(sql::QueryGenerator& gen, bool timedExec = false);

    TResWithError<void> PGUpdate(
            const char* table,
            table_t& tableScheme,
            ui64 shingle,
            const nosql::HashMap& incrs,
            const nosql::HashMap& sets,
            bool timedExec = false);

    TResWithError<void> PGContiniusUpdate(
            const char* table,
            table_t& tableScheme,
            ui64 shingle,
            const nosql::HashMap& incrs,
            const nosql::HashMap& sets,
            sql::QueryGenerator& generator);

    TResWithError<void> PGFindOne(
            const char* table,
            table_t& tableScheme,
            ui64 shingle,
            nosql::HashMap& result,
            const TString& idField,
            bool timedExec = false);

    TResWithError<void> PGFindByIDs(
            const char* table,
            table_t& tableScheme,
            TMap<ui64, nosql::HashMap*>& resultHashes,
            const TString& idField,
            bool timedExec = false);

    TResWithError<void> PGFind(
            const char* table,
            table_t& tableScheme,
            TVector<nosql::HashMap>& results,
            bool timedExec = false,
            int limit = 1024);

    TResWithError<void> PGMultiErase(
            const char* table,
            const TVector<i64>& shingles);

    TResWithError<void> PGErase(
            const char* table,
            ui64 shingle);

    TResWithError<size_t> PGTableSizeApprox(const char* table);
    TResWithError<size_t> PGTableSize(const char* table);
    //
    TResWithError<void> PGTableDrop(const char* table);

} //namespace sql
