#include <algorithm>
#include <util/generic/bitops.h>

#include "Inet.h"

void inverseBytes(void* dst, const void* src, size_t length) {
    const char* begin = reinterpret_cast<const char*>(src);
    const char* end = begin + length;
    char* out = reinterpret_cast<char*>(dst);
    std::reverse_copy(begin, end, out);
}
void inverse32(void* data) {
    ui32* d32 = (ui32*)data;
    *d32 = ReverseBytes(*d32);
    //*d32 = __builtin_bswap32(*d32);
}
void inverse16(void* data) {
    ui16* d16 = (ui16*)data;
    *d16 = ReverseBytes(*d16);
    //*d16 = __builtin_bswap16(*d16);
}
