#include "Inet.h"
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(INET) {
    Y_UNIT_TEST(Inverse32Bit) {
        ui32 value = 0xDEAD0123;
        inverse32(&value);
        UNIT_ASSERT_EQUAL(value, 0x2301ADDE);
    }

    Y_UNIT_TEST(Inverse16Bit) {
        ui16 value = 0xDEAD;
        inverse16(&value);
        UNIT_ASSERT_EQUAL(value, 0xADDE);
    }

    Y_UNIT_TEST(Inverse8Bit) {
        ui8 value = 0xAD;
        ui8 result = 0;
        inverseBytes(&result, &value, 1);
        UNIT_ASSERT_EQUAL(result, 0xAD);
    }

    Y_UNIT_TEST(InverseOdd) {
        const char* value = "12345";
        TVector<char> result(6, 0);

        inverseBytes(result.data(), value, 5);
        UNIT_ASSERT_EQUAL(result.data(), "54321");
    }
}
