#pragma once

#include <util/generic/yexception.h>
#include <util/system/defaults.h>
#include <util/generic/bitops.h>
#include "Inet.h"

namespace sql {
    template <class T>
    class OidArrayConstructor {
    public:
        size_t size() const {
            return this->m_elementsCount;
        }
        void push_back(T v) {
            if (this->m_complete)
                ythrow yexception() << "Array already complete!";

            static const ui32 htonlTypeSize = ReverseBytes(ui32(sizeof(T)));

            *(this->m_it++) = htonlTypeSize;

            inverseBytes(this->m_it, &v, sizeof(T));

            this->m_it += uintsPerElement;

            if ((++(this->m_elementsCount)) == this->m_totalElementsCount)
                this->m_complete = true;
        }
        OidArrayConstructor(void* buff, size_t elementsCount)
            : m_complete(false)
            , m_totalElementsCount(elementsCount)
            , m_elementsCount(0)
            , m_buff((ui32*)buff)
        {
            const ui32 header[5] = {
                ReverseBytes(ui32(1)),
                ReverseBytes(ui32(0)),
                ReverseBytes(OidByType<T>::oid),
                0, //htonl(size),
                ReverseBytes(ui32(1))};
            static const size_t headerSize = sizeof(header) / sizeof(header[0]);
            this->m_it = this->m_buff;
            memcpy(this->m_it, header, headerSize * sizeof(ui32));
            this->m_it += headerSize;
            setSize();
        }

        ~OidArrayConstructor() noexcept(false) {
            if (!this->m_complete)
                ythrow yexception() << "Array isn't complete!";
        }

        static size_t calcBufferSize(size_t elementsCount) {
            size_t totalSize = 5 + elementsCount * elementSize;
            return totalSize * sizeof(ui32);
        }

    private:
    private:
        static const size_t uintsPerElement = sizeof(T) / sizeof(ui32);
        static const size_t elementSize = 1 + uintsPerElement;

        void setSize() {
            this->m_buff[3] = ReverseBytes((ui32)m_totalElementsCount);
        }

        bool m_complete;
        const size_t m_totalElementsCount;
        size_t m_elementsCount;
        ui32 *m_buff, *m_it = nullptr;
    };

} /* namespace sql */
