#include "Query.h"

#include "string.h"
#include <stdio.h>
#include <sstream>
#include <iterator>
#include <iostream>

#include <util/stream/str.h>

namespace sql {
    void Query::assignQuery(const TString& newQuery) {
        query.Str() = newQuery;
    }

    TString Query::toString() const {
        TStringStream ss;
        ss << query.Str() << "\n";
        ss << "Params count: " << params.size() << "\n";
        return ss.Str();
    }

    void Query::bind(const char * v) {
        bind<TString>(v);
    }

    template<> void Query::bind<TString>(const TString & v) {
        assignToBack(v.data(), v.size());

        bindOid(T_text);
        bindBack();
    }

    void Query::assignToBack(const void* v, size_t length) {
        data.push_back(TVector<char>((char*)v, ((char*)v) + length));
    }

    void Query::bindOid(Oid oid) {
        oids.push_back(oid);
    }

    void Query::bindBack() {
        params.push_back(&data.back()[0]);
        lengths.push_back(data.back().size());
        formats.push_back(1);
    }

    Query::Query(const TString& _query) {
        assignQuery(_query);
    }

} /* namespace sql */
