/*
 * QueryGenerator.cpp
 *
 *  Created on: 26.11.2015
 *      Author: luckybug
 */

#include "QueryGenerator.h"

#include <cassert>
#include <util/system/defaults.h>

namespace sql {
    template <>
    const char PrintfPlaceholders<i64>::val[] = "%" PRIi64;
    template <>
    const char PrintfPlaceholders<i32>::val[] = "%" PRIi32;
    template <>
    const char PrintfPlaceholders<ui64>::val[] = "%" PRIu64;
    template <>
    const char PrintfPlaceholders<ui32>::val[] = "%" PRIu32;
    template <>
    const char PrintfPlaceholders<double>::val[] = "%lf";

    QueryGenerator& QueryGenerator::clear() {
        buff.clear();
        return *this;
    }

    QueryGenerator& QueryGenerator::assign(const char* str) {
        buff << str;
        return *this;
    }
    QueryGenerator& QueryGenerator::assign(const TString& str) {
        buff << str;
        return *this;
    }

    QueryGenerator& QueryGenerator::assign(char c) {
        buff << c;
        return *this;
    }

    size_t QueryGenerator::length() const {
        return buff.Size();
    }
    const char* QueryGenerator::get() const {
        return buff.Data();
    }

    template <>
    QueryGenerator& QueryGenerator::operator()<1>(const char (&val)[1]);

    Query QueryGenerator::createQuery() const {
        return Query(buff.Str());
    }

    void QueryGenerator::assignIncr(const char* field, const char* value) {
        assign(sep)(field)('=')(field)('+')(value);
        sep = ',';
    }

    void QueryGenerator::assignSet(const char* field, const char* value) {
        assign(sep)(field)("='")(value)("'");
        sep = ',';
    }

    void QueryGenerator::setFirst() {
        sep = ' ';
    }

} /* namespace sql */
