#pragma once

#include <util/stream/str.h>
#include "Query.h"
#include "Error.h"

namespace sql {
    template <class T>
    struct PrintfPlaceholders {
        static const char val[];
    };

    class QueryGenerator {
    public:
        void setFirst();
        QueryGenerator& clear();
        size_t length() const;
        const char* get() const;

        template <class T>
        QueryGenerator& assign(T v) {
            buff << v;
            return *this;
        }
        QueryGenerator& assign(const char* str);
        QueryGenerator& assign(const TString& str);
        QueryGenerator& assign(char c);

        QueryGenerator& operator()(const char* val) {
            buff << TString(val);
            return *this;
        }
        template <typename T>
        QueryGenerator& operator()(T val) {
            return assign(val);
        }

        template <size_t N>
        QueryGenerator& assign(const char (&val)[N]) {
            buff << TString(val, N);
            return *this;
        }

        template <size_t N>
        QueryGenerator& operator()(const char (&val)[N]) {
            return assign<N>(val);
        }

        Query createQuery() const;

        template <typename T>
        void assignIncr(const char* field, T value) {
            assign(sep)(field)('=')(field)('+')(value);
            sep = ',';
        }
        void assignIncr(const char* field, const char* value);

        template <typename T>
        void assignSet(const char* field, T value) {
            assign(sep)(field)('=')(value);
            sep = ',';
        }
        void assignSet(const char* field, const char* value);

        QueryGenerator()
            : sep(' ')
        {
        }

    private:
        TStringStream buff;
        char sep;
    };

} /* namespace sql */
