#include <ostream>
#include <iterator>
#include <util/network/poller.h>
#include <library/cpp/coroutine/engine/impl.h>

#include "Work.h"
#include "Error.h"

namespace sql {
    TResWithError<TResult> Work::exec(const Query& query, bool binary) {
        TResult r(client.ExecQuery(query, binary));

        if (!r.Ok())
            return TInterfaceError(TInterfaceError::ExecError, client.Info() + " " + TString{r.ErrorMessage()});

        return ResWithError(std::move(r));
    }

    TResWithError<TResult> Work::exec(const QueryGenerator& gen) {
        return exec(gen.createQuery(), false);
    }

    Work::Work(Connection& client)
            : client(client)
    {}

    TResWithError<TResult> Work::exec(const Query& query, const TInstant& endUntil, bool binary) {
        const TInstant end = (endUntil == TInstant::Max()) ? client.getExecTimeout().ToDeadLine() : endUntil;

        try{
            client.SendQuery(query, binary);
            client.Flush(end);
            TResult res(client.GetResult(end));

            if(!res.Ok())
                return TInterfaceError(TInterfaceError::ExecError, client.Info() + " " + TString{res.ErrorMessage()});

            return ResWithError(std::move(res));
        } catch (const TInterfaceError & e) {
            client.reset();
            return e;
        }
    }

    TResWithError<TResult> Work::exec(const QueryGenerator& gen, const TInstant& endUntil) {
        return exec(gen.createQuery(), endUntil, false);
    }
} /* namespace sql */
