#pragma once

#include <util/generic/ptr.h>

#include "Result.h"

struct pg_conn;
template<> void TDelete::Destroy<pg_conn>(pg_conn* conn) noexcept;

namespace sql {
    enum class EPollingStatus{
        Ok,
        Fail,
        Read,
        Write,
        InProgress
    };

    class TPgConnectionHolder {
    public:
        static TPgConnectionHolder PqConnectDb(const TString &connectionString);
        static TPgConnectionHolder PqConnectStart(const TString &connectionString);

        TPgResultHolder PqGetResult();

        TPgNotifiesHolder PqGetNotifies();

        int PqFlush();

        int PqSocket() const;

        void PqReset();

        int PqConsumeInput();

        int PqIsBusy();

        int PqIsnonblocking() const;

        int PqSetnonblocking(int nonblocking);

        int PqSendQueryParams(const char *command,
                          int nParams,
                          const Oid *paramTypes,
                          const char *const * paramValues,
                          const int *paramLengths,
                          const int *paramFormats,
                          int resultFormat);

        int PqSendQuery(const char *query);

        TPgResultHolder PqExecParams(const char *command,
                                     int nParams,
                                     const Oid *paramTypes,
                                     const char *const * paramValues,
                                     const int *paramLengths,
                                     const int *paramFormats,
                                     int resultFormat);

        TPgResultHolder PqExec(const char *query);

        EPollingStatus PqConnectPoll();

        TString Info() const;

        TStringBuf Host() const;

        TStringBuf Db() const;

        TStringBuf ErrorMessage() const;

        bool Ok() const;

        void Reset();

        bool IsReplica();

        const TString & GetConnectionString() const { return connectionString; }
        friend IOutputStream &operator<<(IOutputStream &stream, const TPgConnectionHolder &holder);

        TPgConnectionHolder() = default;
        TPgConnectionHolder(TPgConnectionHolder&&) noexcept = default;
        TPgConnectionHolder &operator=(TPgConnectionHolder&&) noexcept = default;
    private:
        void CheckNotNull() const;
        explicit TPgConnectionHolder(pg_conn * conn, TString connectionString);
    private:
        THolder<pg_conn> instance;
        TString connectionString;
    };

}
