#include "re2_wrapper.h"

#include <contrib/libs/re2/re2/re2.h>

namespace NRegexp {

    EMatchResult TRe2::Match(const TStringBuf &text) const {
        return re2::RE2::PartialMatch(text.data(), *re) ? EMatchResult::Match : EMatchResult::NotMatch;
    }

    EMatchResult TRe2::Match(const TStringBuf &text, size_t maxN, TMatches &matches) const {
        TVector<re2::StringPiece> re2matches(maxN);
        const EMatchResult res = re->Match(text.data(), 0, text.size(), re2::RE2::UNANCHORED, re2matches.data(),
                                           static_cast<int>(re2matches.size())) ?
                                 EMatchResult::Match : EMatchResult::NotMatch;

        matches.clear();
        matches.reserve(maxN);

        for (const re2::StringPiece &s : re2matches) {
            if (!s.data())
                continue;

            matches.emplace_back(s.data(), s.size());
        }

        return res;
    }

    TRe2::TRe2(const TStringBuf &src) {
        re2::RE2::Options options(re2::RE2::Quiet);

        re = MakeHolder<re2::RE2>(re2::StringPiece(src.cbegin(), src.size()), options);
    }

    TRe2::~TRe2() = default;;
}   //  namespace NRegexp
