#pragma once

#include <mail/so/spamstop/tools/so-common/regexp.h>
#include <util/generic/maybe.h>

namespace re2 {
    class RE2;
}

namespace NRegexp {

    class TRe2 : public IExpression {
    public:

        EMatchResult Match(const TStringBuf &text) const override;

        EMatchResult Match(const TStringBuf &text, size_t maxN, TMatches &matches) const override;

        explicit TRe2(const TStringBuf &re);

        ~TRe2() override;

    private:
        THolder<re2::RE2> re;
    };

}   //  namespace NRegexp


