#include "tlogsgroup.h"
#include "tmakerequest.h"
#include "tgeneralobject.h"
#include "tserviceobject.h"
#include "tfcgiserver.h"
#ifdef _win_
#define CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>
#else
#include <signal.h>
#define MAX_STACK_SIZE 512
char forced_host[16];
int fd_devnull = -1;
void StartMakeMeDaemon();
int FinishMakeMeDaemon();
#endif
#define SERVER_NAME "FCGI ShingleServer 4.17"
TServiceObject ServiceObject;
TFCGIServer fcgi_serv(ServiceObject);

/*HANDLE*/void *hEventLog = NULL;
const char AppIdent[] = "shingleserver";

#ifndef _win_
void ShutdownHandler(int signo) {
    switch (signo) {
        case SIGTERM:
            fcgi_serv.Shutdown();
            signal(SIGTERM, ShutdownHandler);
            break;
        case SIGUSR1:
            //fcgi_serv.SendSIGUSR1();
            //signal(SIGUSR1, ShutdownHandler);
            break;
    };
}
#endif
void calc_time() {
    time_t current_time = time(NULL);
    time_t res_time = 0;
    int add_day_count = 181;
    TString res = "";
    int a = 0;
    res_time = current_time + 86400 * add_day_count;
    res = TimeToStr(res_time);
    a = a;
}

void Test01()
{

}

int main(int argc, char* argv[]) {

 //Test01();

 //   int a1 = sizeof(TObrabShingleDebugInfo);
 //   int a2 = sizeof(TShingleStat);
 //   int a3 = sizeof(TShingleDataTE);
 //   int a4 = sizeof(TShingleShortInfoRPL);
    //calc_time();
    int ret_code = 0;
    int thread_id = -1;
// DEBUG !!!
#ifdef _win_
    _CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
    //_crtBreakAlloc = 1108;
    HANDLE hLogFile;
    hLogFile = CreateFile("c:\\!Leaks\\shingleserver4.kls", GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
    _CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_FILE);
    _CrtSetReportFile(_CRT_WARN, hLogFile);
#endif
    printf("\n%s\n", SERVER_NAME);
    if (argc < 2) {
        printf("\nUsage: sonline <config_file>\n");
        exit(1);
    }
#ifdef _win_
    WSADATA dummy;
    WSAStartup(MAKEWORD(2, 2), &dummy);
#endif
    if (ServiceObject.InitBeforeFork(argv[0], argv[1], SERVER_NAME)) {
#ifndef _win_
        struct sigaction sa;
        sa.sa_handler = ShutdownHandler;
        sigemptyset(&sa.sa_mask);
        sa.sa_flags = 0;
        sigaction(SIGUSR1, &sa, NULL);
        sigaction(SIGTERM, &sa, NULL);
#endif
        if (fcgi_serv.InitBeforeFork()) {
#ifndef _win_
            if( ServiceObject.Daemonize() )
            {
                StartMakeMeDaemon(); //fork
                signal(SIGPIPE, SIG_IGN);
            }
            thread_id = syscall(SYS_gettid);
#endif
            if ((ServiceObject.GetLogsGroup() != NULL) && (ServiceObject.GetLogsGroup()->GetDebugInfoLog() != NULL))
                ServiceObject.GetLogsGroup()->GetDebugInfoLog()->WriteMessageAndDataStatus(KMESSAGE, "THREADID % 9d: MAIN", thread_id);
            fcgi_serv.InitAfterFork();
#ifndef _win_
            if( ServiceObject.Daemonize() )
                fd_devnull = FinishMakeMeDaemon();
            fcgi_serv.WritePid();
#endif
            fcgi_serv.Wait();
            fcgi_serv.Close();
        } else {
            printf("Server not started - initialization error, see logs for details\n");
            ret_code = 1;
        }
    } else {
        printf("Server not started - initialization error, see logs for details\n");
        ret_code = 1;
    }
    ServiceObject.Close();
#ifdef _win_
    WSACleanup();
#endif
#ifndef _win_
    if (fd_devnull >= 0)
        close(fd_devnull);
    close(0);
    close(1);
    close(2);
#endif
    exit(ret_code);
}
