#include "tgeneralobject.h"

//******************************************************************************************************************************************
//                                                       TGeneralObject
//******************************************************************************************************************************************

TGeneralObject::TGeneralObject() {
    LogsGroup = NULL;
    config = NULL;
    ShinglesStorage = new TShingleStorageMain();
    SimpleStorage = new TSimpleStorage();
    PoolProxy = NULL;
    PoolRPL = NULL;
    m_server_id = "";
}

TGeneralObject::~TGeneralObject() {
    ui32 tick = 0;
    ui32 tick_all = 0;

    tick_all = CShingleTime::GetMs();
    WriteExitStep("*** start delete all ***");

    WriteExitStep("start delete SimpleStorage");
    tick = CShingleTime::GetMs();
    if (SimpleStorage != NULL) {
        delete SimpleStorage;
        SimpleStorage = NULL;
    }
    tick = CShingleTime::GetMs() - tick;
    WriteExitStep("compleate delete SimpleStorage to " + IntToStroka(tick) + " msec");

    WriteExitStep("start delete ShinglesStorage");
    tick = CShingleTime::GetMs();
    if (ShinglesStorage != NULL) {
        delete ShinglesStorage;
        ShinglesStorage = NULL;
    }
    tick = CShingleTime::GetMs() - tick;
    WriteExitStep("compleate delete ShinglesStorage to " + IntToStroka(tick) + " msec");

    WriteExitStep("start delete PoolProxy");
    tick = CShingleTime::GetMs();
    if (PoolProxy != NULL) {
        delete PoolProxy;
        PoolProxy = NULL;
    }
    tick = CShingleTime::GetMs() - tick;
    WriteExitStep("compleate delete PoolProxy to " + IntToStroka(tick) + " msec");

    WriteExitStep("start delete PoolRPL");
    tick = CShingleTime::GetMs();
    if (PoolRPL != NULL) {
        delete PoolRPL;
        PoolRPL = NULL;
    }
    tick = CShingleTime::GetMs() - tick;
    WriteExitStep("compleate delete PoolRPL to " + IntToStroka(tick) + " msec");

    tick_all = CShingleTime::GetMs() - tick_all;
    WriteExitStep("*** compleate delete all to " + IntToStroka(tick_all) + " msec ***");
}

void TGeneralObject::WriteExitStep(const TString& text) {
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL)) {
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "EXITEVENT: %s", text.c_str());
        LogsGroup->GetServerLog()->FFlush();
    }
}

TLogsGroup* TGeneralObject::GetLogsGroup() {
    return (TLogsGroup*)LogsGroup;
}

bool TGeneralObject::InitBeforeFork(const TString& server_id, TLogsGroupBase* LogsGroupA, TKConfig* configA) {
    bool res = true;

    LogsGroup = LogsGroupA;
    config = configA;
    m_server_id = server_id;

    if (config != NULL) {
        TString modestr = config->ReadStroka("server", "mode", "");

        if (!modestr.empty()) {
            to_lower_k(modestr);
            if (modestr == "proxy")
                m_mode = MPROXY;
            else
                m_mode = MSHINGLER;
        }
    }

    switch (m_mode) {
        case MPROXY:
            if (PoolProxy == NULL)
                PoolProxy = new TProxyPool();
            if (PoolProxy != NULL)
                res = PoolProxy->InitBeforeFork(m_server_id, GetConfigObject(), GetLogsGroup());
            else
                res = false;

            break;
        default:
            if (PoolRPL == NULL)
                PoolRPL = new TRPLMain();
            if (PoolRPL != NULL)
                res = PoolRPL->InitBeforeFork(m_server_id, GetConfigObject(), GetLogsGroup());
            else
                res = false;
    };

    if (SimpleStorage != NULL) {
        if (SimpleStorage->InitBeforeFork(m_mode, GetConfigObject(), GetLogsGroup())) {
            ui32 ecount = 0;
            ui32 edublicat = 0;

            SimpleStorage->Load(ecount, edublicat);

        } else
            res = false;
    }

    if (ShinglesStorage != NULL) {
        if (!ShinglesStorage->InitBeforeFork(m_server_id, GetLogsGroup(), GetConfigObject(), m_mode, PoolProxy, PoolRPL, SimpleStorage))
            res = false;
    }

    monobj.Init(GetLogsGroup(), ShinglesStorage, PoolProxy, PoolRPL);

    return res;
}

bool TGeneralObject::InitAfterFork() {
    bool res = true;

    switch (m_mode) {
        case MPROXY:
            if (PoolProxy != NULL)
                res = PoolProxy->InitAfterFork(this);
            else
                res = false;

            break;
        default:
            if (PoolRPL != NULL)
                res = PoolRPL->InitAfterFork(this);
            else
                res = false;
    };

    if (ShinglesStorage != NULL)
        ShinglesStorage->InitAfterFork();

    return res;
}

bool TGeneralObject::Midnight() {
    monobj.Midnight();

    if (PoolProxy != NULL)
        PoolProxy->Midnight();

    if (PoolRPL != NULL)
        PoolRPL->Midnight();

    if (ShinglesStorage != NULL)
        ShinglesStorage->Midnight();

    if (GetLogsGroup() != NULL)
        GetLogsGroup()->TruncLog();

    return true;
}

bool TGeneralObject::Shutdown() {
    if (PoolProxy != NULL)
        PoolProxy->Shutdown();

    if (PoolRPL != NULL)
        PoolRPL->Shutdown();

    if (ShinglesStorage != NULL)
        ShinglesStorage->Shutdown();

    return true;
}

void TGeneralObject::EventTick() {
    monobj.WriteMonData();

    if (PoolProxy != NULL)
        PoolProxy->EventTick();

    if (PoolRPL != NULL)
        PoolRPL->EventTick();

    if (ShinglesStorage != NULL)
        ShinglesStorage->EventTick();
}

bool TGeneralObject::Close() {
    if (ShinglesStorage != NULL)
        ShinglesStorage->Close();

    return true;
}

//******************************************************************************************************************************************
