#pragma once

#include <mail/so/spamstop/tools/fcgiserver_base/tgeneralserviceobject.h>
#include <mail/so/spamstop/tools/so-common/tlogsgroupbase.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tlogsgroup.h"
#include "tshinglestorage.h"
#include "tproxyclientspool.h"
#include "tgeneralclasses.h"
#include "trplclientspool.h"
#include "tsimplestorage.h"
#include "tmonobj.h"

//******************************************************************************************************************************************
//                                                       TGeneralObject
//******************************************************************************************************************************************

class TGeneralObject: public TGeneralServiceObject {
private:
    TLogsGroupBase* LogsGroup;
    TKConfig* config;
    TShinglerSrvMode m_mode;
    TString m_server_id;

    TLogsGroup* GetLogsGroup();
    TKConfig* GetConfigObject() {
        return config;
    }

    void WriteMonData();
    void WriteExitStep(const TString& text);

public:
    TGeneralObject();
    ~TGeneralObject();

    TShingleStorageMain* ShinglesStorage;
    TProxyPool* PoolProxy;
    TRPLMain* PoolRPL;
    TSimpleStorage* SimpleStorage;
    TMonObj monobj;

    bool InitBeforeFork(const TString& server_id, TLogsGroupBase* LogsGroupA, TKConfig* configA);
    bool InitAfterFork();

    bool Midnight();
    bool Shutdown();
    void EventTick();
    bool Close();

    TShinglerSrvMode GetServerMode() {
        return m_mode;
    }
};

//******************************************************************************************************************************************
