#include "tlogsgroup.h"

//****************************************************************************************************************************************
//                                              TLogsGroup
//****************************************************************************************************************************************

TLogsGroup::TLogsGroup() {
    iniobj = NULL;
    m_ServerLog = NULL;
    m_DebugInfoLog = NULL;
    m_InputLog = NULL;
    m_TestLog = NULL;
    m_ConvertOldRqstLog = NULL;
    m_SendAnswerLog = NULL;
    m_ProxyLog = NULL;
    m_ReplicLog = NULL;
    m_ShinglesLog = NULL;
    m_StorageLog = NULL;
    m_MonLog = NULL;
    m_FollowShinglesLog = NULL;
    m_LongRequestLog = NULL;
    sendanswerlog_treshold = 0;
}

TLogsGroup::~TLogsGroup() {
    if (m_LongRequestLog != NULL) {
        delete m_LongRequestLog;
        m_LongRequestLog = NULL;
    }
    if (m_FollowShinglesLog != NULL) {
        delete m_FollowShinglesLog;
        m_FollowShinglesLog = NULL;
    }
    if (m_MonLog != NULL) {
        delete m_MonLog;
        m_MonLog = NULL;
    }
    if (m_StorageLog != NULL) {
        delete m_StorageLog;
        m_StorageLog = NULL;
    }
    if (m_ShinglesLog != NULL) {
        delete m_ShinglesLog;
        m_ShinglesLog = NULL;
    }
    if (m_ReplicLog != NULL) {
        delete m_ReplicLog;
        m_ReplicLog = NULL;
    }
    if (m_ProxyLog != NULL) {
        delete m_ProxyLog;
        m_ProxyLog = NULL;
    }
    if (m_SendAnswerLog != NULL) {
        delete m_SendAnswerLog;
        m_SendAnswerLog = NULL;
    }
    if (m_ConvertOldRqstLog != NULL) {
        delete m_ConvertOldRqstLog;
        m_ConvertOldRqstLog = NULL;
    }
    if (m_TestLog != NULL) {
        delete m_TestLog;
        m_TestLog = NULL;
    }
    if (m_InputLog != NULL) {
        delete m_InputLog;
        m_InputLog = NULL;
    }
    if (m_DebugInfoLog != NULL) {
        delete m_DebugInfoLog;
        m_DebugInfoLog = NULL;
    }
    if (m_ServerLog != NULL) {
        delete m_ServerLog;
        m_ServerLog = NULL;
    }
}

bool TLogsGroup::Init(TKConfig* iniobjA) {
    bool res = true;
    TString serverlog_name = "";
    TString debuginfolog_name = "";
    TString inputlog_name = "";
    TString testlog_name = "";
    TString convertoldrqst_name = "";
    TString sendanswerlog_name = "";
    TString proxylog_name = "";
    TString repliclog_name = "";
    TString shingleslog_name = "";
    TString storagelog_name = "";
    TString monlog_name = "";
    TString followshingleslog_name = "";
    TString longrequestlog_name = "";
    bool debug_mode = false;

    iniobj = iniobjA;
    if (iniobj != NULL) {
        debug_mode = iniobj->ReadBool("logs", "debug_mode", false);
        serverlog_name = iniobj->ReadStroka("logs", "serverlog", "");
        debuginfolog_name = iniobj->ReadStroka("logs", "debuginfolog", "");
        inputlog_name = iniobj->ReadStroka("logs", "inputlog", "");
        testlog_name = iniobj->ReadStroka("logs", "testlog", "");
        convertoldrqst_name = iniobj->ReadStroka("logs", "convert_old_rqst_log", "");
        sendanswerlog_name = iniobj->ReadStroka("logs", "sendanswerlog", "");
        sendanswerlog_treshold = iniobj->ReadInteger("logs", "sendanswerlog_treshold", 0);
        proxylog_name = iniobj->ReadStroka("logs", "proxylog", "");
        repliclog_name = iniobj->ReadStroka("logs", "repliclog", "");
        shingleslog_name = iniobj->ReadStroka("logs", "shingleslog", "");
        storagelog_name = iniobj->ReadStroka("logs", "storagelog", "");
        monlog_name = iniobj->ReadStroka("logs", "monlog", "");
        followshingleslog_name = iniobj->ReadStroka("logs", "followshlog", "");
        longrequestlog_name = iniobj->ReadStroka("logs", "longrequestlog", "");

        SetDebugMode(debug_mode);

        if (!serverlog_name.empty()) {
            m_ServerLog = new TLogClass(serverlog_name, true);
            if (m_ServerLog != NULL)
                ((TLogClass*)m_ServerLog)->EnableWrite();
        }

        if (!debuginfolog_name.empty()) {
            m_DebugInfoLog = new TLogClass(debuginfolog_name, false);
            if (m_DebugInfoLog != NULL)
                ((TLogClass*)m_DebugInfoLog)->EnableWrite();
        }

        if (!inputlog_name.empty()) {
            m_InputLog = new TLogClass(inputlog_name, true);
            if (m_InputLog != NULL)
                ((TLogClass*)m_InputLog)->EnableWrite();
        }

        if (!testlog_name.empty()) {
            m_TestLog = new TLogClass(testlog_name, true);
            if (m_TestLog != NULL)
                ((TLogClass*)m_TestLog)->EnableWrite();
        }

        if (!convertoldrqst_name.empty()) {
            m_ConvertOldRqstLog = new TLogClass(convertoldrqst_name, true);
            if (m_ConvertOldRqstLog != NULL)
                ((TLogClass*)m_ConvertOldRqstLog)->EnableWrite();
        }

        if (!sendanswerlog_name.empty()) {
            m_SendAnswerLog = new TLogClass(sendanswerlog_name, true);
            if (m_SendAnswerLog != NULL)
                ((TLogClass*)m_SendAnswerLog)->EnableWrite();
        }

        if (!proxylog_name.empty()) {
            m_ProxyLog = new TLogClass(proxylog_name, true);
            if (m_ProxyLog != NULL)
                ((TLogClass*)m_ProxyLog)->EnableWrite();
        }

        if (!repliclog_name.empty()) {
            m_ReplicLog = new TLogClass(repliclog_name, true);
            if (m_ReplicLog != NULL)
                ((TLogClass*)m_ReplicLog)->EnableWrite();
        }

        if (!shingleslog_name.empty()) {
            m_ShinglesLog = new TLogClass(shingleslog_name, true);
            if (m_ShinglesLog != NULL)
                ((TLogClass*)m_ShinglesLog)->EnableWrite();
        }

        if (!storagelog_name.empty()) {
            m_StorageLog = new TLogClass(storagelog_name, true);
            if (m_StorageLog != NULL)
                ((TLogClass*)m_StorageLog)->EnableWrite();
        }

        if (!monlog_name.empty()) {
            m_MonLog = new TLogClass(monlog_name, true, "#<INRQST newrps='X', newin='X', newlost='X', oldrps='X', oldin='X', oldlost='X', rplrps='X', rplin='X', rpllost='X', prxrps='X', prxin='X', prxlost='X'><INSHIN(old/new) shget='X/X', shput='X/X', stget='X/X', rpl='X', prxget='X', prxput='X'><TIMING(0_10-10_20-20_30-30_40-40_50-50_100-100_200-200_500-more500): clust='XX/XX/XX/XX/XX/XX/XX/XX/XX' rpl='XX/XX/XX/XX/XX/XX/XX/XX/XX' prx='XX/XX/XX/XX/XX/XX/XX/XX/XX' ><BUSYSTAT(get-getheavy-put-putm-setm-setweight): XX-XX-XX-XX-XX-XX >[<PRX queue='in/out/count/lost/rqst_in/rqst_out' net='forbid/all/CE/CT/200/404/400499/OCODE/RE/RT/RBO'>][<RPL-XX queue='in/out/count/lost/rqst_in/rqst_out' net='all/COK/CE/CT/200/4xx/5xx/OCODE/RE/RT/RBO'>]\n");
            if (m_MonLog != NULL)
                ((TLogClass*)m_MonLog)->EnableWrite();
        }

        if (!followshingleslog_name.empty()) {
            m_FollowShinglesLog = new TLogClass(followshingleslog_name, true);
            if (m_FollowShinglesLog != NULL)
                ((TLogClass*)m_FollowShinglesLog)->EnableWrite();
        }

        if (!longrequestlog_name.empty()) {
            m_LongRequestLog = new TLogClass(longrequestlog_name, true);
            if (m_LongRequestLog != NULL)
                ((TLogClass*)m_LongRequestLog)->EnableWrite();
        }
    }

    return res;
}

bool TLogsGroup::TruncLog() {
    bool res = true;

    if (m_ServerLog != NULL)
        if (!m_ServerLog->TruncLog())
            res = false;

    if (m_DebugInfoLog != NULL)
        if (!m_DebugInfoLog->TruncLog())
            res = false;

    if (m_InputLog != NULL)
        if (!m_InputLog->TruncLog())
            res = false;

    if (m_ConvertOldRqstLog != NULL)
        if (!m_ConvertOldRqstLog->TruncLog())
            res = false;

    if (m_SendAnswerLog != NULL)
        if (!m_SendAnswerLog->TruncLog())
            res = false;

    if (m_ProxyLog != NULL)
        if (!m_ProxyLog->TruncLog())
            res = false;

    if (m_ReplicLog != NULL)
        if (!m_ReplicLog->TruncLog())
            res = false;

    if (m_ShinglesLog != NULL)
        if (!m_ShinglesLog->TruncLog())
            res = false;

    if (m_StorageLog != NULL)
        if (!m_StorageLog->TruncLog())
            res = false;

    if (m_MonLog != NULL)
        if (!m_MonLog->TruncLog())
            res = false;

    if (m_FollowShinglesLog != NULL)
        if (!m_FollowShinglesLog->TruncLog())
            res = false;

    if (m_LongRequestLog != NULL)
        if (!m_LongRequestLog->TruncLog())
            res = false;

    return res;
}

void TLogsGroup::DisableFFlush(bool dsb) {
    if (m_ServerLog != NULL)
        m_ServerLog->SetDisableFFlush(dsb);

    if (m_DebugInfoLog != NULL)
        m_DebugInfoLog->SetDisableFFlush(dsb);

    if (m_InputLog != NULL)
        m_InputLog->SetDisableFFlush(dsb);

    if (m_ConvertOldRqstLog != NULL)
        m_ConvertOldRqstLog->SetDisableFFlush(dsb);

    if (m_SendAnswerLog != NULL)
        m_SendAnswerLog->SetDisableFFlush(dsb);

    if (m_ProxyLog != NULL)
        m_ProxyLog->SetDisableFFlush(dsb);

    if (m_ReplicLog != NULL)
        m_ReplicLog->SetDisableFFlush(dsb);

    if (m_ShinglesLog != NULL)
        m_ShinglesLog->SetDisableFFlush(dsb);

    if (m_StorageLog != NULL)
        m_StorageLog->SetDisableFFlush(dsb);

    if (m_MonLog != NULL)
        m_MonLog->SetDisableFFlush(dsb);

    if (m_FollowShinglesLog != NULL)
        m_FollowShinglesLog->SetDisableFFlush(dsb);

    if (m_LongRequestLog != NULL)
        m_LongRequestLog->SetDisableFFlush(dsb);
}

//******************************************************************************************************************************************
