#pragma once

#include <util/generic/string.h>
#include <mail/so/spamstop/tools/so-common/tkinifile.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/tlogsgroupbase.h>

//****************************************************************************************************************************************
//                                              TPrintBuff
//****************************************************************************************************************************************

struct TPrintBuff {
    int printbuffsize;
    char* printbuff;
    int in_printbuff;

    TPrintBuff() {
        printbuffsize = 65000;
        printbuff = new char[printbuffsize];
        in_printbuff = 0;
    }

    ~TPrintBuff() {
        if (printbuff != NULL) {
            delete[] printbuff;
            printbuff = NULL;
        }
    }

    void Clear() {
        memset(printbuff, 0, printbuffsize);
        in_printbuff = 0;
    }
};

//****************************************************************************************************************************************
//                                              TLogsGroup
//****************************************************************************************************************************************

class TLogsGroup: public TLogsGroupBase {
private:
    TKConfig* iniobj;
    TLogClass* m_ServerLog;
    TLogClass* m_DebugInfoLog;
    TLogClass* m_InputLog;
    TLogClass* m_TestLog;
    TLogClass* m_ConvertOldRqstLog;
    TLogClass* m_SendAnswerLog;
    TLogClass* m_ProxyLog;
    TLogClass* m_ReplicLog;
    TLogClass* m_ShinglesLog;
    TLogClass* m_StorageLog;
    TLogClass* m_MonLog;
    TLogClass* m_FollowShinglesLog;
    TLogClass* m_LongRequestLog;
    int sendanswerlog_treshold;

public:
    TLogsGroup();
    ~TLogsGroup();

    bool Init(TKConfig* iniobjA);

    TLogClass* GetServerLog() {
        return m_ServerLog;
    }
    TLogClass* GetDebugInfoLog() {
        return m_DebugInfoLog;
    }
    TLogClass* GetInputLog() {
        return m_InputLog;
    }
    TLogClass* GetTestLog() {
        return m_TestLog;
    }
    TLogClass* GetConvertOldRqstLog() {
        return m_ConvertOldRqstLog;
    }
    TLogClass* GetSendAnswerLog() {
        return m_SendAnswerLog;
    }
    TLogClass* GetProxyLog() {
        return m_ProxyLog;
    }
    TLogClass* GetReplicLog() {
        return m_ReplicLog;
    }
    TLogClass* GetShinglesLog() {
        return m_ShinglesLog;
    }
    TLogClass* GetStorageLog() {
        return m_StorageLog;
    }
    TLogClass* GetMonLog() {
        return m_MonLog;
    }
    TLogClass* GetFollowShinglesLog() {
        return m_FollowShinglesLog;
    }
    TLogClass* GetLongRequestLog() {
        return m_LongRequestLog;
    }
    int GetSendAnswerLogTreshold() {
        return sendanswerlog_treshold;
    }

    bool TruncLog();
    void DisableFFlush(bool dsb);
};

//******************************************************************************************************************************************
