#include "tmakerequest.h"

TMakeRequest::TMakeRequest(TServiceObjectBase& srvcobjA, void* serverA)
    : TMakeRequestBase(srvcobjA, serverA) {
    // команда запроса берется до символа '?', если её нет в указанном ниже списке, то команда берется из поля action
    // запроса, если же поля action нет, то командой запроса считается console
    AllowList.push_back("info");
    AllowList.push_back("sh=get");
    AllowList.push_back("st=get");
    AllowList.push_back("sh=put");
    AllowList.push_back("shinrqst");
    AllowList.push_back("shinprx");
    AllowList.push_back("shrpl");
    AllowList.push_back("st=load");
    AllowList.push_back("stload");
    AllowList.push_back("setlongrqst");
    AllowList.push_back("rotatelogs");
}

TMakeRequest::~TMakeRequest() {
}

void TMakeRequest::Midnight(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    if ((srvcobj.GetGeneralObject() != NULL)) {
        srvcobj.GetGeneralObject()->Midnight();

        text = text + "Midnight command accepted<br>";
        text = text + "<A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A>";
        SendToClient(SO_LOG_MESSAGE, 200, text, id);
    }
}

void TMakeRequest::Shutdown(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    srvcobj.GetGeneralObject()->Shutdown();

    text = text + "<html><head>";
    text = text + "<meta http-equiv='refresh' content='3; url=" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>";
    text = text + "</head><body bgcolor=palegoldenrod>\n";
    text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
    text = text + "<tr><td valign='top'>Shutdown command accepted.</td></tr>";
    text = text + "</table></body></html>";

    SendToClient(SO_LOG_MESSAGE, 200, text, id);
}

bool TMakeRequest::ActionWOParse(const TString& Ident, TRequestDopData& data, const TString& InRequest, const TString& NumbRequest, const TString& request_source, int thread_index) {
    bool res = false;
    bool int_srv_error = false;
    ui32 delayms = 0;
    TShingleStorageMain::TWStroka result;

    if ((Ident == "sh=get") || (Ident == "st=get") || (Ident == "sh=put")) {
        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
            if (GetGeneralObject()->ShinglesStorage->GetOldTrafficControl() != NULL) {
                if (GetGeneralObject()->ShinglesStorage->GetOldTrafficControl()->Skeep()) {
                    SendToClientRAW(HTTP_503_SERVICE_UNAVAILABLE());
                } else {
                    // пишем полный запрос в лог
                    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (InputLog != NULL))
                        InputLog->WriteMessageAndData("<begin %s>%s<end>\n", NumbRequest.c_str(), request_source.c_str());

                    // обрабатываем запрос InRequest
                    delayms = CShingleTime::GetMs();
                    if (GetGeneralObject()->ShinglesStorage->ParseRequestOld(NumbRequest, InRequest.c_str(), result, m_remote_ip, thread_index)) {
                        delayms = CShingleTime::GetMs() - delayms;
                        SendToClientRAW(HTTP_200_OK(NumbRequest) + result.m_answer);
                        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetSendAnswerLog() != NULL) && (delayms >= GetLogsGroup()->GetSendAnswerLogTreshold()))
                            GetLogsGroup()->GetSendAnswerLog()->WriteMessageAndDataStatus(KMESSAGE, "%u %s OLDRQST{%s}, RSPNC{%s}\n", delayms, NumbRequest.c_str(), InRequest.c_str(), result.m_answer.c_str());
                    } else {
                        delayms = CShingleTime::GetMs() - delayms;
                        SendToClientRAW(HTTP_400_BAD_REQUEST(NumbRequest) + result.m_answer);
                        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetSendAnswerLog() != NULL) && (delayms >= GetLogsGroup()->GetSendAnswerLogTreshold()))
                            GetLogsGroup()->GetSendAnswerLog()->WriteMessageAndDataStatus(KERROR, "%u %s BAD_OLDREQUEST{%s}\n", delayms, NumbRequest.c_str(), InRequest.c_str());
                    }
                }

            } else
                int_srv_error = true;
        } else
            int_srv_error = true;

        if (int_srv_error) {
            SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetSendAnswerLog() != NULL))
                GetLogsGroup()->GetSendAnswerLog()->WriteMessageAndDataStatus(KERROR, "%s OLDRQST INTERNAL_SERVER_ERROR\n", NumbRequest.c_str());
        }

        // возвращаем ответ, чтобы не обрабатывать дальше
        res = true;

    } else if ((Ident == "shinrqst") || (Ident == "shinprx") || (Ident == "shrpl")) {
        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
            TTrafficControl* traffctrl = NULL;

            if (Ident == "shrpl")
                traffctrl = GetGeneralObject()->ShinglesStorage->GetRplTrafficControlRequest();
            else if (Ident == "shinprx")
                traffctrl = GetGeneralObject()->ShinglesStorage->GetPrxTrafficControl();
            else {
                traffctrl = GetGeneralObject()->ShinglesStorage->GetNewTrafficControl();

                //debug!!!!
                /*if (srvcobj.Port() == "9001")
            {
               ui32 tick1 = CShingleTime::GetMs();
               Sleep(1000);
               tick1 = CShingleTime::GetMs() - tick1;
               printf("DEBUG mode ACTIVATED (%u ms)!!!\n", tick1);
            }*/
            }

            if (traffctrl != NULL) {
                if (traffctrl->Skeep()) {
                    SendToClientRAW(HTTP_503_SERVICE_UNAVAILABLE());
                } else {
                    // пишем полный запрос в лог
                    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (InputLog != NULL))
                        InputLog->WriteMessageAndData("<begin %s>%s<end>\n", NumbRequest.c_str(), request_source.c_str());

                    // обрабатываем запрос InRequest
                    delayms = CShingleTime::GetMs();
                    if (GetGeneralObject()->ShinglesStorage->ParseRequest(NumbRequest, InRequest.c_str(), result, m_remote_ip, thread_index)) {
                        delayms = CShingleTime::GetMs() - delayms;
                        SendToClientRAW(HTTP_200_OK(NumbRequest, delayms) + result.m_answer);
                        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetSendAnswerLog() != NULL) && (delayms >= GetLogsGroup()->GetSendAnswerLogTreshold()))
                            GetLogsGroup()->GetSendAnswerLog()->WriteMessageAndDataStatus(KMESSAGE, "%u %s RQST{%s}, RSPNC{%s}\n", delayms, NumbRequest.c_str(), InRequest.c_str(), result.m_answer.c_str());
                    } else {
                        delayms = CShingleTime::GetMs() - delayms;
                        SendToClientRAW(HTTP_400_BAD_REQUEST(NumbRequest, delayms) + result.m_answer);
                        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetSendAnswerLog() != NULL) && (delayms >= GetLogsGroup()->GetSendAnswerLogTreshold()))
                            GetLogsGroup()->GetSendAnswerLog()->WriteMessageAndDataStatus(KERROR, "%u %s BAD_REQUEST{%s}\n", delayms, NumbRequest.c_str(), InRequest.c_str());
                    }
                }

            } else
                int_srv_error = true;
        } else
            int_srv_error = true;

        if (int_srv_error) {
            SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetSendAnswerLog() != NULL))
                GetLogsGroup()->GetSendAnswerLog()->WriteMessageAndDataStatus(KERROR, "%s INTERNAL_SERVER_ERROR\n", NumbRequest.c_str());
        }

        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
            if (Ident == "shrpl") {
                GetGeneralObject()->ShinglesStorage->GetRplDelayObj()->Increment(delayms);
                GetGeneralObject()->ShinglesStorage->GetRplDelayObjDays()->Increment(delayms);

            } else if (Ident == "shinprx") {
                GetGeneralObject()->ShinglesStorage->GetPrxDelayObj()->Increment(delayms);

            } else {
                GetGeneralObject()->ShinglesStorage->GetClusterDelayObj()->Increment(delayms);
                GetGeneralObject()->ShinglesStorage->GetClusterDelayObjDays()->Increment(delayms);
            }
        }

// если запрос долго обрабытывается, пишем его в лог
#ifdef SOSERV_DEBUG
        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL) && (delayms > GetGeneralObject()->ShinglesStorage->GetLongDelayMs()) && (GetLogsGroup() != NULL) && (GetLogsGroup()->GetLongRequestLog() != NULL))
            GetLogsGroup()->GetLongRequestLog()->WriteMessageAndDataStatus(KERROR, "%u %s LONG_REQUEST{%s} TRACE{%s}\n", delayms, NumbRequest.c_str(), InRequest.c_str(), result.m_debug.c_str());
#endif

        // возвращаем ответ, чтобы не обрабатывать дальше
        res = true;
    }

    return res;
}

bool TMakeRequest::ActionParse(const TString& Ident, TRequestDopData& data, TReqParams* m_ReqParams, const TString& NumbRequest, const TString& requrl, int thread_index) {
    bool res = false;

    if (Ident == "clrshingle") {
        ClearShingleInfo("-", m_ReqParams);
        res = true;
    }
    if ((!res)) // с правами обычного пользователя
    {
        if (Ident == "writedump") //admin
        {
            Writedump("-", m_ReqParams);
            res = true;

        } else if (Ident == "askwritedump") //admin
        {
            AskWritedump("-", m_ReqParams);
            res = true;

        } else if (Ident == "askcleanup") //admin
        {
            AskCleanup("-", m_ReqParams);
            res = true;

        } else if (Ident == "cleanup") //admin
        {
            Cleanup("-", m_ReqParams);
            res = true;

        } else if (Ident == "setlongrqst") {
            SetLongRequest("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewproxystat") {
            ViewProxyStat("-");
            res = true;

        } else if (Ident == "viewshinglesstat") {
            ViewShinglesStat("-");
            res = true;

        } else if (Ident == "viewshinglesst_m") {
            ViewShinglesStat2("-");
            res = true;

        } else if (Ident == "viewshinglesst_b") {
            ViewShinglesStatBusy("-");
            res = true;

        } else if (Ident == "viewtypestat") {
            ViewTypeStat("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewshingleinfo") {
            ViewShingleInfo("-", m_ReqParams);
            res = true;

        } else if (Ident == "askuclearshingleinfo") {
            AskClearShingleInfo("-", m_ReqParams);
            res = true;

        } else if (Ident == "uclearshingleinfo") {
            ClearShingleInfo("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewstshinfo") {
            ViewStorageShingleInfo("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewrplstat") {
            ViewRPLStat("-", m_ReqParams);
            res = true;

        } else if ((Ident == "st=load") || (Ident == "stload")) {
            LoadSimpleStorage("-");
            res = true;

        } else if (Ident == "addfollowsh") {
            AddFollowShingles("-", m_ReqParams);
            res = true;

        } else if (Ident == "delfollowsh") {
            DelFollowShingles("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewfollowsh") {
            ViewFollowShingles("-");
            res = true;
        }
    }

    return res;
}

void TMakeRequest::Console(const TString& id, TReqParams* m_ReqParams) {
    char CurTime[CShingleTime::MAX_TIME_SIZE];
    ui32 BeginProcessTime = CShingleTime::GetMs();
    CShingleTime::GetTimeStr(CurTime);
    char* table_color = "'#ffffcc'";
    char* cell_color_today = "PaleGoldenrod";
    char* cell_color_history = "PaleGoldenrod";
    char* cell_color = "PaleGoldenrod";
    TString text = "";
    TTrafficControl* traffcontl = NULL;
    TTrafficCounter* traffcount = NULL;
    TString sregime = "";
    TString srvrmode = "";
    TString dbglink = "";
    TProxyStatData statdata;
    TRPLStatDataSummary statdatarpl;

    if (GetGeneralObject() != NULL) {
        switch (GetGeneralObject()->GetServerMode()) {
            case MSHINGLER:
                srvrmode = "REPLICA SHINGLER";
                break;
            case MPROXY:
                srvrmode = "PROXY SHINGLER";
                break;
            default:
                srvrmode = "UNKNOWN";
        };
    }

    if (LogsGroup != NULL) {
        if (LogsGroup->GetDebugMode())
            dbglink = "enabled (<A href='" + GetHost() + GetModuleName("dsbdbgmode") + GetActionOneParam("dsbdbgmode") + "'>disable</A>)";
        else
            dbglink = "disabled (<A href='" + GetHost() + GetModuleName("enbdbgmode") + GetActionOneParam("enbdbgmode") + "'>enable</A>)";
    }

    {
        text = text + "<i><b>Server control:</b></i>&nbsp;&nbsp;";
        text = text + "<A href='" + GetHost() + GetModuleName("askshutdown") + GetActionOneParam("askshutdown") + "'>Shutdown</A> &nbsp; ";
        text = text + "<A href='" + GetHost() + GetModuleName("askmidnight") + GetActionOneParam("askmidnight") + "'>Midnight</A> &nbsp; ";
        text = text + "<A href='" + GetHost() + GetModuleName("rotatelogs") + GetActionOneParam("rotatelogs") + "'>Rotate logs</A> &nbsp; ";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        text = text + "<tr valign='top'><td valign='left' width='30%'>Version</td><td>" + m_servername + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='30%'>Mode</td><td>" + srvrmode + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='30%'>Server ID</td><td>" + GetServerIdent() + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='30%'>Port</td><td>" + srvcobj.Port() + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='30%'>Start time</td><td>" + m_StartTime + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='30%'>Current time</td><td>" + TString(CurTime) + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='30%'>Debug mode</td><td>" + dbglink + "</td></tr>";
        text = text + "</table>";

        text = text + "<br><i><b>Statistiks of request with clusters (OLD):</b></i>&nbsp;&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
            // old request traffic control
            traffcontl = GetGeneralObject()->ShinglesStorage->GetOldTrafficControl();
            if (traffcontl != NULL) {
                if ((traffcontl->GetSkeepRegime()) && (traffcontl->GetKoef() != 1))
                    text = text + "<tr valign='top'><td align='left' width='30%'>Traffic statistic, RequestPerSec (OLD)</td><td bgcolor='LightSalmon'>\n" + traffcontl->GetStatist() + sregime + "</td></tr>\n";
                else
                    text = text + "<tr valign='top'><td align='left' width='30%'>Traffic statistic, RequestPerSec (OLD)</td><td>\n" + traffcontl->GetStatist() + sregime + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>Request count (today / yesterday) (OLD)</td><td>\n" + UI64ToStroka(traffcontl->GetTodayRequest()) + " / " + UI64ToStroka(traffcontl->GetYesterdayRequest()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>Lost request (today / yesterday) (OLD)</td><td>\n" + UI64ToStroka(traffcontl->GetTodayLostRequest()) + " / " + UI64ToStroka(traffcontl->GetYesterdayLostRequest()) + "</td></tr>\n";
            }
            // other counters
            traffcount = GetGeneralObject()->ShinglesStorage->GetShGetTrafficControlOld();
            if (traffcount != NULL)
                text = text + "<tr valign='top'><td align='left' width='30%'>SHGET shingles_per_sec, shingles count (today / yesterday)</td><td>\n" + FloatToStr(traffcount->GetCPS()) + ", " + UI64ToStroka(traffcount->GetTodayRequest()) + " / " + UI64ToStroka(traffcount->GetYesterdayRequest()) + "</td></tr>\n";

            traffcount = GetGeneralObject()->ShinglesStorage->GetShPutTrafficControlOld();
            if (traffcount != NULL)
                text = text + "<tr valign='top'><td align='left' width='30%'>SHPUT shingles_per_sec, shingles count (today / yesterday)</td><td>\n" + FloatToStr(traffcount->GetCPS()) + ", " + UI64ToStroka(traffcount->GetTodayRequest()) + " / " + UI64ToStroka(traffcount->GetYesterdayRequest()) + "</td></tr>\n";

            traffcount = GetGeneralObject()->ShinglesStorage->GetStGetTrafficControlOld();
            if (traffcount != NULL)
                text = text + "<tr valign='top'><td align='left' width='30%'>STGET shingles_per_sec, shingles count (today / yesterday)</td><td>\n" + FloatToStr(traffcount->GetCPS()) + ", " + UI64ToStroka(traffcount->GetTodayRequest()) + " / " + UI64ToStroka(traffcount->GetYesterdayRequest()) + "</td></tr>\n";
        }
        text = text + "</table>";

        text = text + "<br><i><b>Statistiks of request with clusters (NEW):</b></i>&nbsp;&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
            // new request traffic control
            traffcontl = GetGeneralObject()->ShinglesStorage->GetNewTrafficControl();
            if (traffcontl != NULL) {
                if ((traffcontl->GetSkeepRegime()) && (traffcontl->GetKoef() != 1))
                    text = text + "<tr valign='top'><td align='left' width='30%'>Traffic statistic, RequestPerSec (NEW)</td><td bgcolor='LightSalmon'>\n" + traffcontl->GetStatist() + sregime + "</td></tr>\n";
                else
                    text = text + "<tr valign='top'><td align='left' width='30%'>Traffic statistic, RequestPerSec (NEW)</td><td>\n" + traffcontl->GetStatist() + sregime + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>Request count (today / yesterday) (NEW)</td><td>\n" + UI64ToStroka(traffcontl->GetTodayRequest()) + " / " + UI64ToStroka(traffcontl->GetYesterdayRequest()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>Lost request (today / yesterday) (NEW)</td><td>\n" + UI64ToStroka(traffcontl->GetTodayLostRequest()) + " / " + UI64ToStroka(traffcontl->GetYesterdayLostRequest()) + "</td></tr>\n";
            }
            // other counters
            traffcount = GetGeneralObject()->ShinglesStorage->GetShGetTrafficControlNew();
            if (traffcount != NULL)
                text = text + "<tr valign='top'><td align='left' width='30%'>SHGET shingles_per_sec, shingles count (today / yesterday)</td><td>\n" + FloatToStr(traffcount->GetCPS()) + ", " + UI64ToStroka(traffcount->GetTodayRequest()) + " / " + UI64ToStroka(traffcount->GetYesterdayRequest()) + "</td></tr>\n";

            traffcount = GetGeneralObject()->ShinglesStorage->GetShPutTrafficControlNew();
            if (traffcount != NULL)
                text = text + "<tr valign='top'><td align='left' width='30%'>SHPUT shingles_per_sec, shingles count (today / yesterday)</td><td>\n" + FloatToStr(traffcount->GetCPS()) + ", " + UI64ToStroka(traffcount->GetTodayRequest()) + " / " + UI64ToStroka(traffcount->GetYesterdayRequest()) + "</td></tr>\n";

            traffcount = GetGeneralObject()->ShinglesStorage->GetStGetTrafficControlNew();
            if (traffcount != NULL)
                text = text + "<tr valign='top'><td align='left' width='30%'>STGET shingles_per_sec, shingles count (today / yesterday)</td><td>\n" + FloatToStr(traffcount->GetCPS()) + ", " + UI64ToStroka(traffcount->GetTodayRequest()) + " / " + UI64ToStroka(traffcount->GetYesterdayRequest()) + "</td></tr>\n";
        }
        text = text + "</table>";

        text = text + "<br><i><b>Statistiks of request (REPLIC):</b></i>&nbsp;&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
            traffcontl = GetGeneralObject()->ShinglesStorage->GetRplTrafficControlRequest();
            if (traffcontl != NULL) {
                if ((traffcontl->GetSkeepRegime()) && (traffcontl->GetKoef() != 1))
                    text = text + "<tr valign='top'><td align='left' width='30%'>Traffic statistic, RequestPerSec (RPL)</td><td bgcolor='LightSalmon'>\n" + traffcontl->GetStatist() + sregime + "</td></tr>\n";
                else
                    text = text + "<tr valign='top'><td align='left' width='30%'>Traffic statistic, RequestPerSec (RPL)</td><td>\n" + traffcontl->GetStatist() + sregime + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>Request count (today / yesterday) (RPL)</td><td>\n" + UI64ToStroka(traffcontl->GetTodayRequest()) + " / " + UI64ToStroka(traffcontl->GetYesterdayRequest()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>Lost request (today / yesterday) (RPL)</td><td>\n" + UI64ToStroka(traffcontl->GetTodayLostRequest()) + " / " + UI64ToStroka(traffcontl->GetYesterdayLostRequest()) + "</td></tr>\n";
            }
            traffcount = GetGeneralObject()->ShinglesStorage->GetRplTrafficControlShingles();
            if (traffcount != NULL)
                text = text + "<tr valign='top'><td align='left' width='30%'>RPL shingles_per_sec, shingles count (today / yesterday)</td><td>\n" + FloatToStr(traffcount->GetCPS()) + ", " + UI64ToStroka(traffcount->GetTodayRequest()) + " / " + UI64ToStroka(traffcount->GetYesterdayRequest()) + "</td></tr>\n";
        }
        text = text + "</table>";

        text = text + "<br><i><b>Statistiks of request (PROXY):</b></i>&nbsp;&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
            traffcontl = GetGeneralObject()->ShinglesStorage->GetPrxTrafficControl();
            if (traffcontl != NULL) {
                if ((traffcontl->GetSkeepRegime()) && (traffcontl->GetKoef() != 1))
                    text = text + "<tr valign='top'><td align='left' width='30%'>Traffic statistic, RequestPerSec (PRX)</td><td bgcolor='LightSalmon'>\n" + traffcontl->GetStatist() + sregime + "</td></tr>\n";
                else
                    text = text + "<tr valign='top'><td align='left' width='30%'>Traffic statistic, RequestPerSec (PRX)</td><td>\n" + traffcontl->GetStatist() + sregime + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>Request count (today / yesterday) (PRX)</td><td>\n" + UI64ToStroka(traffcontl->GetTodayRequest()) + " / " + UI64ToStroka(traffcontl->GetYesterdayRequest()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>Lost request (today / yesterday) (PRX)</td><td>\n" + UI64ToStroka(traffcontl->GetTodayLostRequest()) + " / " + UI64ToStroka(traffcontl->GetYesterdayLostRequest()) + "</td></tr>\n";
            }
            traffcount = GetGeneralObject()->ShinglesStorage->GetPrxGetTrafficControl();
            if (traffcount != NULL)
                text = text + "<tr valign='top'><td align='left' width='30%'>PROXYGET shingles_per_sec, request count (today / yesterday)</td><td>\n" + FloatToStr(traffcount->GetCPS()) + ", " + UI64ToStroka(traffcount->GetTodayRequest()) + " / " + UI64ToStroka(traffcount->GetYesterdayRequest()) + "</td></tr>\n";

            traffcount = GetGeneralObject()->ShinglesStorage->GetPrxPutTrafficControl();
            if (traffcount != NULL)
                text = text + "<tr valign='top'><td align='left' width='30%'>PROXYPUT shingles_per_sec, request count (today / yesterday)</td><td>\n" + FloatToStr(traffcount->GetCPS()) + ", " + UI64ToStroka(traffcount->GetTodayRequest()) + " / " + UI64ToStroka(traffcount->GetYesterdayRequest()) + "</td></tr>\n";
        }
        text = text + "</table>";

        if (GetGeneralObject() != NULL) {
            if (GetGeneralObject()->GetServerMode() == MPROXY) //PROXY
            {
                if (GetGeneralObject()->PoolProxy != NULL) {
                    ui64 today_err = 0;
                    ui64 yesterday_err = 0;

                    statdata = GetGeneralObject()->PoolProxy->GetStat();

                    today_err = statdata.today.connect_error + statdata.today.connect_timeout + statdata.today.request_404_count + statdata.today.request_400500_count + statdata.today.request_other_count + statdata.today.request_error + statdata.today.request_timeout + statdata.today.request_buffer_overflow;
                    yesterday_err = statdata.yesterday.connect_error + statdata.yesterday.connect_timeout + statdata.yesterday.request_404_count + statdata.yesterday.request_400500_count + statdata.yesterday.request_other_count + statdata.yesterday.request_error + statdata.yesterday.request_timeout + statdata.yesterday.request_buffer_overflow;

                    text = text + "<br><i><b>Statistiks proxy:</b></i>&nbsp;&nbsp;";
                    text = text + "<A href='" + GetHost() + GetModuleName("viewproxystat") + GetActionOneParam("viewproxystat") + "' target='_blank'>ProxyStatistik</A> &nbsp; ";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
                    if (statdata.cycle_itself)
                        text = text + "<tr valign='top'><td align='center' colspan='2' bgcolor='LightSalmon'>Cycle itself</td></tr>\n";
                    text = text + "<tr valign='top'><td align='left' width='30%'>Request count (today / yesterday)</td><td>\n" + IntToStroka(statdata.today.all_mail_count) + " / " + IntToStroka(statdata.yesterday.all_mail_count) + "</td></tr>\n";
                    text = text + "<tr valign='top'><td align='left' width='30%'>Request 200 OK (today / yesterday)</td><td>\n" + IntToStroka(statdata.today.request_200_count) + " / " + IntToStroka(statdata.yesterday.request_200_count) + "</td></tr>\n";
                    text = text + "<tr valign='top'><td align='left' width='30%'>Bad request (today / yesterday)</td><td>\n" + IntToStroka(today_err) + " / " + IntToStroka(yesterday_err) + "</td></tr>\n";
                    text = text + "<tr valign='top'><td align='left' width='30%'>Queue count</td><td>\n" + IntToStroka(statdata.today.queue_count) + "</td></tr>\n";
                    text = text + "</table>";
                }

            } else // SHINGLER
            {
                if (GetGeneralObject()->PoolRPL != NULL) {
                    TString typelink = "";

                    statdatarpl = GetGeneralObject()->PoolRPL->GetStat();

                    text = text + "<br><i><b>Replic statistik:</b></i>&nbsp;&nbsp;";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
                    text = text + "<tr valign='top'>";
                    text = text + "<td align='left' width='5%'>&nbsp;</td>";
                    text = text + "<td align='left' width='19%'><b>REPLIC URL</b></td>";
                    text = text + "<td align='left' width='6%'><b>RemSrvID</b></td>";
                    text = text + "<td align='left' width='25%'><b>QUEUE: IN / UPDATE / COUNT / LOST / OUT</b></td>";
                    text = text + "<td align='left' width='22%'><b>CONNECT: OK / ERROR / TIMEOUT</b></td>";
                    text = text + "<td align='left' width='23%'><b>REQUEST: 200 / 4XX / 5XX / ERROR / TIMEOT</b></td>";
                    text = text + "</tr>\n";
                    for (int i = 0; i < statdatarpl.max_count; i++) {
                        if (statdatarpl.data[i].enable_client) {
                            typelink = "<A href='" + GetHost() + GetModuleName("viewrplstat") + GetActionOneParam("viewrplstat") + "&type=" + IntToStroka(i) + "' target='_blank'>DIR-" + IntToStroka2(i + 1) + "</A>";
                            text = text + "<tr valign='top'>";
                            text = text + "<td align='left' rowspan='2'>" + typelink + "</td>";
                            text = text + "<td align='left' rowspan='2'>" + statdatarpl.data[i].host + "</td>";
                            text = text + "<td align='center'>" + statdatarpl.data[i].remote_srvid + "&nbsp;</td>";
                            text = text + "<td align='left'>" + IntToStroka(statdatarpl.data[i].today.queue_in) + " / " + IntToStroka(statdatarpl.data[i].today.queue_up) + " / " + IntToStroka(statdatarpl.data[i].today.queue_count) + " / " + IntToStroka(statdatarpl.data[i].today.queue_lost) + " / " + IntToStroka(statdatarpl.data[i].today.queue_out) + "</td>";
                            text = text + "<td align='left'>" + IntToStroka(statdatarpl.data[i].today.connect_ok) + " / " + IntToStroka(statdatarpl.data[i].today.connect_error) + " / " + IntToStroka(statdatarpl.data[i].today.connect_timeout) + "</td>";
                            text = text + "<td align='left'>" + IntToStroka(statdatarpl.data[i].today.request_200_count) + " / " + IntToStroka(statdatarpl.data[i].today.request_4xx_count) + " / " + IntToStroka(statdatarpl.data[i].today.request_5xx_count) + " / " + IntToStroka(statdatarpl.data[i].today.request_error) + " / " + IntToStroka(statdatarpl.data[i].today.request_timeout) + "</td>";
                            text = text + "</tr>\n";
                            text = text + "<tr valign='top'>";
                            // text = text + "<td align='left'>&nbsp;</td>";
                            // text = text + "<td align='left'>&nbsp;</td>";
                            text = text + "<td align='center'>yesterday</td>";
                            text = text + "<td align='left'>" + IntToStroka(statdatarpl.data[i].yesterday.queue_in) + " / " + IntToStroka(statdatarpl.data[i].yesterday.queue_up) + " / " + IntToStroka(statdatarpl.data[i].yesterday.queue_count) + " / " + IntToStroka(statdatarpl.data[i].yesterday.queue_lost) + " / " + IntToStroka(statdatarpl.data[i].yesterday.queue_out) + "</td>";
                            text = text + "<td align='left'>" + IntToStroka(statdatarpl.data[i].yesterday.connect_ok) + " / " + IntToStroka(statdatarpl.data[i].yesterday.connect_error) + " / " + IntToStroka(statdatarpl.data[i].yesterday.connect_timeout) + "</td>";
                            text = text + "<td align='left'>" + IntToStroka(statdatarpl.data[i].yesterday.request_200_count) + " / " + IntToStroka(statdatarpl.data[i].yesterday.request_4xx_count) + " / " + IntToStroka(statdatarpl.data[i].yesterday.request_5xx_count) + " / " + IntToStroka(statdatarpl.data[i].yesterday.request_error) + " / " + IntToStroka(statdatarpl.data[i].yesterday.request_timeout) + "</td>";
                            text = text + "</tr>\n";
                        }
                    }
                    text = text + "</table>";
                }
            }

            if (GetGeneralObject()->SimpleStorage != NULL) {
                TSimpleStorageStat shstat = GetGeneralObject()->SimpleStorage->GetStat();

                TString viewstshingleinfo = "<form action='" + GetHost() + GetModuleName("viewstshinfo") + "' method='GET' enctype='text/plain' target='_blank'>&nbsp; shingle=<input type='text' size='30' name='shingle' value=''>&nbsp; " + GetActionFormParam("viewstshinfo") + "<input type='submit' size='10' value='view'></form>\n";

                text = text + "<br><i><b>Statistiks simple storage:</b></i>&nbsp;";
                text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
                text = text + "<tr valign='top'><td align='left' width='30%'>Last load event</td><td>\n" + shstat.last_load_stat + " &nbsp;</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>Record count</td><td>\n<br>" + IntToStroka(shstat.record_count) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='30%'>View shingle info</td><td>\n<br>" + viewstshingleinfo + "</td></tr>\n";
                text = text + "</table>";
            }

            if (GetGeneralObject()->ShinglesStorage != NULL) {
                TShingleStorageStat shstat;
                time_t remainwritedump = 0;

                GetGeneralObject()->ShinglesStorage->GetStat(shstat);

                remainwritedump = shstat.lastwritedumpevent + shstat.periodwritedumpsec - time(NULL);

                TString viewshingleinfo = "<form action='" + GetHost() + GetModuleName("viewshingleinfo") + "' method='GET' enctype='text/plain' target='_blank'>&nbsp; shingle=<input type='text' size='30' name='shingle' value=''>&nbsp; type=<input type='text' size='10' name='type' value=''> &nbsp; " + GetActionFormParam("viewshingleinfo") + "<input type='submit' size='10' value='view'></form>\n";

                text = text + "<br><i><b>Statistiks shingles storage:</b></i>&nbsp;";
                text = text + "&nbsp;<A href='" + GetHost() + GetModuleName("viewshinglesstat") + GetActionOneParam("viewshinglesstat") + "' target='_blank'>Short statistik all types</A>";
                text = text + "&nbsp;<A href='" + GetHost() + GetModuleName("viewshinglesst_m") + GetActionOneParam("viewshinglesst_m") + "' target='_blank'>ShortEx statistik all types</A>";
                text = text + "&nbsp;<A href='" + GetHost() + GetModuleName("viewshinglesst_b") + GetActionOneParam("viewshinglesst_b") + "' target='_blank'>Busy statistik all types</A>";
                text = text + "&nbsp;<A href='" + GetHost() + GetModuleName("askwritedump") + GetActionOneParam("askwritedump") + "'>Writedump</A>";
                text = text + "&nbsp;<A href='" + GetHost() + GetModuleName("askcleanup") + GetActionOneParam("askcleanup") + "'>Cleanup</A>";
                text = text + "&nbsp;<A href='" + GetHost() + GetModuleName("viewfollowsh") + GetActionOneParam("viewfollowsh") + "' target='_blank'>View_follow_shingles</A>";
                text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
                text = text + "<tr valign='top'><td align='left' width='30%'>All shingles in storage (today / yesterday / heavy)</td><td>\n" + UI64ToStroka(shstat.TodayCountSummary()) + " / " + UI64ToStroka(shstat.YesterdayCountSummary()) + " / " + UI64ToStroka(shstat.HeavyCountSummary()) + "</td></tr>\n";
                if (shstat.writedumptype == 0)
                    text = text + "<tr valign='top'><td align='left' width='30%'>Last write dump event / period auto write dump</td><td>\n" + TimeToStr(shstat.lastwritedumpevent) + " / " + IntToStroka(remainwritedump) + " (" + IntToStroka(shstat.periodwritedumpsec) + ") sec</td></tr>\n";
                else if (shstat.writedumptype == 1)
                    text = text + "<tr valign='top'><td align='left' width='30%'>Write dump</td><td>slow type, T=" + IntToStroka(shstat.periodwritedumpsec_slow) + " sec</td></tr>\n";

                text = text + "<tr valign='top'><td align='left' width='30%'>View shingle info</td><td>\n<br>" + viewshingleinfo + "</td></tr>\n";
                text = text + "</table>";
            }
        }

#ifdef SOSERV_DEBUG
        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL) && (GetGeneralObject()->ShinglesStorage->GetRplDelayObjDays() != NULL) && (GetGeneralObject()->ShinglesStorage->GetClusterDelayObjDays() != NULL)) {
            TDelayByPartStat clust_data_days_t, clust_data_days_y, rpl_data_days_t, rpl_data_days_y;
            TShingleStat shstat;

            rpl_data_days_t = GetGeneralObject()->ShinglesStorage->GetRplDelayObjDays()->GetToday();
            rpl_data_days_y = GetGeneralObject()->ShinglesStorage->GetRplDelayObjDays()->GetYesterday();
            clust_data_days_t = GetGeneralObject()->ShinglesStorage->GetClusterDelayObjDays()->GetToday();
            clust_data_days_y = GetGeneralObject()->ShinglesStorage->GetClusterDelayObjDays()->GetYesterday();

            text = text + "<br><i><b>Debug info:</b></i>&nbsp;";
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
            text = text + "<tr valign='top'><td align='left' width='30%'>Find shingle period in pair shingle</td><td colspan='4'>" + shstat.UniqShinglePeriod() + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>Long request (ms)</td><td colspan='4'>" + IntToStroka(GetGeneralObject()->ShinglesStorage->GetLongDelayMs()) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>Request time:</td><td colspan='2' align='center'><b>CLUSTER</b></td><td colspan='2' align='center'><b>REPLIC</b></td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>&nbsp;</td><td align='center'><b>TODAY</b></td><td align='center'><b>YESTERDAY</b></td><td align='center'><b>TODAY</b></td><td align='center'><b>YESTERDAY</b></td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>0 - 10 ms</td><td>" + IntToStroka(clust_data_days_t.m_0_10) + "</td><td>" + IntToStroka(clust_data_days_y.m_0_10) + "</td><td>" + IntToStroka(rpl_data_days_t.m_0_10) + "</td><td>" + IntToStroka(rpl_data_days_y.m_0_10) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>10 - 20 ms</td><td>" + IntToStroka(clust_data_days_t.m_10_20) + "</td><td>" + IntToStroka(clust_data_days_y.m_10_20) + "</td><td>" + IntToStroka(rpl_data_days_t.m_10_20) + "</td><td>" + IntToStroka(rpl_data_days_y.m_10_20) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>20 - 30 ms</td><td>" + IntToStroka(clust_data_days_t.m_20_30) + "</td><td>" + IntToStroka(clust_data_days_y.m_20_30) + "</td><td>" + IntToStroka(rpl_data_days_t.m_20_30) + "</td><td>" + IntToStroka(rpl_data_days_y.m_20_30) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>30 - 40 ms</td><td>" + IntToStroka(clust_data_days_t.m_30_40) + "</td><td>" + IntToStroka(clust_data_days_y.m_30_40) + "</td><td>" + IntToStroka(rpl_data_days_t.m_30_40) + "</td><td>" + IntToStroka(rpl_data_days_y.m_30_40) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>40 - 50 ms</td><td>" + IntToStroka(clust_data_days_t.m_40_50) + "</td><td>" + IntToStroka(clust_data_days_y.m_40_50) + "</td><td>" + IntToStroka(rpl_data_days_t.m_40_50) + "</td><td>" + IntToStroka(rpl_data_days_y.m_40_50) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>50 - 100 ms</td><td>" + IntToStroka(clust_data_days_t.m_50_100) + "</td><td>" + IntToStroka(clust_data_days_y.m_50_100) + "</td><td>" + IntToStroka(rpl_data_days_t.m_50_100) + "</td><td>" + IntToStroka(rpl_data_days_y.m_50_100) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>100 - 195 ms</td><td>" + IntToStroka(clust_data_days_t.m_100_200) + "</td><td>" + IntToStroka(clust_data_days_y.m_100_200) + "</td><td>" + IntToStroka(rpl_data_days_t.m_100_200) + "</td><td>" + IntToStroka(rpl_data_days_y.m_100_200) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>195 - 500 ms</td><td>" + IntToStroka(clust_data_days_t.m_200_500) + "</td><td>" + IntToStroka(clust_data_days_y.m_200_500) + "</td><td>" + IntToStroka(rpl_data_days_t.m_200_500) + "</td><td>" + IntToStroka(rpl_data_days_y.m_200_500) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>more 500 ms</td><td>" + IntToStroka(clust_data_days_t.m_more500) + "</td><td>" + IntToStroka(clust_data_days_y.m_more500) + "</td><td>" + IntToStroka(rpl_data_days_t.m_more500) + "</td><td>" + IntToStroka(rpl_data_days_y.m_more500) + "</td></tr>\n";
            text = text + "</table>";
        }
#endif

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);
    }
}

void TMakeRequest::ExtConsole(const TString& id, TReqParams* m_ReqParams) {
    Console(id, m_ReqParams);
}

void TMakeRequest::ViewProxyStat(const TString& id) {
    TString text = "";
    TProxyStatData statdata;
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    ui32 today_all = 0, yesterday_all = 0;
    ui32 today_all_heavy = 0, yesterday_all_heavy = 0;
    TString reloadlink = "";

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->PoolProxy != NULL)) {
        statdata = GetGeneralObject()->PoolProxy->GetStat();

        text = text + "<b><i>Request proxy statistik.</i></b>&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>Threads count</td><td width='80%' colspan='4'>" + IntToStroka(statdata.threads) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>Enable proxy</td><td width='80%' colspan='4'>" + BoolToStroka2(statdata.enable_client) + "</td></tr>\n";

        text = text + "<tr valign='top'><td align='left' width='20%'>Example request url</td><td width='80%' colspan='4'>" + GetGeneralObject()->PoolProxy->GetExampleRequest() + reloadlink + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>PUT action</td><td width='80%' colspan='4'>" + statdata.put_action + "</td></tr>\n";

        text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='5'>&nbsp;</td></tr>\n";

        text = text + "<tr valign='top'><td align='left' width='20%'><b>QUEUE</b></td><td align='center' width='40%' colspan='2'><b>TODAY</b></td><td align='center' width='40%' colspan='2'><b>YESTERDAY</b></td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Shingles IN (add / update)</td><td colspan='2'>" + IntToStroka(statdata.today.queue_in) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.queue_in) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Shingles OUT</td><td colspan='2'>" + IntToStroka(statdata.today.queue_out) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.queue_out) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Shingles to queue</td><td colspan='2'>" + IntToStroka(statdata.today.queue_count) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.queue_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Shingles lost</td><td colspan='2'>" + IntToStroka(statdata.today.queue_lost) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.queue_lost) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request IN</td><td colspan='2'>" + IntToStroka(statdata.today.queue_in_rqst) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.queue_in_rqst) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request OUT</td><td colspan='2'>" + IntToStroka(statdata.today.queue_out_rqst) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.queue_out_rqst) + "</td></tr>\n";

        text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='5'>&nbsp;</td></tr>\n";

        text = text + "<tr valign='top'><td align='left' width='20%'><b>CLIENTS POOL</b></td><td align='center' width='40%' colspan='2'><b>TODAY</b></td><td align='center' width='40%' colspan='2'><b>YESTERDAY</b></td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Forbid request count</td><td colspan='2'>" + IntToStroka(statdata.proxy_put_forbid_today) + "</td><td colspan='2'>" + IntToStroka(statdata.proxy_put_forbid_yesterday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>All request count</td><td colspan='2'>" + IntToStroka(statdata.today.all_mail_count) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.all_mail_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Connect error</td><td colspan='2'>" + IntToStroka(statdata.today.connect_error) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.connect_error) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Connect timeout</td><td colspan='2'>" + IntToStroka(statdata.today.connect_timeout) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.connect_timeout) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request ok (200)</td><td colspan='2'>" + IntToStroka(statdata.today.request_200_count) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.request_200_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request with code 404</td><td colspan='2'>" + IntToStroka(statdata.today.request_404_count) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.request_404_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request with code 400-499 exclude 404</td><td colspan='2'>" + IntToStroka(statdata.today.request_400500_count) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.request_400500_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request with other code</td><td colspan='2'>" + IntToStroka(statdata.today.request_other_count) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.request_other_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request error</td><td colspan='2'>" + IntToStroka(statdata.today.request_error) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.request_error) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request timeout</td><td colspan='2'>" + IntToStroka(statdata.today.request_timeout) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.request_timeout) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request buffer overflow</td><td colspan='2'>" + IntToStroka(statdata.today.request_buffer_overflow) + "</td><td colspan='2'>" + IntToStroka(statdata.yesterday.request_buffer_overflow) + "</td></tr>\n";
        text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='5'>&nbsp;</td></tr>\n";

        text = text + "</table>";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);
    }
}

void TMakeRequest::ViewShinglesStat(const TString& id) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    int two_part = 0;
    TString table1text = "";
    TString table2text = "";
    TString typelink = "";
    TString busystr = "";

    two_part = MAX_COUNT_SHINGLES_TYPE / 2;
    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        TShingleStorageStat shstat;

        GetGeneralObject()->ShinglesStorage->GetStat(shstat);

        TString viewshingleinfo = "<form action='" + GetHost() + GetModuleName("viewshingleinfo") + "' method='GET' enctype='text/plain'>Get shingle info: &nbsp; shingle=<input type='text' size='30' name='shingle' value=''>&nbsp; type=<input type='text' size='10' name='type' value=''> &nbsp; " + GetActionFormParam("viewshingleinfo") + "<input type='submit' size='10' value='view'></form>\n";

        //table 1
        table1text = table1text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
        table1text = table1text + "<tr valign='top'>";
        table1text = table1text + "<td align='center' width='12%'><b>TYPE</b></td>";
        table1text = table1text + "<td align='center' width='12%'><b>TODAY</b></td>";
        table1text = table1text + "<td align='center' width='12%'><b>YESTERDAY</b></td>";
        table1text = table1text + "<td align='center' width='12%'><b>HEAVY</b></td>";
        table1text = table1text + "</tr>";
        for (int i = 0; i < two_part; i++) {
            if (shstat.typesdata[i].Busy())
                busystr = "&nbsp; - busy";
            else
                busystr = "";
            typelink = "<A href='" + GetHost() + GetModuleName("viewtypestat") + GetActionOneParam("viewtypestat") + "&type=" + IntToStroka(i) + "' target='_blank'>type " + IntToStroka(i) + "</A>";
            table1text = table1text + "<tr valign='top'>";
            table1text = table1text + "<td align='left' width='12%'>" + typelink + busystr + "</td>";
            table1text = table1text + "<td align='right' width='12%'>" + UI64ToStroka(shstat.typesdata[i].TodayCountSummary()) + "</td>";
            table1text = table1text + "<td align='right' width='12%'>" + UI64ToStroka(shstat.typesdata[i].YesterdayCountSummary()) + "</td>";
            table1text = table1text + "<td align='right' width='12%'>" + UI64ToStroka(shstat.typesdata[i].HeavyCountSummary()) + "</td>";
            table1text = table1text + "</tr>";
        }
        table1text = table1text + "</table>";

        //table2
        table2text = table2text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
        table2text = table2text + "<tr valign='top'>";
        table2text = table2text + "<td align='center' width='12%'><b>TYPE</b></td>";
        table2text = table2text + "<td align='center' width='12%'><b>TODAY</b></td>";
        table2text = table2text + "<td align='center' width='12%'><b>YESTERDAY</b></td>";
        table2text = table2text + "<td align='center' width='12%'><b>HEAVY</b></td>";
        table2text = table2text + "</tr>";
        for (int i = 0; i < two_part; i++) {
            if (shstat.typesdata[two_part + i].Busy())
                busystr = "&nbsp; - busy";
            else
                busystr = "";
            typelink = "<A href='" + GetHost() + GetModuleName("viewtypestat") + GetActionOneParam("viewtypestat") + "&type=" + IntToStroka(two_part + i) + "' target='_blank'>type " + IntToStroka(two_part + i) + "</A>";
            table2text = table2text + "<tr valign='top'>";
            table2text = table2text + "<td align='left' width='12%'>" + typelink + busystr + "</td>";
            table2text = table2text + "<td align='right' width='12%'>" + UI64ToStroka(shstat.typesdata[two_part + i].TodayCountSummary()) + "</td>";
            table2text = table2text + "<td align='right' width='12%'>" + UI64ToStroka(shstat.typesdata[two_part + i].YesterdayCountSummary()) + "</td>";
            table2text = table2text + "<td align='right' width='12%'>" + UI64ToStroka(shstat.typesdata[two_part + i].HeavyCountSummary()) + "</td>";
            table2text = table2text + "</tr>";
        }
        table2text = table2text + "</table>";

        // Summary table
        text = text + "<b><i>Short statistik all types</i></b>&nbsp;";
        text = text + "<table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
        text = text + "<tr><td colspan=2 width='100%'><br>" + viewshingleinfo + "</td></tr>";
        text = text + "<tr><td width='49%'>" + table1text + "</td><td width='1%' bgcolor='" + TString(cell_color) + "'>&nbsp;</td><td width='49%'>" + table2text + "</td></tr>";
        text = text + "</table>";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);
    }
}

void TMakeRequest::ViewShinglesStat2(const TString& id) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TString table1text = "";
    TString typelink = "";
    TString busystr = "";
    time_t currenttime = time(NULL);

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        TShingleStorageStat shstat;

        GetGeneralObject()->ShinglesStorage->GetStat(shstat);

        TString viewshingleinfo = "<form action='" + GetHost() + GetModuleName("viewshingleinfo") + "' method='GET' enctype='text/plain'>Get shingle info: &nbsp; shingle=<input type='text' size='30' name='shingle' value=''>&nbsp; type=<input type='text' size='10' name='type' value=''> &nbsp; " + GetActionFormParam("viewshingleinfo") + "<input type='submit' size='10' value='view'></form>\n";

        table1text = table1text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
        table1text = table1text + "<tr valign='top'>";
        table1text = table1text + "<td align='center' width='8%'><b>TYPE</b></td>";
        table1text = table1text + "<td align='center' width='8%'><b>RPL DIFF</b></td>";
        table1text = table1text + "<td align='center' width='8%'><b>HEAVY TRSH</b></td>";
        table1text = table1text + "<td align='center' width='8%'><b>CLEANUP TRSH</b></td>";
        table1text = table1text + "<td align='center' width='8%'><b>SAVE TRSH</b></td>";
        table1text = table1text + "<td align='center' width='8%'><b>TODAY</b></td>";
        table1text = table1text + "<td align='center' width='8%'><b>YESTERDAY</b></td>";
        table1text = table1text + "<td align='center' width='8%'><b>HEAVY</b></td>";
        table1text = table1text + "<td align='center' width='9%'><b>RPL SHCOUNT (TODAY/YEST)</b></td>";
        table1text = table1text + "<td align='center' width='9%'><b>LAST CLEANUP (today count)</b></td>";
        table1text = table1text + "<td align='center' width='9%'><b>LAST MIDNIGHT</b></td>";
        table1text = table1text + "<td align='center' width='9%'><b>LAST SAVE</b></td>";
        table1text = table1text + "</tr>";
        for (int i = 0; i < MAX_COUNT_SHINGLES_TYPE; i++) {
            if (shstat.typesdata[i].Busy())
                busystr = "&nbsp; - busy";
            else
                busystr = "";
            typelink = "<A href='" + GetHost() + GetModuleName("viewtypestat") + GetActionOneParam("viewtypestat") + "&type=" + IntToStroka(i) + "' target='_blank'>type " + IntToStroka(i) + "</A>";
            table1text = table1text + "<tr valign='top'>";
            table1text = table1text + "<td align='left'>" + typelink + busystr + "</td>";
            table1text = table1text + "<td align='right'>" + IntToStroka(shstat.typesdata[i].rpl_diff_value) + "</td>";
            table1text = table1text + "<td align='right'>" + IntToStroka(shstat.typesdata[i].heavy_treshold) + "</td>";
            table1text = table1text + "<td align='right'>" + IntToStroka(shstat.typesdata[i].cleanup_treshold) + "</td>";
            table1text = table1text + "<td align='right'>" + IntToStroka(shstat.typesdata[i].save_treshold) + "</td>";
            table1text = table1text + "<td align='right'>" + UI64ToStroka(shstat.typesdata[i].TodayCountSummary()) + "</td>";
            table1text = table1text + "<td align='right'>" + UI64ToStroka(shstat.typesdata[i].YesterdayCountSummary()) + "</td>";
            table1text = table1text + "<td align='right'>" + UI64ToStroka(shstat.typesdata[i].HeavyCountSummary()) + "</td>";
            table1text = table1text + "<td align='right'>" + UI64ToStroka(shstat.typesdata[i].RPLTodayCountSummary()) + " / " + UI64ToStroka(shstat.typesdata[i].RPLYesterdayCountSummary()) + "</td>";

            if (shstat.typesdata[i].LastCleanupSummary() != 0) {
                table1text = table1text + "<td align='right'>" + GetTimePeriod(currenttime - shstat.typesdata[i].LastCleanupSummary()) + " (t=" + FloatToStr(shstat.typesdata[i].TodayCleanupSummary()) + ")</td>";
            } else {
                table1text = table1text + "<td align='right'>-</td>";
            }

            if (shstat.typesdata[i].LastMidnightSummary() != 0) {
                table1text = table1text + "<td align='right'>" + GetTimePeriod(currenttime - shstat.typesdata[i].LastMidnightSummary()) + "</td>";
            } else {
                table1text = table1text + "<td align='right'>-</td>";
            }

            if (shstat.typesdata[i].LastSaveSummary() != 0) {
                table1text = table1text + "<td align='right'>" + GetTimePeriod(currenttime - shstat.typesdata[i].LastSaveSummary()) + "</td>";
            } else {
                table1text = table1text + "<td align='right'>-</td>";
            }

            table1text = table1text + "</tr>";
        }
        table1text = table1text + "</table>";

        // Summary table
        text = text + "<b><i>Short statistik all types</i></b>&nbsp;";
        text = text + "<table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
        text = text + "<tr><td width='100%'><br>" + viewshingleinfo + "</td></tr>";
        text = text + "<tr><td width='100%'>" + table1text + "</td></tr>";
        text = text + "</table>";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);
    }
}

void TMakeRequest::ViewShinglesStatBusy(const TString& id) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    int type = 0;
    TString type_s = "";
    TString table1text = "";
    TString typelink = "";
    TString typelink_s = "";
    TString busystr_s = "";
    time_t currenttime = 0;
    ui64 today_all = 0;
    ui64 yesterday_all = 0;
    ui64 heavy_all = 0;
    ui64 rpl_all_today = 0;
    ui64 rpl_all_yesterday = 0;
    ui32 all_cleanup_during = 0;
    ui32 all_midnight_during = 0;
    ui32 all_save_during = 0;
    ui32 summ_count = 0;
    ui64 summ_today_get = 0;
    ui64 summ_today_get_heavy = 0;
    ui64 summ_today_put = 0;
    ui64 summ_today_putm = 0;
    ui64 summ_today_setm = 0;
    ui64 summ_today_setweight = 0;
    ui64 summ_yesterday_get = 0;
    ui64 summ_yesterday_get_heavy = 0;
    ui64 summ_yesterday_put = 0;
    ui64 summ_yesterday_putm = 0;
    ui64 summ_yesterday_setm = 0;
    ui64 summ_yesterday_setweight = 0;
    ui64 summ_today_lost_put = 0;
    ui64 summ_today_lost_putm = 0;
    ui64 summ_today_lost_setm = 0;
    ui64 summ_today_lost_setweight = 0;
    ui64 summ_yesterday_lost_put = 0;
    ui64 summ_yesterday_lost_putm = 0;
    ui64 summ_yesterday_lost_setm = 0;
    ui64 summ_yesterday_lost_setweight = 0;
    ui32 all_summ_count = 0;
    ui64 all_summ_today_get = 0;
    ui64 all_summ_today_get_heavy = 0;
    ui64 all_summ_today_put = 0;
    ui64 all_summ_today_putm = 0;
    ui64 all_summ_today_setm = 0;
    ui64 all_summ_today_setweight = 0;
    ui64 all_summ_yesterday_get = 0;
    ui64 all_summ_yesterday_get_heavy = 0;
    ui64 all_summ_yesterday_put = 0;
    ui64 all_summ_yesterday_putm = 0;
    ui64 all_summ_yesterday_setm = 0;
    ui64 all_summ_yesterday_setweight = 0;
    ui64 all_summ_today_lost_put = 0;
    ui64 all_summ_today_lost_putm = 0;
    ui64 all_summ_today_lost_setm = 0;
    ui64 all_summ_today_lost_setweight = 0;
    ui64 all_summ_yesterday_lost_put = 0;
    ui64 all_summ_yesterday_lost_putm = 0;
    ui64 all_summ_yesterday_lost_setm = 0;
    ui64 all_summ_yesterday_lost_setweight = 0;
    ui32 last_cleanup = 0;
    ui32 last_midnight = 0;
    ui32 last_save = 0;
    ui32 last_cleanup_during = 0;
    ui32 last_midnight_during = 0;
    ui32 last_save_during = 0;

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        TShingleStorageStat shstat;
        GetGeneralObject()->ShinglesStorage->GetStat(shstat);

        currenttime = time(NULL);
        TString viewshingleinfo = "<form action='" + GetHost() + GetModuleName("viewshingleinfo") + "' method='GET' enctype='text/plain'>Get shingle info: &nbsp; shingle=<input type='text' size='30' name='shingle' value=''>&nbsp; type=<input type='text' size='10' name='type' value=''> &nbsp; " + GetActionFormParam("viewshingleinfo") + "<input type='submit' size='10' value='view'></form>\n";

        // typelink = typelink + "<A href='" + GetHost() + GetModuleName("viewshinglesstat") + GetActionOneParam("viewshinglesstat") + "' target='_blank'>Short statistik all types</A>&nbsp;";
        // typelink = typelink + "<A href='" + GetHost() + GetModuleName("viewshinglesst_m") + GetActionOneParam("viewshinglesst_m") + "' target='_blank'>ShortEx statistik all types</A>&nbsp;";
        // typelink = typelink + "<A href='" + GetHost() + GetModuleName("viewshinglesst_b") + GetActionOneParam("viewshinglesst_b") + "' target='_blank'>Busy statistik all types</A>&nbsp;";

        text = text + viewshingleinfo;

        text = text + "<br><b><i>Statistik by busy cache</i></b>&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
        text = text + "<tr valign='top'>";
        text = text + "<td align='center' width='5%' rowspan='2'><b>Type number</b></td>";
        text = text + "<td align='center' width='5%' rowspan='2'><b>QUEUE SIZE</b></td>";
        text = text + "<td align='center' width='10%' rowspan='2'><b>LAST CLEANUP (during, today count)</b></td>";
        text = text + "<td align='center' width='10%' rowspan='2'><b>LAST MIDNIGHT (during)</b></td>";
        text = text + "<td align='center' width='10%' rowspan='2'><b>LAST SAVE (during)</b></td>";
        text = text + "<td align='center' width='30%' colspan='5'><b>TODAY</b></td>";
        text = text + "<td align='center' width='30%' colspan='5'><b>YESTERDAY</b></td>";
        text = text + "</tr>";
        text = text + "<tr valign='top'>";
        text = text + "<td align='center' width='6%'><b>GET (HEAVY)</b></td>";
        text = text + "<td align='center' width='6%'><b>PUT</b></td>";
        text = text + "<td align='center' width='6%'><b>PUTM</b></td>";
        text = text + "<td align='center' width='6%'><b>SETM</b></td>";
        text = text + "<td align='center' width='6%'><b>SETWEIGHT</b></td>";
        text = text + "<td align='center' width='6%'><b>GET</b></td>";
        text = text + "<td align='center' width='6%'><b>PUT</b></td>";
        text = text + "<td align='center' width='6%'><b>PUTM</b></td>";
        text = text + "<td align='center' width='6%'><b>SETM</b></td>";
        text = text + "<td align='center' width='6%'><b>SETWEIGHT</b></td>";
        text = text + "</tr>";
        for (int j = 0; j < MAX_COUNT_SHINGLES_TYPE; j++) {
            TSHTypeStat typestat = shstat.typesdata[j];

            last_cleanup = 0;
            last_midnight = 0;
            last_save = 0;
            last_cleanup_during = 0;
            last_midnight_during = 0;
            last_save_during = 0;
            summ_count = 0;
            summ_today_get = 0;
            summ_today_get_heavy = 0;
            summ_today_put = 0;
            summ_today_putm = 0;
            summ_today_setm = 0;
            summ_today_setweight = 0;
            summ_yesterday_get = 0;
            summ_yesterday_get_heavy = 0;
            summ_yesterday_put = 0;
            summ_yesterday_putm = 0;
            summ_yesterday_setm = 0;
            summ_yesterday_setweight = 0;
            summ_today_lost_put = 0;
            summ_today_lost_putm = 0;
            summ_today_lost_setm = 0;
            summ_today_lost_setweight = 0;
            summ_yesterday_lost_put = 0;
            summ_yesterday_lost_putm = 0;
            summ_yesterday_lost_setm = 0;
            summ_yesterday_lost_setweight = 0;
            for (int i = 0; i < typestat.real_part_count; i++) {
                if (typestat.partdata[i].last_cleanup > last_cleanup)
                    last_cleanup = typestat.partdata[i].last_cleanup;
                if (typestat.partdata[i].last_midnight > last_midnight)
                    last_midnight = typestat.partdata[i].last_midnight;
                if (typestat.partdata[i].last_save > last_save)
                    last_save = typestat.partdata[i].last_save;

                last_cleanup_during = IncMax32(last_cleanup_during, typestat.partdata[i].last_cleanup_during);
                last_midnight_during = IncMax32(last_midnight_during, typestat.partdata[i].last_midnight_during);
                last_save_during = IncMax32(last_save_during, typestat.partdata[i].last_save_during);

                summ_count = IncMax32(summ_count, typestat.partdata[i].busycachestat.m_count);
                summ_today_get = IncMax64(summ_today_get, typestat.partdata[i].busycachestat.m_today_get);
                summ_today_get_heavy = IncMax64(summ_today_get_heavy, typestat.partdata[i].busycachestat.m_today_get_heavy);
                summ_today_put = IncMax64(summ_today_put, typestat.partdata[i].busycachestat.m_today_put);
                summ_today_putm = IncMax64(summ_today_putm, typestat.partdata[i].busycachestat.m_today_putm);
                summ_today_setm = IncMax64(summ_today_setm, typestat.partdata[i].busycachestat.m_today_setm);
                summ_today_setweight = IncMax64(summ_today_setweight, typestat.partdata[i].busycachestat.m_today_setweight);
                summ_yesterday_get = IncMax64(summ_yesterday_get, typestat.partdata[i].busycachestat.m_yesterday_get);
                summ_yesterday_get_heavy = IncMax64(summ_yesterday_get_heavy, typestat.partdata[i].busycachestat.m_yesterday_get_heavy);
                summ_yesterday_put = IncMax64(summ_yesterday_put, typestat.partdata[i].busycachestat.m_yesterday_put);
                summ_yesterday_putm = IncMax64(summ_yesterday_putm, typestat.partdata[i].busycachestat.m_yesterday_putm);
                summ_yesterday_setm = IncMax64(summ_yesterday_setm, typestat.partdata[i].busycachestat.m_yesterday_setm);
                summ_yesterday_setweight = IncMax64(summ_yesterday_setweight, typestat.partdata[i].busycachestat.m_yesterday_setweight);
                summ_today_lost_put = IncMax64(summ_today_lost_put, typestat.partdata[i].busycachestat.m_today_lost_put);
                summ_today_lost_putm = IncMax64(summ_today_lost_putm, typestat.partdata[i].busycachestat.m_today_lost_putm);
                summ_today_lost_setm = IncMax64(summ_today_lost_setm, typestat.partdata[i].busycachestat.m_today_lost_setm);
                summ_today_lost_setweight = IncMax64(summ_today_lost_setweight, typestat.partdata[i].busycachestat.m_today_lost_setweight);
                summ_yesterday_lost_put = IncMax64(summ_yesterday_lost_put, typestat.partdata[i].busycachestat.m_yesterday_lost_put);
                summ_yesterday_lost_putm = IncMax64(summ_yesterday_lost_putm, typestat.partdata[i].busycachestat.m_yesterday_lost_putm);
                summ_yesterday_lost_setm = IncMax64(summ_yesterday_lost_setm, typestat.partdata[i].busycachestat.m_yesterday_lost_setm);
                summ_yesterday_lost_setweight = IncMax64(summ_yesterday_lost_setweight, typestat.partdata[i].busycachestat.m_yesterday_lost_setweight);
            }

            if (typestat.Busy())
                busystr_s = "&nbsp; - busy";
            else
                busystr_s = "";
            typelink_s = "<A href='" + GetHost() + GetModuleName("viewtypestat") + GetActionOneParam("viewtypestat") + "&type=" + IntToStroka(j) + "' target='_blank'>type " + IntToStroka(j) + "</A>";

            text = text + "<tr valign='top'>";
            text = text + "<td align='left' rowspan='2'>" + typelink_s + busystr_s + "</td>";
            text = text + "<td align='right'>" + IntToStroka(summ_count) + "</td>";
            if (last_cleanup != 0)
                text = text + "<td align='right'>" + GetTimePeriod(currenttime - last_cleanup) + " (" + IntToStroka(last_cleanup_during) + " msec, t=" + FloatToStr(typestat.TodayCleanupSummary()) + ")</td>";
            else
                text = text + "<td align='right'>-</td>";

            if (last_midnight != 0)
                text = text + "<td align='right'>" + GetTimePeriod(currenttime - last_midnight) + " (" + IntToStroka(last_midnight_during) + " msec)</td>";
            else
                text = text + "<td align='right'>-</td>";

            if (last_save != 0)
                text = text + "<td align='right'>" + GetTimePeriod(currenttime - last_save) + " (" + IntToStroka(last_save_during) + " msec)</td>";
            else
                text = text + "<td align='right'>-</td>";

            text = text + "<td align='right'>" + UI64ToStroka(summ_today_get) + " (" + UI64ToStroka(summ_today_get_heavy) + ")</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_today_put) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_today_putm) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_today_setm) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_today_setweight) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_get) + " (" + UI64ToStroka(summ_yesterday_get_heavy) + ")</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_put) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_putm) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_setm) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_setweight) + "</td>";
            text = text + "</tr>";

            text = text + "<tr valign='top'>";
            text = text + "<td align='right'>lost: </td>";
            text = text + "<td align='right'> - </td>";
            text = text + "<td align='right'> - </td>";
            text = text + "<td align='right'> - </td>";
            text = text + "<td align='right'> - </td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_today_lost_put) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_today_lost_putm) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_today_lost_setm) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_today_lost_setweight) + "</td>";
            text = text + "<td align='right'> - </td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_lost_put) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_lost_putm) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_lost_setm) + "</td>";
            text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_lost_setweight) + "</td>";
            text = text + "</tr>";

            all_summ_count = IncMax32(all_summ_count, summ_count);
            all_summ_today_get = IncMax64(all_summ_today_get, summ_today_get);
            all_summ_today_get_heavy = IncMax64(all_summ_today_get_heavy, summ_today_get_heavy);
            all_summ_today_put = IncMax64(all_summ_today_put, summ_today_put);
            all_summ_today_putm = IncMax64(all_summ_today_putm, summ_today_putm);
            all_summ_today_setm = IncMax64(all_summ_today_setm, summ_today_setm);
            all_summ_today_setweight = IncMax64(all_summ_today_setweight, summ_today_setweight);
            all_summ_yesterday_get = IncMax64(all_summ_yesterday_get, summ_yesterday_get);
            all_summ_yesterday_get_heavy = IncMax64(all_summ_yesterday_get_heavy, summ_yesterday_get_heavy);
            all_summ_yesterday_put = IncMax64(all_summ_yesterday_put, summ_yesterday_put);
            all_summ_yesterday_putm = IncMax64(all_summ_yesterday_putm, summ_yesterday_putm);
            all_summ_yesterday_setm = IncMax64(all_summ_yesterday_setm, summ_yesterday_setm);
            all_summ_yesterday_setweight = IncMax64(all_summ_yesterday_setweight, summ_yesterday_setweight);
            all_summ_today_lost_put = IncMax64(all_summ_today_lost_put, summ_today_lost_put);
            all_summ_today_lost_putm = IncMax64(all_summ_today_lost_putm, summ_today_lost_putm);
            all_summ_today_lost_setm = IncMax64(all_summ_today_lost_setm, summ_today_lost_setm);
            all_summ_today_lost_setweight = IncMax64(all_summ_today_lost_setweight, summ_today_lost_setweight);
            all_summ_yesterday_lost_put = IncMax64(all_summ_yesterday_lost_put, summ_yesterday_lost_put);
            all_summ_yesterday_lost_putm = IncMax64(all_summ_yesterday_lost_putm, summ_yesterday_lost_putm);
            all_summ_yesterday_lost_setm = IncMax64(all_summ_yesterday_lost_setm, summ_yesterday_lost_setm);
            all_summ_yesterday_lost_setweight = IncMax64(all_summ_yesterday_lost_setweight, summ_yesterday_lost_setweight);
        }
        text = text + "<tr valign='top'>";
        text = text + "<td align='left' rowspan='2'>All types</td>";
        text = text + "<td align='right'>" + IntToStroka(all_summ_count) + "</td>";
        text = text + "<td align='right'>-</td>";
        text = text + "<td align='right'>-</td>";
        text = text + "<td align='right'>-</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_today_get) + " (" + UI64ToStroka(all_summ_today_get_heavy) + ")</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_today_put) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_today_putm) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_today_setm) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_today_setweight) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_yesterday_get) + " (" + UI64ToStroka(all_summ_yesterday_get_heavy) + ")</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_yesterday_put) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_yesterday_putm) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_yesterday_setm) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_yesterday_setweight) + "</td>";
        text = text + "</tr>";

        text = text + "<tr valign='top'>";
        text = text + "<td align='right'>lost: </td>";
        text = text + "<td align='right'> - </td>";
        text = text + "<td align='right'> - </td>";
        text = text + "<td align='right'> - </td>";
        text = text + "<td align='right'> - </td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_today_lost_put) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_today_lost_putm) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_today_lost_setm) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_today_lost_setweight) + "</td>";
        text = text + "<td align='right'> - </td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_yesterday_lost_put) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_yesterday_lost_putm) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_yesterday_lost_setm) + "</td>";
        text = text + "<td align='right'>" + UI64ToStroka(all_summ_yesterday_lost_setweight) + "</td>";
        text = text + "</tr>";
        text = text + "</table>";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);
    }
}

void TMakeRequest::ViewTypeStat(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    int type = 0;
    TString type_s = "";
    TString table1text = "";
    TString typelink = "";
    time_t currenttime = 0;
    ui64 today_all = 0;
    ui64 yesterday_all = 0;
    ui64 heavy_all = 0;
    ui64 rpl_all_today = 0;
    ui64 rpl_all_yesterday = 0;
    ui32 all_cleanup_during = 0;
    ui32 all_midnight_during = 0;
    ui32 all_save_during = 0;
    TString writedumplink = "";
    TString cleanuplink = "";
    ui32 summ_count = 0;
    ui64 summ_today_get = 0;
    ui64 summ_today_get_heavy = 0;
    ui64 summ_today_put = 0;
    ui64 summ_today_putm = 0;
    ui64 summ_today_setm = 0;
    ui64 summ_today_setweight = 0;
    ui64 summ_yesterday_get = 0;
    ui64 summ_yesterday_get_heavy = 0;
    ui64 summ_yesterday_put = 0;
    ui64 summ_yesterday_putm = 0;
    ui64 summ_yesterday_setm = 0;
    ui64 summ_yesterday_setweight = 0;
    ui64 summ_today_lost_put = 0;
    ui64 summ_today_lost_putm = 0;
    ui64 summ_today_lost_setm = 0;
    ui64 summ_today_lost_setweight = 0;
    ui64 summ_yesterday_lost_put = 0;
    ui64 summ_yesterday_lost_putm = 0;
    ui64 summ_yesterday_lost_setm = 0;
    ui64 summ_yesterday_lost_setweight = 0;

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        par_it = m_ReqParams->find("type");
        if (par_it != m_ReqParams->end()) {
            type_s = Trim(par_it->second[0]);
            type = atoi(type_s.c_str());

            if (!type_s.empty() && (type >= 0) && (type < MAX_COUNT_SHINGLES_TYPE)) {
                TShingleStorageStat shstat;
                GetGeneralObject()->ShinglesStorage->GetStat(shstat);
                TSHTypeStat typestat = shstat.typesdata[type];

                TString viewshingleinfo = "<form action='" + GetHost() + GetModuleName("viewshingleinfo") + "' method='GET' enctype='text/plain'>Get shingle info: &nbsp; shingle=<input type='text' size='30' name='shingle' value=''>&nbsp; type=<input type='text' size='10' name='type' value='" + IntToStroka(type) + "'> &nbsp; " + GetActionFormParam("viewshingleinfo") + "<input type='submit' size='10' value='view'></form>\n";

                currenttime = time(NULL);
                typelink = typelink + "<A href='" + GetHost() + GetModuleName("viewshinglesstat") + GetActionOneParam("viewshinglesstat") + "' target='_blank'>Short statistik all types</A>&nbsp;";
                typelink = typelink + "<A href='" + GetHost() + GetModuleName("viewshinglesst_m") + GetActionOneParam("viewshinglesst_m") + "' target='_blank'>ShortEx statistik all types</A>&nbsp;";
                typelink = typelink + "<A href='" + GetHost() + GetModuleName("viewshinglesst_b") + GetActionOneParam("viewshinglesst_b") + "' target='_blank'>Busy statistik all types</A>&nbsp;";
                writedumplink = "&nbsp;<A href='" + GetHost() + GetModuleName("askwritedump") + GetActionOneParam("askwritedump") + "&type=" + IntToStroka(type) + "'>Writedump</A>";
                cleanuplink = "&nbsp;<A href='" + GetHost() + GetModuleName("askcleanup") + GetActionOneParam("askcleanup") + "&type=" + IntToStroka(type) + "'>Cleanup</A>";

                text = text + viewshingleinfo + "<br>";
                text = text + typelink + "&nbsp;<b>SHINGLE STATYSTIK, TYPE=" + IntToStroka(type) + ":</b> &nbsp; " + writedumplink + " &nbsp; " + cleanuplink + "<br>";

                text = text + "<br><b><i>Statistik by type</i></b>&nbsp;";
                text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Part count</td><td width='80%' colspan='4'>" + IntToStroka(typestat.real_part_count) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Max size hash</td><td width='80%' colspan='4'>" + IntToStrokaNum(typestat.max_size_ohash * typestat.real_part_count) + " (" + IntToStrokaNum(typestat.max_size_ohash) + " x " + IntToStroka(typestat.real_part_count) + " part)</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>RPL diff value</td><td width='80%' colspan='4'>" + IntToStroka(typestat.rpl_diff_value) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Heavy treshold</td><td width='80%' colspan='4'>" + IntToStroka(typestat.heavy_treshold) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Save treshold</td><td width='80%' colspan='4'>" + IntToStroka(typestat.save_treshold) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Cleanup treshold</td><td width='80%' colspan='4'>" + IntToStroka(typestat.cleanup_treshold) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Dump filename</td><td width='80%' colspan='4'>" + typestat.dumpfilename + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Load at startup</td><td width='80%' colspan='4'>" + BoolToStroka2(typestat.load_dump_at_startup) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Load dump information</td><td width='80%' colspan='4'>" + typestat.res_loaddump + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Midnight koef_div</td><td width='80%' colspan='4'>" + IntToStroka(typestat.midnight_koef_div) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Cleanup type</td><td width='80%' colspan='4'>" + TCleanupTypeToStroka(typestat.cleanup_type) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>Shutdown save treshold</td><td width='80%' colspan='4'>" + IntToStroka(typestat.shutdown_save_treshold) + "</td></tr>\n";
                text = text + "</table>";

                text = text + "<br><b><i>Statistik by parts</i></b>&nbsp;";
                text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
                text = text + "<tr valign='top'>";
                text = text + "<td align='center' width='5%'><b>Part number</b></td>";
                text = text + "<td align='center' width='7%'><b>BUSY</b></td>";
                text = text + "<td align='center' width='8%'><b>TODAY</b></td>";
                text = text + "<td align='center' width='8%'><b>YESTERDAY</b></td>";
                text = text + "<td align='center' width='8%'><b>HEAVY</b></td>";
                text = text + "<td align='center' width='8%'><b>RPL SHCOUNT (TODAY / YESTERDAY)</b></td>";
                text = text + "<td align='center' width='8%'><b>LAST CLEANUP (today count)</b></td>";
                text = text + "<td align='center' width='8%'><b>DURING CLEANUP</b></td>";
                text = text + "<td align='center' width='8%'><b>LAST MIDNIGHT</b></td>";
                text = text + "<td align='center' width='8%'><b>DURING MIDNIGHT</b></td>";
                text = text + "<td align='center' width='8%'><b>MIDNIGHT KOEF</b></td>";
                text = text + "<td align='center' width='8%'><b>LAST SAVE</b></td>";
                text = text + "<td align='center' width='8%'><b>DURING SAVE</b></td>";
                text = text + "</tr>";
                for (int i = 0; i < typestat.real_part_count; i++) {
                    today_all += typestat.partdata[i].today_count;
                    yesterday_all += typestat.partdata[i].yesterday_count;
                    heavy_all += typestat.partdata[i].heavy_count;
                    rpl_all_today += typestat.partdata[i].rpl_today_shingles_count;
                    rpl_all_yesterday += typestat.partdata[i].rpl_yesterday_shingles_count;
                    all_cleanup_during += typestat.partdata[i].last_cleanup_during;
                    all_midnight_during += typestat.partdata[i].last_midnight_during;
                    all_save_during += typestat.partdata[i].last_save_during;

                    text = text + "<tr valign='top'>";
                    text = text + "<td align='left'>part " + IntToStroka(i) + "</td>";
                    switch (typestat.partdata[i].busytype) {
                        case TBT_CLEANUP:
                            text = text + "<td align='center'>cleanup</td>";
                            break;
                        case TBT_MIDNIGHT:
                            text = text + "<td align='center'>midnight</td>";
                            break;
                        case TBT_WRITEDUMP:
                            text = text + "<td align='center'>writedump</td>";
                            break;
                        default:
                            text = text + "<td align='center'>-</td>";
                    };
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].today_count) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].yesterday_count) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].heavy_count) + "</td>";
                    text = text + "<td align='right'>" + IntToStroka(typestat.partdata[i].rpl_today_shingles_count) + " / " + IntToStroka(typestat.partdata[i].rpl_yesterday_shingles_count) + "</td>";
                    if (typestat.partdata[i].last_cleanup != 0) {
                        text = text + "<td align='right'>" + GetTimePeriod(currenttime - typestat.partdata[i].last_cleanup) + " (t=" + IntToStroka(typestat.partdata[i].today_cleanup_count) + ")</td>";
                        text = text + "<td align='right'>" + IntToStroka(typestat.partdata[i].last_cleanup_during) + " msec</td>";
                    } else {
                        text = text + "<td align='right'>-</td>";
                        text = text + "<td align='right'>-</td>";
                    }
                    if (typestat.partdata[i].last_midnight != 0) {
                        TShingleStat ssobj;
                        float mdn_koef = ssobj.GetAgeCoeff(typestat.partdata[i].last_midnight, typestat.midnight_koef_div);

                        text = text + "<td align='right'>" + GetTimePeriod(currenttime - typestat.partdata[i].last_midnight) + "</td>";
                        text = text + "<td align='right'>" + IntToStroka(typestat.partdata[i].last_midnight_during) + " msec</td>";
                        text = text + "<td align='right'>" + FloatToStr5(mdn_koef) + " </td>";
                    } else {
                        text = text + "<td align='right'>-</td>";
                        text = text + "<td align='right'>-</td>";
                        text = text + "<td align='right'>-</td>";
                    }
                    if (typestat.partdata[i].last_save != 0) {
                        text = text + "<td align='right'>" + GetTimePeriod(currenttime - typestat.partdata[i].last_save) + "</td>";
                        text = text + "<td align='right'>" + IntToStroka(typestat.partdata[i].last_save_during) + " msec</td>";
                    } else {
                        text = text + "<td align='right'>-</td>";
                        text = text + "<td align='right'>-</td>";
                    }
                    text = text + "</tr>";
                }
                text = text + "<tr valign='top'>";
                text = text + "<td align='left'>summary</td>";
                text = text + "<td align='left'>&nbsp;</td>";
                text = text + "<td align='right'>" + UI64ToStroka(today_all) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(yesterday_all) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(heavy_all) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(rpl_all_today) + " / " + UI64ToStroka(rpl_all_yesterday) + "</td>";
                text = text + "<td align='right'>&nbsp;</td>";
                text = text + "<td align='right'>" + IntToStroka(all_cleanup_during) + " msec</td>";
                text = text + "<td align='right'>&nbsp;</td>";
                text = text + "<td align='right'>" + IntToStroka(all_midnight_during) + " msec</td>";
                text = text + "<td align='right'>&nbsp;</td>";
                text = text + "<td align='right'>&nbsp;</td>";
                text = text + "<td align='right'>" + IntToStroka(all_save_during) + " msec</td>";
                text = text + "</tr>";
                text = text + "</table>";

                text = text + "<br><b><i>Statistik by busy cache</i></b>&nbsp;";
                text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
                text = text + "<tr valign='top'>";
                text = text + "<td align='center' width='10%' rowspan='2'><b>Part number</b></td>";
                text = text + "<td align='center' width='10%' rowspan='2'><b>QUEUE SIZE</b></td>";
                text = text + "<td align='center' width='40%' colspan='5'><b>TODAY</b></td>";
                text = text + "<td align='center' width='40%' colspan='5'><b>YESTERDAY</b></td>";
                text = text + "</tr>";
                text = text + "<tr valign='top'>";
                // text = text + "<td align='center' width='10%'><b>&nbsp;</b></td>";
                // text = text + "<td align='center' width='10%'><b>&nbsp;</b></td>";
                text = text + "<td align='center' width='8%'><b>GET (HEAVY)</b></td>";
                text = text + "<td align='center' width='8%'><b>PUT</b></td>";
                text = text + "<td align='center' width='8%'><b>PUTM</b></td>";
                text = text + "<td align='center' width='8%'><b>SETM</b></td>";
                text = text + "<td align='center' width='8%'><b>SETWEIGHT</b></td>";
                text = text + "<td align='center' width='8%'><b>GET</b></td>";
                text = text + "<td align='center' width='8%'><b>PUT</b></td>";
                text = text + "<td align='center' width='8%'><b>PUTM</b></td>";
                text = text + "<td align='center' width='8%'><b>SETM</b></td>";
                text = text + "<td align='center' width='8%'><b>SETWEIGHT</b></td>";
                text = text + "</tr>";
                for (int i = 0; i < typestat.real_part_count; i++) {
                    summ_count = IncMax32(summ_count, typestat.partdata[i].busycachestat.m_count);
                    summ_today_get = IncMax64(summ_today_get, typestat.partdata[i].busycachestat.m_today_get);
                    summ_today_get_heavy = IncMax64(summ_today_get_heavy, typestat.partdata[i].busycachestat.m_today_get_heavy);
                    summ_today_put = IncMax64(summ_today_put, typestat.partdata[i].busycachestat.m_today_put);
                    summ_today_putm = IncMax64(summ_today_putm, typestat.partdata[i].busycachestat.m_today_putm);
                    summ_today_setm = IncMax64(summ_today_setm, typestat.partdata[i].busycachestat.m_today_setm);
                    summ_today_setweight = IncMax64(summ_today_setweight, typestat.partdata[i].busycachestat.m_today_setweight);
                    summ_yesterday_get = IncMax64(summ_yesterday_get, typestat.partdata[i].busycachestat.m_yesterday_get);
                    summ_yesterday_get_heavy = IncMax64(summ_yesterday_get_heavy, typestat.partdata[i].busycachestat.m_yesterday_get_heavy);
                    summ_yesterday_put = IncMax64(summ_yesterday_put, typestat.partdata[i].busycachestat.m_yesterday_put);
                    summ_yesterday_putm = IncMax64(summ_yesterday_putm, typestat.partdata[i].busycachestat.m_yesterday_putm);
                    summ_yesterday_setm = IncMax64(summ_yesterday_setm, typestat.partdata[i].busycachestat.m_yesterday_setm);
                    summ_yesterday_setweight = IncMax64(summ_yesterday_setweight, typestat.partdata[i].busycachestat.m_yesterday_setweight);
                    summ_today_lost_put = IncMax64(summ_today_lost_put, typestat.partdata[i].busycachestat.m_today_lost_put);
                    summ_today_lost_putm = IncMax64(summ_today_lost_putm, typestat.partdata[i].busycachestat.m_today_lost_putm);
                    summ_today_lost_setm = IncMax64(summ_today_lost_setm, typestat.partdata[i].busycachestat.m_today_lost_setm);
                    summ_today_lost_setweight = IncMax64(summ_today_lost_setweight, typestat.partdata[i].busycachestat.m_today_lost_setweight);
                    summ_yesterday_lost_put = IncMax64(summ_yesterday_lost_put, typestat.partdata[i].busycachestat.m_yesterday_lost_put);
                    summ_yesterday_lost_putm = IncMax64(summ_yesterday_lost_putm, typestat.partdata[i].busycachestat.m_yesterday_lost_putm);
                    summ_yesterday_lost_setm = IncMax64(summ_yesterday_lost_setm, typestat.partdata[i].busycachestat.m_yesterday_lost_setm);
                    summ_yesterday_lost_setweight = IncMax64(summ_yesterday_lost_setweight, typestat.partdata[i].busycachestat.m_yesterday_lost_setweight);

                    text = text + "<tr valign='top'>";
                    text = text + "<td align='left' rowspan='2'>part " + IntToStroka(i) + "</td>";
                    text = text + "<td align='right'>" + IntToStroka(typestat.partdata[i].busycachestat.m_count) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_get) + " (" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_get_heavy) + ")</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_put) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_putm) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_setm) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_setweight) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_get) + " (" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_get_heavy) + ")</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_put) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_putm) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_setm) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_setweight) + "</td>";
                    text = text + "</tr>";

                    text = text + "<tr valign='top'>";
                    text = text + "<td align='right'>lost: </td>";
                    text = text + "<td align='right'> - </td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_lost_put) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_lost_putm) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_lost_setm) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_today_lost_setweight) + "</td>";
                    text = text + "<td align='right'> - </td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_lost_put) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_lost_putm) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_lost_setm) + "</td>";
                    text = text + "<td align='right'>" + UI64ToStroka(typestat.partdata[i].busycachestat.m_yesterday_lost_setweight) + "</td>";
                    text = text + "</tr>";
                }
                text = text + "<tr valign='top'>";
                text = text + "<td align='left' rowspan='2'>all (amount)</td>";
                text = text + "<td align='right'>" + IntToStroka(summ_count) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_today_get) + " (" + UI64ToStroka(summ_today_get_heavy) + ")</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_today_put) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_today_putm) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_today_setm) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_today_setweight) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_get) + " (" + UI64ToStroka(summ_yesterday_get_heavy) + ")</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_put) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_putm) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_setm) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_setweight) + "</td>";
                text = text + "</tr>";

                text = text + "<tr valign='top'>";
                text = text + "<td align='right'>lost: </td>";
                text = text + "<td align='right'> - </td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_today_lost_put) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_today_lost_putm) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_today_lost_setm) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_today_lost_setweight) + "</td>";
                text = text + "<td align='right'> - </td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_lost_put) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_lost_putm) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_lost_setm) + "</td>";
                text = text + "<td align='right'>" + UI64ToStroka(summ_yesterday_lost_setweight) + "</td>";
                text = text + "</tr>";
                text = text + "</table>";

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);

            } else {
                SendToClientWithShap(SO_LOG_ERROR, 400, "bad parameter 'type'", 0);
            }

        } else {
            SendToClientWithShap(SO_LOG_ERROR, 400, "no defined parameter 'type'", 0);
        }
    }
}

void TMakeRequest::ViewShingleInfo(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    int type = 0;
    TString type_s = "";
    ui64 shingle = 0;
    TString shingle_s = "";
    TString table1text = "";
    TString typelink1 = "";
    TString typelink2 = "";
    time_t currenttime = 0;
    ui64 today_all = 0;
    ui64 yesterday_all = 0;
    ui64 heavy_all = 0;
    bool est_shingle = false;
    bool est_type = false;

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        par_it = m_ReqParams->find("shingle");
        if (par_it != m_ReqParams->end()) {
            shingle_s = Trim(par_it->second[0]);
            if (sscanf(shingle_s.c_str(), "%" PRIx64 "", &shingle) == 1)
                est_shingle = true;
        }

        par_it = m_ReqParams->find("type");
        if (par_it != m_ReqParams->end()) {
            type_s = Trim(par_it->second[0]);
            type = atoi(type_s.c_str());
            est_type = true;
        }

        if (est_shingle && est_type) {
            if ((shingle != 0) && (type >= 0) && (type < MAX_COUNT_SHINGLES_TYPE)) {
                TShingleStat shstat = GetGeneralObject()->ShinglesStorage->GetPublic("interface", shingle, type);

                TString clearshingleinfo = "<form action='" + GetHost() + GetModuleName("askuclearshingleinfo") + "' method='GET' enctype='text/plain'>SHINGLE<input type='hidden' size='30' name='shingle' value='" + ShingleToStroka(shingle) + "'><input type='hidden' size='30' name='type' value='" + IntToStroka(type) + "'>&nbsp; " + GetActionFormParam("askuclearshingleinfo") + "<input type='submit' size='10' value='Clear counters'></form>\n";

                currenttime = time(NULL);
                TString typelink1 = "<A href='" + GetHost() + GetModuleName("viewshinglesstat") + GetActionOneParam("viewshinglesstat") + "' target='_blank'>Short statistik all types</A>";
                TString typelink3 = "<A href='" + GetHost() + GetModuleName("viewshinglesst_m") + GetActionOneParam("viewshinglesst_m") + "' target='_blank'>ShortEx statistik all types</A>";
                TString typelink4 = "<A href='" + GetHost() + GetModuleName("viewshinglesst_b") + GetActionOneParam("viewshinglesst_b") + "' target='_blank'>Busy statistik all types</A>";
                TString typelink2 = "<A href='" + GetHost() + GetModuleName("viewtypestat") + GetActionOneParam("viewtypestat") + "&type=" + IntToStroka(type) + "' target='_blank'>Statistik type=" + IntToStroka(type) + "</A>";

                text = text + typelink1 + ",&nbsp;" + typelink3 + ",&nbsp;" + typelink2 + ",&nbsp;" + typelink4 + "&nbsp;<b>SHINGLE STATISTIC (SHINGLE=" + ShingleToStroka(shingle) + ", TYPE=" + IntToStroka(type) + "):</b><br>";

                text = text + "<br><b><i>Statistik shingle</i></b>&nbsp;";
                text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";

                if (shstat.IsEmpty())
                    text = text + "<tr valign='top'><td align='left' width='20%'>SHINGLE</td><td width='80%' colspan='4'>" + ShingleToStroka(shstat.Shingle()) + "</td></tr>\n";
                else
                    text = text + "<tr valign='top'><td align='left' width='20%'>" + clearshingleinfo + "</td><td width='80%' colspan='4'>" + ShingleToStroka(shstat.Shingle()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TYPE</td><td width='80%' colspan='4'>" + IntToStroka(shstat.Type()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>IS_EMPTY</td><td width='80%' colspan='4'>" + BoolToStroka2(shstat.IsEmpty()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>ACTION</td><td width='80%' colspan='4'>" + shstat.GetActionStateS() + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>IS_HEAVY</td><td width='80%' colspan='4'>" + BoolToStroka2(shstat.IsHeavyShingle()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='100%' colspan='2' bgcolor='" + TString(cell_color) + "'>&nbsp;</td></tr>\n";

                text = text + "<tr valign='top'><td align='left' width='20%'>TOTAL HAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.TotalHam()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TOTAL SPAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.TotalSpam()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TOTAL MALIC</td><td width='80%' colspan='4'>" + IntToStroka(shstat.TotalMalic()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TOTAL PERSONAL HAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.TotalPersHam()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TOTAL PERSONAL SPAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.TotalPersSpam()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TOTAL WEIGHT</td><td width='80%' colspan='4'>" + FloatToStr(shstat.TotalWeight()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>yesterday_div_koef</td><td width='80%' colspan='4'>" + IntToStroka(shstat.DivKoef()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>yesterday_koef</td><td width='80%' colspan='4'>" + FloatToStr(shstat.AgeKoef()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>last_midnight</td><td width='80%' colspan='4'>" + IntToStroka(shstat.LastMidnight()) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='100%' colspan='2' bgcolor='" + TString(cell_color) + "'>&nbsp;</td></tr>\n";

                text = text + "<tr valign='top'><td align='left' width='20%'>TODAY HAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.Ham(TODAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TODAY SPAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.Spam(TODAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TODAY MALIC</td><td width='80%' colspan='4'>" + IntToStroka(shstat.Malic(TODAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TODAY PERSONAL HAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.PersHam(TODAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TODAY PERSONAL SPAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.PersSpam(TODAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>TODAY WEIGHT</td><td width='80%' colspan='4'>" + FloatToStr(shstat.Weight(TODAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='100%' colspan='2' bgcolor='" + TString(cell_color) + "'>&nbsp;</td></tr>\n";

                text = text + "<tr valign='top'><td align='left' width='20%'>YESTERDAY HAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.Ham(YESTERDAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>YESTERDAY SPAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.Spam(YESTERDAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>YESTERDAY MALIC</td><td width='80%' colspan='4'>" + IntToStroka(shstat.Malic(YESTERDAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>YESTERDAY PERSONAL HAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.PersHam(YESTERDAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>YESTERDAY PERSONAL SPAM</td><td width='80%' colspan='4'>" + IntToStroka(shstat.PersSpam(YESTERDAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='20%'>YESTERDAY WEIGHT</td><td width='80%' colspan='4'>" + FloatToStr(shstat.Weight(YESTERDAY)) + "</td></tr>\n";
                text = text + "<tr valign='top'><td align='left' width='100%' colspan='2' bgcolor='" + TString(cell_color) + "'>&nbsp;</td></tr>\n";

                text = text + "</table>";

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);

            } else {
                SendToClientWithShap(SO_LOG_ERROR, 400, "bad parameter 'shingle' or 'type'", 0);
            }

        } else {
            SendToClientWithShap(SO_LOG_ERROR, 400, "no defined parameter 'shingle' or 'type'", 0);
        }
    }
}

void TMakeRequest::ClearShingleInfo(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    int type = 0;
    TString type_s = "";
    ui64 shingle = 0;
    TString shingle_s = "";
    bool est_shingle = false;
    bool est_type = false;

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        par_it = m_ReqParams->find("shingle");
        if (par_it != m_ReqParams->end()) {
            shingle_s = Trim(par_it->second[0]);
            if (sscanf(shingle_s.c_str(), "%" PRIx64 "", &shingle) == 1)
                est_shingle = true;
        }

        par_it = m_ReqParams->find("type");
        if (par_it != m_ReqParams->end()) {
            type_s = Trim(par_it->second[0]);
            type = atoi(type_s.c_str());
            est_type = true;
        }

        if (est_shingle && est_type) {
            if ((shingle != 0) && (type >= 0) && (type < MAX_COUNT_SHINGLES_TYPE)) {
                bool busy = false;
                bool res = GetGeneralObject()->ShinglesStorage->ClearShingle("interface", shingle, type, busy);

                if (res) {
                    text = text + "Clear shingle=" + ShingleToStroka(shingle) + " type=" + IntToStroka(type) + " succesfully.";

                    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);
                } else {
                    if (busy)
                        text = text + "Clear shingle=" + ShingleToStroka(shingle) + " type=" + IntToStroka(type) + " FAILED. Busy hash.";
                    else
                        text = text + "Clear shingle=" + ShingleToStroka(shingle) + " type=" + IntToStroka(type) + " FAILED. Shingle not found.";

                    SendToClientWithShap(SO_LOG_ERROR, 501, text, 0);
                }

            } else {
                SendToClientWithShap(SO_LOG_ERROR, 400, "bad parameter 'shingle' or 'type'", 0);
            }

        } else {
            SendToClientWithShap(SO_LOG_ERROR, 400, "no defined parameter 'shingle' or 'type'", 0);
        }
    }
}

void TMakeRequest::AskClearShingleInfo(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    int type = 0;
    TString type_s = "";
    ui64 shingle = 0;
    TString shingle_s = "";
    bool est_shingle = false;
    bool est_type = false;

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        par_it = m_ReqParams->find("shingle");
        if (par_it != m_ReqParams->end()) {
            shingle_s = Trim(par_it->second[0]);
            if (sscanf(shingle_s.c_str(), "%" PRIx64 "", &shingle) == 1)
                est_shingle = true;
        }

        par_it = m_ReqParams->find("type");
        if (par_it != m_ReqParams->end()) {
            type_s = Trim(par_it->second[0]);
            type = atoi(type_s.c_str());
            est_type = true;
        }

        if (est_shingle && est_type) {
            if ((shingle != 0) && (type >= 0) && (type < MAX_COUNT_SHINGLES_TYPE)) {
                text = text + HTTP_200_OK("-");
                text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
                text = text + "if(true == confirm('Clear shingle=" + ShingleToStroka(shingle) + " type=" + IntToStroka(type) + " ?')) {\n";
                text = text + "document.location = '" + GetHost() + GetModuleName("uclearshingleinfo") + GetActionOneParam("uclearshingleinfo") + "&shingle=" + ShingleToStroka(shingle) + "&type=" + IntToStroka(type) + "'\n";
                text = text + "} else {\n";
                text = text + "document.location = '" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
                text = text + "</SCRIPT>\n";
                SendToClientRAW(text);

            } else {
                SendToClientWithShap(SO_LOG_ERROR, 400, "bad parameter 'shingle' or 'type'", 0);
            }

        } else {
            SendToClientWithShap(SO_LOG_ERROR, 400, "no defined parameter 'shingle' or 'type'", 0);
        }
    }
}

void TMakeRequest::ViewStorageShingleInfo(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    ui64 shingle = 0;
    TString shingle_s = "";
    bool est_shingle = false;
    TString value_data = "";

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL) && (GetGeneralObject()->SimpleStorage != NULL)) {
        par_it = m_ReqParams->find("shingle");
        if (par_it != m_ReqParams->end()) {
            shingle_s = Trim(par_it->second[0]);
            if (sscanf(shingle_s.c_str(), "%" PRIx64 "", &shingle) == 1)
                est_shingle = true;
        }

        if (est_shingle) {
            if (shingle != 0) {
                if (GetGeneralObject()->SimpleStorage->Get(shingle, value_data)) {
                    text = text + "<br><b><i>Statistik simple storage shingle</i></b>&nbsp;";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
                    text = text + "<tr valign='top'><td align='left' width='20%'>SHINGLE</td><td width='80%' colspan='4'>" + ShingleToStroka(shingle) + "</td></tr>\n";
                    text = text + "<tr valign='top'><td align='left' width='20%'>VALUE</td><td width='80%' colspan='4'>" + value_data + " &nbsp;</td></tr>\n";
                    text = text + "</table>";

                } else {
                    text = text + "<br><b><i>Statistik simple storage shingle</i></b>&nbsp;";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
                    text = text + "<tr valign='top'><td align='left' width='20%'>SHINGLE</td><td width='80%' colspan='4'>" + ShingleToStroka(shingle) + "</td></tr>\n";
                    text = text + "<tr valign='top'><td align='left' width='20%'>VALUE</td><td width='80%' colspan='4'>NOT FOUND</td></tr>\n";
                    text = text + "</table>";
                }

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);

            } else {
                SendToClientWithShap(SO_LOG_ERROR, 400, "bad parameter 'shingle'", 0);
            }

        } else {
            SendToClientWithShap(SO_LOG_ERROR, 400, "no defined parameter 'shingle'", 0);
        }
    }
}

void TMakeRequest::Cleanup(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    int type = -1;
    TString type_s = "";
    bool est_type = false;

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        par_it = m_ReqParams->find("type");
        if (par_it != m_ReqParams->end()) {
            type_s = Trim(par_it->second[0]);
            type = atoi(type_s.c_str());
            est_type = true;
        }

        GetGeneralObject()->ShinglesStorage->Cleanup(type);

        if (type >= 0)
            text = text + "Cleanup type=" + IntToStroka(type) + " accepted.";
        else
            text = text + "Cleanup all types accepted.";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);
    }
}

void TMakeRequest::AskCleanup(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    int type = -1;
    TString type_s = "";

    par_it = m_ReqParams->find("type");
    if (par_it != m_ReqParams->end()) {
        type_s = Trim(par_it->second[0]);
        type = atoi(type_s.c_str());
    }

    text = text + HTTP_200_OK("-");
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    if (type >= 0) {
        text = text + "if(true == confirm('Cleanup type=" + IntToStroka(type) + " ?')) {\n";
        text = text + "document.location = '" + GetHost() + GetModuleName("cleanup") + GetActionOneParam("cleanup") + "&type=" + IntToStroka(type) + "'\n";

    } else {
        text = text + "if(true == confirm('Cleanup all types?')) {\n";
        text = text + "document.location = '" + GetHost() + GetModuleName("cleanup") + GetActionOneParam("cleanup") + "'\n";
    }
    text = text + "} else {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";
    SendToClientRAW(text);
}

void TMakeRequest::AskWritedump(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    int type = -1;
    TString type_s = "";

    par_it = m_ReqParams->find("type");
    if (par_it != m_ReqParams->end()) {
        type_s = Trim(par_it->second[0]);
        type = atoi(type_s.c_str());
    }

    text = text + HTTP_200_OK("-");
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    if (type >= 0) {
        text = text + "if(true == confirm('Writedump type=" + IntToStroka(type) + " ?')) {\n";
        text = text + "document.location = '" + GetHost() + GetModuleName("writedump") + GetActionOneParam("writedump") + "&type=" + IntToStroka(type) + "'\n";

    } else {
        text = text + "if(true == confirm('Writedump all types?')) {\n";
        text = text + "document.location = '" + GetHost() + GetModuleName("writedump") + GetActionOneParam("writedump") + "'\n";
    }
    text = text + "} else {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";
    SendToClientRAW(text);
}

void TMakeRequest::Writedump(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TReqParams::iterator par_it;
    int type = -1;
    TString type_s = "";
    bool est_type = false;
    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        par_it = m_ReqParams->find("type");
        if (par_it != m_ReqParams->end()) {
            type_s = Trim(par_it->second[0]);
            type = atoi(type_s.c_str());
            est_type = true;
        }

        GetGeneralObject()->ShinglesStorage->Writedump(type);

        if (type >= 0)
            text = text + "Writedump type=" + IntToStroka(type) + " accepted.";
        else
            text = text + "Writedump all types accepted.";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);
    }
}

void TMakeRequest::ViewRPLStat(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TRPLStatDataSummary statdata;
    TReqParams::iterator par_it;
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    ui32 today_all = 0, yesterday_all = 0;
    ui32 today_all_heavy = 0, yesterday_all_heavy = 0;
    TString reloadlink = "";
    TString type_s = "";
    int type = -1;
    bool est_type = false;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("type");
        if (par_it != m_ReqParams->end()) {
            type_s = Trim(par_it->second[0]);
            type = atoi(type_s.c_str());
        }
    }

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->PoolRPL != NULL)) {
        statdata = GetGeneralObject()->PoolRPL->GetStat();

        if ((type >= 0) && (type < statdata.max_count)) {
            if (statdata.data[type].enable_client)
                est_type = true;
            else
                est_type = false;
        } else
            est_type = false;

        text = text + "<br><i><b>Summary replic statistik:</b></i>&nbsp;&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        text = text + "<tr valign='top'>";
        text = text + "<td align='left' width='5%'>&nbsp;</td>";
        text = text + "<td align='left' width='19%'><b>REPLIC URL</b></td>";
        text = text + "<td align='left' width='6%'><b>RemSrvID</b></td>";
        text = text + "<td align='left' width='25%'><b>QUEUE: IN / UPDATE / COUNT / LOST / OUT</b></td>";
        text = text + "<td align='left' width='22%'><b>CONNECT: OK / ERROR / TIMEOUT</b></td>";
        text = text + "<td align='left' width='23%'><b>REQUEST: 200 / 4XX / 5XX / ERROR / TIMEOT</b></td>";
        text = text + "</tr>\n";
        for (int i = 0; i < statdata.max_count; i++) {
            if (statdata.data[i].enable_client) {
                text = text + "<tr valign='top'>";
                if (est_type && (type == i)) {
                    text = text + "<td align='left' rowspan='2'>*DIR-" + IntToStroka2(i + 1) + "</td>";
                } else {
                    TString typelink = "<A href='" + GetHost() + GetModuleName("viewrplstat") + GetActionOneParam("viewrplstat") + "&type=" + IntToStroka(i) + "'>DIR-" + IntToStroka2(i + 1) + "</A>";
                    text = text + "<td align='left' rowspan='2'>" + typelink + "</td>";
                }
                text = text + "<td align='left' rowspan='2'>" + statdata.data[i].host + "</td>";
                text = text + "<td align='left'>" + statdata.data[i].remote_srvid + "&nbsp;</td>";
                text = text + "<td align='left'>" + IntToStroka(statdata.data[i].today.queue_in) + " / " + IntToStroka(statdata.data[i].today.queue_up) + " / " + IntToStroka(statdata.data[i].today.queue_count) + " / " + IntToStroka(statdata.data[i].today.queue_lost) + " / " + IntToStroka(statdata.data[i].today.queue_out) + "</td>";
                text = text + "<td align='left'>" + IntToStroka(statdata.data[i].today.connect_ok) + " / " + IntToStroka(statdata.data[i].today.connect_error) + " / " + IntToStroka(statdata.data[i].today.connect_timeout) + "</td>";
                text = text + "<td align='left'>" + IntToStroka(statdata.data[i].today.request_200_count) + " / " + IntToStroka(statdata.data[i].today.request_4xx_count) + " / " + IntToStroka(statdata.data[i].today.request_5xx_count) + " / " + IntToStroka(statdata.data[i].today.request_error) + " / " + IntToStroka(statdata.data[i].today.request_timeout) + "</td>";
                text = text + "</tr>\n";

                text = text + "<tr valign='top'>";
                text = text + "<td align='center'>yesterday</td>";
                text = text + "<td align='left'>" + IntToStroka(statdata.data[i].yesterday.queue_in) + " / " + IntToStroka(statdata.data[i].yesterday.queue_up) + " / " + IntToStroka(statdata.data[i].yesterday.queue_count) + " / " + IntToStroka(statdata.data[i].yesterday.queue_lost) + " / " + IntToStroka(statdata.data[i].yesterday.queue_out) + "</td>";
                text = text + "<td align='left'>" + IntToStroka(statdata.data[i].yesterday.connect_ok) + " / " + IntToStroka(statdata.data[i].yesterday.connect_error) + " / " + IntToStroka(statdata.data[i].yesterday.connect_timeout) + "</td>";
                text = text + "<td align='left'>" + IntToStroka(statdata.data[i].yesterday.request_200_count) + " / " + IntToStroka(statdata.data[i].yesterday.request_4xx_count) + " / " + IntToStroka(statdata.data[i].yesterday.request_5xx_count) + " / " + IntToStroka(statdata.data[i].yesterday.request_error) + " / " + IntToStroka(statdata.data[i].yesterday.request_timeout) + "</td>";
                text = text + "</tr>\n";
            }
        }
        text = text + "</table><br>";

        if (est_type) {
            text = text + "<b><i>Replic statistik from type=" + IntToStroka(type + 1) + "</i></b>&nbsp;";
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
            text = text + "<tr valign='top'><td align='left' width='20%'>Threads count</td><td width='80%' colspan='4'>" + IntToStroka(statdata.data[type].threads) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'>Enable proxy</td><td width='80%' colspan='4'>" + BoolToStroka2(statdata.data[type].enable_client) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'>Old protokol</td><td width='80%' colspan='4'>" + BoolToStroka2(statdata.data[type].old) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'>Example request url</td><td width='80%' colspan='4'>" + GetGeneralObject()->PoolRPL->GetExampleRequest(type) + reloadlink + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'>Max queue size</td><td width='80%' colspan='4'>" + UI64ToStroka(statdata.data[type].max_queue_size) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'>Max shingles in request</td><td width='80%' colspan='4'>" + UI64ToStroka(statdata.data[type].max_shingles_in_request) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'>Min shingles in request</td><td width='80%' colspan='4'>" + UI64ToStroka(statdata.data[type].min_shingles_in_request) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'>Timeout create sendblock</td><td width='80%' colspan='4'>" + UI64ToStroka(statdata.data[type].timeout_create_sendblock) + "</td></tr>\n";
            text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='5'>&nbsp;</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'><b>QUEUE</b></td><td align='center' width='40%' colspan='2'><b>TODAY</b></td><td align='center' width='40%' colspan='2'><b>YESTERDAY</b></td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Shingles IN (UPDATE)</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.queue_in) + " (" + IntToStroka(statdata.data[type].today.queue_up) + ")</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.queue_in) + " (" + IntToStroka(statdata.data[type].yesterday.queue_up) + ")</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Shingles OUT</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.queue_out) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.queue_out) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Shingles to queue</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.queue_count) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.queue_count) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Shingles lost</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.queue_lost) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.queue_lost) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Request IN</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.queue_in_rqst) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.queue_in_rqst) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Request OUT</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.queue_out_rqst) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.queue_out_rqst) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Create sendblock by time</td><td colspan='2'>" + UI64ToStroka(statdata.data[type].need_return_data_time_today) + "</td><td colspan='2'>" + UI64ToStroka(statdata.data[type].need_return_data_time_yesterday) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Create sendblock by count</td><td colspan='2'>" + UI64ToStroka(statdata.data[type].need_return_data_count_today) + "</td><td colspan='2'>" + UI64ToStroka(statdata.data[type].need_return_data_count_yesterday) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>inqueue_count</td><td colspan='2'>" + IntToStroka(statdata.data[type].inqueue_count) + "</td><td colspan='2'>&nbsp;</td></tr>\n";
            text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='5'>&nbsp;</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'><b>CLIENTS POOL</b></td><td align='center' width='40%' colspan='2'><b>TODAY</b></td><td align='center' width='40%' colspan='2'><b>YESTERDAY</b></td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>All request count</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.all_mail_count) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.all_mail_count) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Connect ok</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.connect_ok) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.connect_ok) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Connect error</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.connect_error) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.connect_error) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Connect timeout</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.connect_timeout) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.connect_timeout) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Request ok (200)</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.request_200_count) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.request_200_count) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Request with code 4xx</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.request_4xx_count) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.request_4xx_count) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Request with code 5xx</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.request_5xx_count) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.request_5xx_count) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Request with other code</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.request_other_count) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.request_other_count) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Request error</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.request_error) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.request_error) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Request timeout</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.request_timeout) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.request_timeout) + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left'>Request buffer overflow</td><td colspan='2'>" + IntToStroka(statdata.data[type].today.request_buffer_overflow) + "</td><td colspan='2'>" + IntToStroka(statdata.data[type].yesterday.request_buffer_overflow) + "</td></tr>\n";
            text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='5'>&nbsp;</td></tr>\n";

            text = text + "</table>";

        } else
            text = text + "No data this type.";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);
    }
}

void TMakeRequest::LoadSimpleStorage(const TString& id) {
    TString text = "";
    ui32 ecount = 0;
    ui32 edublicat = 0;

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->SimpleStorage != NULL)) {
        if (GetGeneralObject()->SimpleStorage->Load(ecount, edublicat))
            text = text + "Storage loaded - OK\ncount: " + IntToStroka(ecount) + " dublicat: " + IntToStroka(edublicat);
        else
            text = text + "Storage loaded - FAILED";
        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);

    } else
        SendToClientWithShap(SO_LOG_ERROR, 500, text, id);
}

void TMakeRequest::ViewFollowShingles(const TString& id) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TFollowShinglesList list;
    TFollowShinglesListIt it;

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL)) {
        GetGeneralObject()->ShinglesStorage->GetListFollowShingles(list);

        TString addshingleform = "<br>Add shingle: &nbsp;<form action='" + GetHost() + GetModuleName("addfollowsh") + "' method='GET' enctype='text/plain'>&nbsp; shingle=<input type='text' size='30' name='shingle' value=''>&nbsp; type=<input type='text' size='10' name='type' value=''>&nbsp; " + GetActionFormParam("addfollowsh") + "<input type='submit' size='10' value='add shingle'></form>\n";

        text = text + addshingleform + "<br>";

        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
        text = text + "<tr valign='top'><td valign='left' width='40%'><b>SHINGLE-TYPE</b></td><td valign='left' width='30%'><b>GETCOUNT</b></td><td valign='left' width='30%'>&nbsp;</td></tr>\n";
        it = list.begin();
        while (it != list.end()) {
            text = text + "<tr>\n";
            if ((*it).m_shingle == 0)
                text = text + "<td>* -" + IntToStroka((*it).m_type) + "</td>";
            else
                text = text + "<td>0x" + ShingleToStroka((*it).m_shingle) + "-" + IntToStroka((*it).m_type) + "</td>";
            text = text + "<td>" + UI64ToStroka((*it).m_get_count) + "</td>";
            text = text + "<td><A href='" + GetHost() + GetModuleName("delfollowsh") + GetActionOneParam("delfollowsh") + "&shingle=" + ShingleToStroka((*it).m_shingle) + "&type=" + IntToStroka((*it).m_type) + "' >delete</A></td>";
            text = text + "</tr>\n";

            ++it;
        }
        text = text + "</table>";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);

    } else
        SendToClientWithShap(SO_LOG_ERROR, 500, text, id);
}

void TMakeRequest::AddFollowShingles(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TString shingle_s = "";
    ui64 shingle = 0;
    TString type_s = "";
    int type = 0;
    bool ok = false;
    bool est_shingle = false;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("shingle");
        if (par_it != m_ReqParams->end()) {
            shingle_s = Trim(par_it->second[0]);
            sscanf(shingle_s.c_str(), "%" PRIx64 "", &shingle);
            est_shingle = true;
        }

        par_it = m_ReqParams->find("type");
        if (par_it != m_ReqParams->end()) {
            type_s = Trim(par_it->second[0]);
            type = atoi(type_s.c_str());
        }

        if ((est_shingle) && (type > 0) && (type < TShingleStorageMain::MAX_COUNT_TYPES)) {
            if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL))
                ok = GetGeneralObject()->ShinglesStorage->AddFollowShingle(shingle, type);
        }

        if (ok) {
            if (shingle == 0)
                text = text + "Add shingle * -" + IntToStroka(type) + " SUCCESFULLY.";
            else
                text = text + "Add shingle 0x" + ShingleToStroka(shingle) + "-" + IntToStroka(type) + " SUCCESFULLY.";
        } else {
            if (shingle == 0)
                text = text + "Add shingle * -" + IntToStroka(type) + " FAILED.";
            else
                text = text + "Add shingle 0x" + ShingleToStroka(shingle) + "-" + IntToStroka(type) + " FAILED.";
        }
        text = text + "<br><br><A href='" + GetHost() + GetModuleName("viewfollowsh") + GetActionOneParam("viewfollowsh") + "'>view follow shingles list</A>";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, "INTERNAL_SERVER_ERROR.", 0);
    }
}

void TMakeRequest::DelFollowShingles(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TString shingle_s = "";
    ui64 shingle = 0;
    TString type_s = "";
    int type = 0;
    bool ok = false;
    bool est_shingle = false;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("shingle");
        if (par_it != m_ReqParams->end()) {
            shingle_s = Trim(par_it->second[0]);
            sscanf(shingle_s.c_str(), "%" PRIx64 "", &shingle);
            est_shingle = true;
        }

        par_it = m_ReqParams->find("type");
        if (par_it != m_ReqParams->end()) {
            type_s = Trim(par_it->second[0]);
            type = atoi(type_s.c_str());
        }

        if ((est_shingle) && (type > 0) && (type < TShingleStorageMain::MAX_COUNT_TYPES)) {
            if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL))
                ok = GetGeneralObject()->ShinglesStorage->DeleteFollowShingle(shingle, type);
        }

        if (ok) {
            if (shingle == 0)
                text = text + "Delete shingle * -" + IntToStroka(type) + " SUCCESFULLY.";
            else
                text = text + "Delete shingle 0x" + ShingleToStroka(shingle) + "-" + IntToStroka(type) + " SUCCESFULLY.";
        } else {
            if (shingle == 0)
                text = text + "Delete shingle * -" + IntToStroka(type) + " FAILED.";
            else
                text = text + "Delete shingle 0x" + ShingleToStroka(shingle) + "-" + IntToStroka(type) + " FAILED.";
        }
        text = text + "<br><br><A href='" + GetHost() + GetModuleName("viewfollowsh") + GetActionOneParam("viewfollowsh") + "'>view follow shingles list</A>";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, "INTERNAL_SERVER_ERROR.", 0);
    }
}

void TMakeRequest::SetLongRequest(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    char* table_color = "'#ffffcc'";
    char* cell_color = "PaleGoldenrod";
    TString time_s = "";
    ui32 time_v = 0;
    bool ok = false;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("time");
        if (par_it != m_ReqParams->end()) {
            time_s = Trim(par_it->second[0]);
            time_v = atol(time_s.c_str());
            ok = true;
        }

        if (ok) {
            if ((GetGeneralObject() != NULL) && (GetGeneralObject()->ShinglesStorage != NULL))
                GetGeneralObject()->ShinglesStorage->SetLongDelayMs(time_v);

            text = text + "Set longrequest treshold " + IntToStroka(time_v) + " SUCCESFULLY.";

        } else {
            text = text + "Set longrequest treshold " + IntToStroka(time_v) + " FAILED.";
        }

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, 0);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, "INTERNAL_SERVER_ERROR.", 0);
    }
}
