#pragma once

#include <mail/so/spamstop/tools/fcgiserver_base/tserviceobjectbase.h>
#include <mail/so/spamstop/tools/fcgiserver_base/tmakerequestbase.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include "tserviceobject.h"
#include "tlogsgroup.h"
#include "tgeneralobject.h"

class TMakeRequest: public TMakeRequestBase {
private:
    TServiceObject& GetServiceObject() {
        return dynamic_cast<TServiceObject&>(srvcobj);
    }
    TLogsGroup* GetLogsGroup() {
        return (TLogsGroup*)srvcobj.GetLogsGroup();
    }
    TKConfig* GetConfigObject() {
        return srvcobj.GetConfigObject();
    }
    TGeneralObject* GetGeneralObject() {
        return dynamic_cast<TGeneralObject*>(srvcobj.GetGeneralObject());
    }

    void Midnight(const TString& id, TReqParams* m_ReqParams);
    void Shutdown(const TString& id, TReqParams* m_ReqParams);
    void Console(const TString& id, TReqParams* m_ReqParams);
    void ExtConsole(const TString& id, TReqParams* m_ReqParams);

    bool ActionWOParse(const TString& Ident, TRequestDopData& data, const TString& InRequest, const TString& NumbRequest, const TString& request_source, int thread_index);
    bool ActionParse(const TString& Ident, TRequestDopData& data, TReqParams* m_ReqParams, const TString& NumbRequest, const TString& requrl, int thread_index);

    void ViewProxyStat(const TString& id);
    void ViewShinglesStat(const TString& id);
    void ViewShinglesStat2(const TString& id);
    void ViewShinglesStatBusy(const TString& id);
    void ViewTypeStat(const TString& id, TReqParams* m_ReqParams);
    void ViewShingleInfo(const TString& id, TReqParams* m_ReqParams);
    void ClearShingleInfo(const TString& id, TReqParams* m_ReqParams);
    void AskClearShingleInfo(const TString& id, TReqParams* m_ReqParams);
    void ViewStorageShingleInfo(const TString& id, TReqParams* m_ReqParams);
    void Cleanup(const TString& id, TReqParams* m_ReqParams);
    void AskCleanup(const TString& id, TReqParams* m_ReqParams);
    void Writedump(const TString& id, TReqParams* m_ReqParams);
    void AskWritedump(const TString& id, TReqParams* m_ReqParams);
    void ViewRPLStat(const TString& id, TReqParams* m_ReqParams);
    void LoadSimpleStorage(const TString& id);
    void ViewFollowShingles(const TString& id);
    void AddFollowShingles(const TString& id, TReqParams* m_ReqParams);
    void DelFollowShingles(const TString& id, TReqParams* m_ReqParams);
    void SetLongRequest(const TString& id, TReqParams* m_ReqParams);

public:
    TMakeRequest(TServiceObjectBase& srvcobjA, void* serverA);
    ~TMakeRequest();
};
