#include "tmonobj.h"

TMonObj::TMonObj() {
    lastwritedata = time(NULL);
    Clear();
}

TMonObj::~TMonObj() {
}

void TMonObj::Init(TLogsGroup* LogsGroupA, TShingleStorageMain* ShinglesStorageA, TProxyPool* PoolProxyA, TRPLMain* PoolRPLA) {
    LogsGroup = LogsGroupA;
    ShinglesStorage = ShinglesStorageA;
    PoolProxy = PoolProxyA;
    PoolRPL = PoolRPLA;
    lastwritedata = time(NULL);
}

void TMonObj::Clear() {
    new_in_rqst_last = 0;
    new_lost_rqst_last = 0;
    old_in_rqst_last = 0;
    old_lost_rqst_last = 0;
    rpl_in_rqst_last = 0;
    rpl_lost_rqst_last = 0;
    prx_in_rqst_last = 0;
    prx_lost_rqst_last = 0;
    in_shget_count_last_old = 0;
    in_shput_count_last_old = 0;
    in_stget_count_last_old = 0;
    in_shget_count_last_new = 0;
    in_shput_count_last_new = 0;
    in_stget_count_last_new = 0;
    in_rpl_count_last = 0;
    in_prxget_count_last = 0;
    in_prxput_count_last = 0;
    proxystat_last.Clear();
    proxy_forbid_last = 0;
    for (int i = 0; i < MAX_DIRECTS_COUNT; i++)
        rpl_stat_direct_last[i].Clear();
}

void TMonObj::WriteMonData() {
    time_t current_time = time(NULL);
    char buff[4096];
    TString inrqst_data = "";
    TString inshin_data = "";
    TString proxy_data = "";
    TString rpl_data = "";
    TString timingdata = "";

    if ((current_time - lastwritedata) >= 60) {
        lastwritedata = current_time;

        if (ShinglesStorage != NULL) {
            // "<INRQST newrps='X', newin='X', newlost='X', oldrps='X', oldin='X', oldlost='X', rplrps='X', rplin='X', rpllost='X', prxrps='X', prxin='X', prxlost='X'>"
            float new_rps = 0;
            ui64 new_in_rqst = 0;
            ui64 new_lost_rqst = 0;
            ui64 new_in_rqst_diff = 0;
            ui64 new_lost_rqst_diff = 0;
            float old_rps = 0;
            ui64 old_in_rqst = 0;
            ui64 old_lost_rqst = 0;
            ui64 old_in_rqst_diff = 0;
            ui64 old_lost_rqst_diff = 0;
            float rpl_rps = 0;
            ui64 rpl_in_rqst = 0;
            ui64 rpl_lost_rqst = 0;
            ui64 rpl_in_rqst_diff = 0;
            ui64 rpl_lost_rqst_diff = 0;
            float prx_rps = 0;
            ui64 prx_in_rqst = 0;
            ui64 prx_lost_rqst = 0;
            ui64 prx_in_rqst_diff = 0;
            ui64 prx_lost_rqst_diff = 0;

            if (ShinglesStorage->GetNewTrafficControl() != NULL) {
                new_rps = ShinglesStorage->GetNewTrafficControl()->GetInMPS();
                new_in_rqst = ShinglesStorage->GetNewTrafficControl()->GetTodayRequest();
                new_lost_rqst = ShinglesStorage->GetNewTrafficControl()->GetTodayLostRequest();

                if ((new_in_rqst < new_in_rqst_last) || (new_lost_rqst < new_lost_rqst_last)) {
                    new_in_rqst_last = 0;
                    new_lost_rqst_last = 0;
                }

                new_in_rqst_diff = new_in_rqst - new_in_rqst_last;
                new_lost_rqst_diff = new_lost_rqst - new_lost_rqst_last;

                new_in_rqst_last = new_in_rqst;
                new_lost_rqst_last = new_lost_rqst;
            }
            if (ShinglesStorage->GetOldTrafficControl() != NULL) {
                old_rps = ShinglesStorage->GetOldTrafficControl()->GetInMPS();
                old_in_rqst = ShinglesStorage->GetOldTrafficControl()->GetTodayRequest();
                old_lost_rqst = ShinglesStorage->GetOldTrafficControl()->GetTodayLostRequest();

                if ((old_in_rqst < old_in_rqst_last) || (old_lost_rqst < old_lost_rqst_last)) {
                    old_in_rqst_last = 0;
                    old_lost_rqst_last = 0;
                }

                old_in_rqst_diff = old_in_rqst - old_in_rqst_last;
                old_lost_rqst_diff = old_lost_rqst - old_lost_rqst_last;

                old_in_rqst_last = old_in_rqst;
                old_lost_rqst_last = old_lost_rqst;
            }
            if (ShinglesStorage->GetRplTrafficControlRequest() != NULL) {
                rpl_rps = ShinglesStorage->GetRplTrafficControlRequest()->GetInMPS();
                rpl_in_rqst = ShinglesStorage->GetRplTrafficControlRequest()->GetTodayRequest();
                rpl_lost_rqst = ShinglesStorage->GetRplTrafficControlRequest()->GetTodayLostRequest();

                if ((rpl_in_rqst < rpl_in_rqst_last) || (rpl_lost_rqst < rpl_lost_rqst_last)) {
                    rpl_in_rqst_last = 0;
                    rpl_lost_rqst_last = 0;
                }

                rpl_in_rqst_diff = rpl_in_rqst - rpl_in_rqst_last;
                rpl_lost_rqst_diff = rpl_lost_rqst - rpl_lost_rqst_last;

                rpl_in_rqst_last = rpl_in_rqst;
                rpl_lost_rqst_last = rpl_lost_rqst;
            }
            if (ShinglesStorage->GetPrxTrafficControl() != NULL) {
                prx_rps = ShinglesStorage->GetPrxTrafficControl()->GetInMPS();
                prx_in_rqst = ShinglesStorage->GetPrxTrafficControl()->GetTodayRequest();
                prx_lost_rqst = ShinglesStorage->GetPrxTrafficControl()->GetTodayLostRequest();

                if ((prx_in_rqst < prx_in_rqst_last) || (prx_lost_rqst < prx_lost_rqst_last)) {
                    prx_in_rqst_last = 0;
                    prx_lost_rqst_last = 0;
                }

                prx_in_rqst_diff = prx_in_rqst - prx_in_rqst_last;
                prx_lost_rqst_diff = prx_lost_rqst - prx_lost_rqst_last;

                prx_in_rqst_last = prx_in_rqst;
                prx_lost_rqst_last = prx_lost_rqst;
            }

            buff[sizeof(buff) - 1] = 0x00;
            snprintf(buff, sizeof(buff) - 1, "<INRQST newrps='%f', newin='%" PRIu64 "', newlost='%" PRIu64 "', oldrps='%f', oldin='%" PRIu64 "', oldlost='%" PRIu64 "', rplrps='%f', rplin='%" PRIu64 "', rpllost='%" PRIu64 "', prxrps='%f', prxin='%" PRIu64 "', prxlost='%" PRIu64 "'>", new_rps, new_in_rqst_diff, new_lost_rqst_diff, old_rps, old_in_rqst_diff, old_lost_rqst_diff, rpl_rps, rpl_in_rqst_diff, rpl_lost_rqst_diff, prx_rps, prx_in_rqst_diff, prx_lost_rqst_diff);

            inrqst_data = TString(buff);
        }
        if (ShinglesStorage != NULL) {
            // "<INSHIN(old/new) shget='X/X', shput='X/X', stget='X/X', rpl='X', prxget='X', prxput='X'>"
            ui64 in_shget_count_old = 0;
            ui64 in_shput_count_old = 0;
            ui64 in_stget_count_old = 0;
            ui64 in_shget_count_new = 0;
            ui64 in_shput_count_new = 0;
            ui64 in_stget_count_new = 0;
            ui64 in_rpl_count = 0;
            ui64 in_prxget_count = 0;
            ui64 in_prxput_count = 0;
            ui64 in_shget_count_diff_old = 0;
            ui64 in_shput_count_diff_old = 0;
            ui64 in_stget_count_diff_old = 0;
            ui64 in_shget_count_diff_new = 0;
            ui64 in_shput_count_diff_new = 0;
            ui64 in_stget_count_diff_new = 0;
            ui64 in_rpl_count_diff = 0;
            ui64 in_prxget_count_diff = 0;
            ui64 in_prxput_count_diff = 0;

            if (ShinglesStorage->GetShGetTrafficControlOld() != NULL)
                in_shget_count_old = ShinglesStorage->GetShGetTrafficControlOld()->GetTodayRequest();
            if (ShinglesStorage->GetShPutTrafficControlOld() != NULL)
                in_shput_count_old = ShinglesStorage->GetShPutTrafficControlOld()->GetTodayRequest();
            if (ShinglesStorage->GetStGetTrafficControlOld() != NULL)
                in_stget_count_old = ShinglesStorage->GetStGetTrafficControlOld()->GetTodayRequest();
            if (ShinglesStorage->GetShGetTrafficControlNew() != NULL)
                in_shget_count_new = ShinglesStorage->GetShGetTrafficControlNew()->GetTodayRequest();
            if (ShinglesStorage->GetShPutTrafficControlNew() != NULL)
                in_shput_count_new = ShinglesStorage->GetShPutTrafficControlNew()->GetTodayRequest();
            if (ShinglesStorage->GetStGetTrafficControlNew() != NULL)
                in_stget_count_new = ShinglesStorage->GetStGetTrafficControlNew()->GetTodayRequest();

            if (ShinglesStorage->GetRplTrafficControlShingles() != NULL)
                in_rpl_count = ShinglesStorage->GetRplTrafficControlShingles()->GetTodayRequest();
            if (ShinglesStorage->GetPrxGetTrafficControl() != NULL)
                in_prxget_count = ShinglesStorage->GetPrxGetTrafficControl()->GetTodayRequest();
            if (ShinglesStorage->GetPrxPutTrafficControl() != NULL)
                in_prxput_count = ShinglesStorage->GetPrxPutTrafficControl()->GetTodayRequest();

            if ((in_shget_count_old < in_shget_count_last_old) ||
                (in_shput_count_old < in_shput_count_last_old) ||
                (in_stget_count_old < in_stget_count_last_old) ||
                (in_shget_count_new < in_shget_count_last_new) ||
                (in_shput_count_new < in_shput_count_last_new) ||
                (in_stget_count_new < in_stget_count_last_new) ||
                (in_rpl_count < in_rpl_count_last) ||
                (in_prxget_count < in_prxget_count_last) ||
                (in_prxput_count < in_prxput_count_last))
            {
                in_shget_count_last_old = 0;
                in_shput_count_last_old = 0;
                in_stget_count_last_old = 0;
                in_shget_count_last_new = 0;
                in_shput_count_last_new = 0;
                in_stget_count_last_new = 0;
                in_rpl_count_last = 0;
                in_prxget_count_last = 0;
                in_prxput_count_last = 0;
            }

            in_shget_count_diff_old = in_shget_count_old - in_shget_count_last_old;
            in_shput_count_diff_old = in_shput_count_old - in_shput_count_last_old;
            in_stget_count_diff_old = in_stget_count_old - in_stget_count_last_old;
            in_shget_count_diff_new = in_shget_count_new - in_shget_count_last_new;
            in_shput_count_diff_new = in_shput_count_new - in_shput_count_last_new;
            in_stget_count_diff_new = in_stget_count_new - in_stget_count_last_new;
            in_rpl_count_diff = in_rpl_count - in_rpl_count_last;
            in_prxget_count_diff = in_prxget_count - in_prxget_count_last;
            in_prxput_count_diff = in_prxput_count - in_prxput_count_last;

            in_shget_count_last_old = in_shget_count_old;
            in_shput_count_last_old = in_shput_count_old;
            in_stget_count_last_old = in_stget_count_old;
            in_shget_count_last_new = in_shget_count_new;
            in_shput_count_last_new = in_shput_count_new;
            in_stget_count_last_new = in_stget_count_new;
            in_rpl_count_last = in_rpl_count;
            in_prxget_count_last = in_prxget_count;
            in_prxput_count_last = in_prxput_count;

            buff[sizeof(buff) - 1] = 0x00;
            snprintf(buff, sizeof(buff) - 1, "<INSHIN(old/new) shget='%" PRIu64 "/%" PRIu64 "', shput='%" PRIu64 "/%" PRIu64 "', stget='%" PRIu64 "/%" PRIu64 "', rpl='%" PRIu64 "', prxget='%" PRIu64 "', prxput='%" PRIu64 "'>", in_shget_count_diff_old, in_shget_count_diff_new, in_shput_count_diff_old, in_shput_count_diff_new, in_stget_count_diff_old, in_stget_count_diff_new, in_rpl_count_diff, in_prxget_count_diff, in_prxput_count_diff);
            inshin_data = TString(buff);
        }
        if (ShinglesStorage != NULL) {
            // "<TIMING(0_10-10_20-20_30-30_40-40_50-50_100-100_200-200_500-more500): clust='XX/XX/XX/XX/XX/XX/XX/XX/XX' rpl='XX/XX/XX/XX/XX/XX/XX/XX/XX' prx='XX/XX/XX/XX/XX/XX/XX/XX/XX' >"
            timingdata = timingdata + "<TIMING: ";
            timingdata = timingdata + "clust='" + ShinglesStorage->GetClusterDelayObj()->GetDiff().toLog() + "' ";
            timingdata = timingdata + "rpl='" + ShinglesStorage->GetRplDelayObj()->GetDiff().toLog() + "' ";
            timingdata = timingdata + "clust='" + ShinglesStorage->GetPrxDelayObj()->GetDiff().toLog() + "' ";
            timingdata = timingdata + ">";
        }
        if (ShinglesStorage != NULL) {
            // "<BUSYSTAT(get-getheavy-put-putm-setm-setweight): XX-XX-XX-XX-XX-XX >"
            timingdata = timingdata + "<BUSYSTAT: ";
            timingdata = timingdata + ShinglesStorage->GetBusyMonstatObj()->GetDiff() + " ";
            timingdata = timingdata + ">";
        }
        if (PoolProxy != NULL) {
            // "<PRX queue='in/out/count/lost/rqst_in/rqst_out' net='forbid/all/CE/CT/200/404/400499/OCODE/RE/RT/RBO'>"
            TProxyStatDataItem proxystat, proxystat_diff;
            TProxyStatData psd;
            ui64 proxy_forbid = 0;
            ui32 proxy_forbid_diff = 0;
            ui32 q1 = 0, q2 = 0, q3 = 0, q4 = 0, q5 = 0, q6 = 0;
            ui32 n1 = 0, n2 = 0, n3 = 0, n4 = 0, n5 = 0, n6 = 0, n7 = 0, n8 = 0, n9 = 0, n10 = 0, n11 = 0;

            psd = PoolProxy->GetStat();
            proxy_forbid = psd.proxy_put_forbid_today;
            proxystat = psd.today;
            proxystat_diff = proxystat;

            if (proxy_forbid < proxy_forbid_last)
                proxy_forbid_last = 0;

            proxy_forbid_diff = proxy_forbid - proxy_forbid_last;
            proxystat_diff -= proxystat_last;

            proxy_forbid_last = proxy_forbid;
            proxystat_last = proxystat;

            q1 = proxystat_diff.queue_in;
            q2 = proxystat_diff.queue_out;
            q3 = proxystat.queue_count;
            q4 = proxystat_diff.queue_lost;
            q5 = proxystat_diff.queue_in_rqst;
            q6 = proxystat_diff.queue_out_rqst;

            n1 = proxy_forbid_diff;
            n2 = proxystat_diff.all_mail_count;
            n3 = proxystat_diff.connect_error;
            n4 = proxystat_diff.connect_timeout;
            n5 = proxystat_diff.request_200_count;
            n6 = proxystat_diff.request_404_count;
            n7 = proxystat_diff.request_400500_count;
            n8 = proxystat_diff.request_other_count;
            n9 = proxystat_diff.request_error;
            n10 = proxystat_diff.request_timeout;
            n11 = proxystat_diff.request_buffer_overflow;

            buff[sizeof(buff) - 1] = 0x00;
            snprintf(buff, sizeof(buff) - 1, "<PRX queue='%u/%u/%u/%u/%u/%u' net='%u/%u/%u/%u/%u/%u/%u/%u/%u/%u/%u'>", q1, q2, q3, q4, q5, q6, n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
            proxy_data = TString(buff);
        }
        if (PoolRPL != NULL) {
            // "<RPL-XX queue='in/out/count/lost/rqst_in/rqst_out' net='all/COK/CE/CT/200/4xx/5xx/OCODE/RE/RT/RBO'>"
            TRPLStatDataSummary rplst;
            TRPLStatDataItem rplst_item_diff;
            ui32 q1 = 0, q2 = 0, q3 = 0, q4 = 0, q5 = 0, q6 = 0;
            ui32 n1 = 0, n2 = 0, n3 = 0, n4 = 0, n5 = 0, n6 = 0, n7 = 0, n8 = 0, n9 = 0, n10 = 0, n11 = 0;

            rplst = PoolRPL->GetStat();
            for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
                if (rplst.data[i].enable_client) {
                    rplst_item_diff = rplst.data[i].today;
                    rplst_item_diff -= rpl_stat_direct_last[i];
                    rpl_stat_direct_last[i] = rplst.data[i].today;

                    q1 = rplst_item_diff.queue_in;
                    q2 = rplst_item_diff.queue_out;
                    q3 = rplst.data[i].today.queue_count;
                    q4 = rplst_item_diff.queue_lost;
                    q5 = rplst_item_diff.queue_in_rqst;
                    q6 = rplst_item_diff.queue_out_rqst;

                    n1 = rplst_item_diff.all_mail_count;
                    n2 = rplst_item_diff.connect_ok;
                    n3 = rplst_item_diff.connect_error;
                    n4 = rplst_item_diff.connect_timeout;
                    n5 = rplst_item_diff.request_200_count;
                    n6 = rplst_item_diff.request_4xx_count;
                    n7 = rplst_item_diff.request_5xx_count;
                    n8 = rplst_item_diff.request_other_count;
                    n9 = rplst_item_diff.request_error;
                    n10 = rplst_item_diff.request_timeout;
                    n11 = rplst_item_diff.request_buffer_overflow;

                    buff[sizeof(buff) - 1] = 0x00;
                    snprintf(buff, sizeof(buff) - 1, "<RPL-%02d queue='%u/%u/%u/%u/%u/%u' net='%u/%u/%u/%u/%u/%u/%u/%u/%u/%u/%u'>", i + 1, q1, q2, q3, q4, q5, q6, n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
                    rpl_data = rpl_data + TString(buff);
                }
            }
        }

        if ((LogsGroup != NULL) && (LogsGroup->GetMonLog() != NULL))
            LogsGroup->GetMonLog()->WriteMessageAndData("%s%s%s%s%s", inrqst_data.c_str(), inshin_data.c_str(), timingdata.c_str(), proxy_data.c_str(), rpl_data.c_str());
    }
}

void TMonObj::Midnight() {
    Clear();
}
