#pragma once

#include "tlogsgroup.h"
#include "tshinglestorage.h"
#include "tproxyclientspool.h"
#include "trplclientspool.h"
#include "tsimplestorage.h"

class TMonObj {
private:
    TLogsGroup* LogsGroup;
    TShingleStorageMain* ShinglesStorage;
    TProxyPool* PoolProxy;
    TRPLMain* PoolRPL;
    time_t lastwritedata;

    ui64 new_in_rqst_last;
    ui64 new_lost_rqst_last;
    ui64 old_in_rqst_last;
    ui64 old_lost_rqst_last;
    ui64 rpl_in_rqst_last;
    ui64 rpl_lost_rqst_last;
    ui64 prx_in_rqst_last;
    ui64 prx_lost_rqst_last;
    ui64 in_shget_count_last_old;
    ui64 in_shput_count_last_old;
    ui64 in_stget_count_last_old;
    ui64 in_shget_count_last_new;
    ui64 in_shput_count_last_new;
    ui64 in_stget_count_last_new;
    ui64 in_rpl_count_last;
    ui64 in_prxget_count_last;
    ui64 in_prxput_count_last;

    TProxyStatDataItem proxystat_last;
    ui64 proxy_forbid_last;

    TRPLStatDataItem rpl_stat_direct_last[MAX_DIRECTS_COUNT];

    void Clear();

public:
    TMonObj();
    ~TMonObj();

    void Init(TLogsGroup* LogsGroupA, TShingleStorageMain* ShinglesStorageA, TProxyPool* PoolProxyA, TRPLMain* PoolRPLA);
    void WriteMonData();
    void Midnight();
};
