#include <mail/so/spamstop/tools/so-common/limited_output.h>
#include <util/stream/mem.h>
#include "tproxyclientspool.h"
#include "tshinglestorage.h"
#include "tgeneralobject.h"

//*******************************************************************************************************************************************
//                                                               TProxyQueue
//*******************************************************************************************************************************************

TProxyQueue::TProxyQueue() {
    LogsGroup = NULL;
    today_in.Swap(0);
    today_out.Swap(0);
    today_in_rqst.Swap(0);
    today_out_rqst.Swap(0);
    today_lost.Swap(0);
    yesterday_in = 0;
    yesterday_out = 0;
    yesterday_in_rqst = 0;
    yesterday_out_rqst = 0;
    yesterday_lost = 0;
    m_Sema = NULL;
    m_stop_event = false;
    thread_count = 1;
    procent_queue_full = 0;
}

TProxyQueue::~TProxyQueue() {
    if (m_Sema != NULL) {
        delete m_Sema;
        m_Sema = NULL;
    }
}

void TProxyQueue::Init(TLogsGroup* LogsGroupA, int thread_countA) {
    LogsGroup = LogsGroupA;
    thread_count = thread_countA;
    if (m_Sema == NULL)
        m_Sema = new TUnnamedSemaphore(thread_count);
}

/*
bool TProxyQueue::AddRecord(TShinglePutDataList &shinglelist, int thread_index)
{
   bool                    res       = true;
   TShinglePutDataListIt   sit;

   t0 = CShingleTime::GetMs();
   if (shinglelist.size() > 0)
   {
      today_in_rqst.Increment();

      m_Mutex.Acquire();

      sit = shinglelist.begin();
      while (sit != shinglelist.end())
      {
         if (queuedata.size() < MAX_QUEUE_SIZE)
         {
            queuedata.push_back((*sit));
            today_in.Increment();
         } else
         {
            today_lost.Increment();
         }

         ++sit;
      }

      m_Mutex.Release();

      SendEvent();
   }

   return res;
}

bool TProxyQueue::GetRecord(TShinglePutDataList &shinglelist, int thread_index)
{
   bool                    res   = false;
   int                     count = 0;
   TShinglePutDataListIt   sit;

   shinglelist.clear();
   WaitEvent();

   m_Mutex.Acquire();

   sit = queuedata.begin();
   while (sit != queuedata.end())
   {
      shinglelist.push_back((*sit));
      queuedata.erase(sit++);
      today_out.Increment();

      if (shinglelist.size() >= MAX_SHINGLES_IN_REQUEST)
         break;
   }

   m_Mutex.Release();

   if (shinglelist.size() > 0)
   {
      res = true;
      today_out_rqst.Increment();
   }

   return res;
}
*/

bool TProxyQueue::AddRecord(TShinglePutDataList& shinglelist, int thread_index) {
    bool res = true;
    TShinglePutDataListIt sit;
    ui32 t0 = 0, t1 = 0, t2 = 0, t3 = 0, t4 = 0;
    float procent_queue_full_l = 0;
    int try_mode = 0;

    t0 = CShingleTime::GetMs();
    if (shinglelist.size() > 0) {
        today_in_rqst.Increment();

        t4 = shinglelist.size();

        if (procent_queue_full >= 85) {
            t1 = CShingleTime::GetMs();
            if (m_Mutex.TryAcquire()) {
                try_mode = 1;

                t1 = CShingleTime::GetMs() - t1;

                t2 = CShingleTime::GetMs();
                sit = shinglelist.begin();
                while (sit != shinglelist.end()) {
                    if (queuedata.size() < MAX_QUEUE_SIZE) {
                        queuedata.push_back((*sit));
                        today_in.Increment();
                    } else {
                        today_lost.Increment();
                    }

                    ++sit;
                }
                t2 = CShingleTime::GetMs() - t2;

                procent_queue_full = (float)queuedata.size() / (float)MAX_QUEUE_SIZE * (float)100;
                procent_queue_full_l = procent_queue_full;

                m_Mutex.Release();

                t3 = CShingleTime::GetMs();
                SendEvent();
                t3 = CShingleTime::GetMs() - t3;

            } else {
                try_mode = 2;

                t1 = CShingleTime::GetMs() - t1;

                if (shinglelist.size() > 0) {
                    for (int i = 0; i < shinglelist.size(); i++)
                        today_lost.Increment();
                }
                procent_queue_full_l = procent_queue_full;
            }

        } else {
            try_mode = 3;

            t1 = CShingleTime::GetMs();
            m_Mutex.Acquire();
            t1 = CShingleTime::GetMs() - t1;

            t2 = CShingleTime::GetMs();
            sit = shinglelist.begin();
            while (sit != shinglelist.end()) {
                if (queuedata.size() < MAX_QUEUE_SIZE) {
                    queuedata.push_back((*sit));
                    today_in.Increment();
                } else {
                    today_lost.Increment();
                }

                ++sit;
            }
            t2 = CShingleTime::GetMs() - t2;

            procent_queue_full = (float)queuedata.size() / (float)MAX_QUEUE_SIZE * (float)100;
            procent_queue_full_l = procent_queue_full;

            m_Mutex.Release();

            t3 = CShingleTime::GetMs();
            SendEvent();
            t3 = CShingleTime::GetMs() - t3;
        }
    }
    t0 = CShingleTime::GetMs() - t0;
    //if ( (t0 > 1) || (try_mode) )
    if (true) {
        if ((LogsGroup != NULL) && (LogsGroup->GetSendAnswerLog() != NULL)) {
            switch (try_mode) {
                case 1:
                    LogsGroup->GetSendAnswerLog()->WriteMessageAndData("1*ADDREC_%02d % 5u: t1=%u, t2=%u, t3=%u, t4=%u, PQF=%5.1f", thread_index, t0, t1, t2, t3, t4, procent_queue_full_l);
                    break;
                case 2:
                    LogsGroup->GetSendAnswerLog()->WriteMessageAndData("2*ADDREC_%02d % 5u: t1=%u, t2=%u, t3=%u, t4=%u, PQF=%5.1f", thread_index, t0, t1, t2, t3, t4, procent_queue_full_l);
                    break;
                case 3:
                    LogsGroup->GetSendAnswerLog()->WriteMessageAndData("ADDREC_%02d % 5u: t1=%u, t2=%u, t3=%u, t4=%u, PQF=%5.1f", thread_index, t0, t1, t2, t3, t4, procent_queue_full_l);
                    break;
                default:
                    LogsGroup->GetSendAnswerLog()->WriteMessageAndData("???ADDREC_%02d % 5u: t1=%u, t2=%u, t3=%u, t4=%u, PQF=%5.1f", thread_index, t0, t1, t2, t3, t4, procent_queue_full_l);
            };
        }
    }

    return res;
}

bool TProxyQueue::GetRecord(TShinglePutDataList& shinglelist, int thread_index) {
    bool res = false;
    TShinglePutDataListIt sit;
    ui32 t0 = 0, t1 = 0, t2 = 0, t3 = 0, t4 = 0;
    float procent_queue_full_l = 0;

    shinglelist.clear();
    WaitEvent();

    t0 = CShingleTime::GetMs();

    t1 = CShingleTime::GetMs();
    m_Mutex.Acquire();
    t1 = CShingleTime::GetMs() - t1;

    t2 = CShingleTime::GetMs();
    t3 = CShingleTime::GetMs();
    sit = queuedata.begin();
    t3 = CShingleTime::GetMs() - t3;
    while (sit != queuedata.end()) {
        shinglelist.push_back((*sit));
        queuedata.erase(sit++);
        today_out.Increment();

        if (shinglelist.size() >= MAX_SHINGLES_IN_REQUEST)
            break;
    }
    t2 = CShingleTime::GetMs() - t2;

    procent_queue_full = (float)queuedata.size() / (float)MAX_QUEUE_SIZE * (float)100;
    procent_queue_full_l = procent_queue_full;

    m_Mutex.Release();

    if (shinglelist.size() > 0) {
        t4 = shinglelist.size();
        res = true;
        today_out_rqst.Increment();
    }

    t0 = CShingleTime::GetMs() - t0;
    //if (t0 > 1)
    if (true) {
        if ((LogsGroup != NULL) && (LogsGroup->GetSendAnswerLog() != NULL))
            LogsGroup->GetSendAnswerLog()->WriteMessageAndData("GETREC_%02d % 5u: t1=%u, t2=%u, t3=%u, t4=%u, PQF=%5.1f", thread_index, t0, t1, t2, t3, t4, procent_queue_full_l);
    }

    return res;
}

/*
bool TProxyQueue::AddRecord(TShinglePutDataList &shinglelist)
{
   bool                    res       = true;
   TShinglePutDataListIt   sit;
   int                     add_count = 0;
   ui32                    t0 = 0, t1 = 0, t2 = 0, t3 = 0, t4 = 0;
   ui32                    tt = 0;

   t0 = CShingleTime::GetMs();
   if (shinglelist.size() > 0)
   {
      today_in_rqst.Increment();

      sit = shinglelist.begin();
      while (sit != shinglelist.end())
      {
         tt = CShingleTime::GetMs();
         m_Mutex.Acquire();
         tt = CShingleTime::GetMs() - tt;
         t1 += tt;
         t2++;
         if (queuedata.size() < MAX_QUEUE_SIZE)
         {
            tt = CShingleTime::GetMs();
            queuedata.push_back((*sit));
            today_in.Increment();
            add_count++;
            tt = CShingleTime::GetMs() - tt;

            t3 += tt;
            t4++;

            m_Mutex.Release();

         } else
         {
            m_Mutex.Release();
            today_lost.Increment();
         }

         ++sit;
      }

      if (add_count > 0)
         SendEvent();
   }
   t0 = CShingleTime::GetMs() - t0;
   if (t0 > 1)
   {
      if ( (LogsGroup != NULL) && (LogsGroup->GetSendAnswerLog() != NULL) )
         LogsGroup->GetSendAnswerLog()->WriteMessage("ADDREC % 5u: mt=%u, mc=%u, qt=%u, qc=%u\n", t0, t1, t2, t3, t4);
   }

   return res;
}

bool TProxyQueue::GetRecord(TShinglePutDataList &shinglelist)
{
   bool                    res   = false;
   int                     count = 0;
   TShinglePutDataListIt   sit;
   bool                    empty = false;
   ui32                    t0 = 0, t1 = 0, t2 = 0, t3 = 0, t4 = 0, t5 = 0, t6 = 0;
   ui32                    tt = 0;

   shinglelist.clear();
   WaitEvent();

   t0 = CShingleTime::GetMs();

   while (true)
   {
      empty = false;

      tt = CShingleTime::GetMs();
      m_Mutex.Acquire();
      tt = CShingleTime::GetMs() - tt;
      t1 += tt;
      t2++;

      if (queuedata.size() > 0)
      {
         tt = CShingleTime::GetMs();
         sit = queuedata.begin();
         tt = CShingleTime::GetMs() - tt;
         t3 += tt;
         t4++;
         if (sit != queuedata.end())
         {
            shinglelist.push_back((*sit));

            tt = CShingleTime::GetMs();
            queuedata.erase(sit);
            tt = CShingleTime::GetMs() - tt;
            t5 += tt;
            t6++;

            today_out.Increment();

         } else
            empty = true;
      } else
         empty = true;

      m_Mutex.Release();

      if (empty)
         break;

      if (shinglelist.size() >= MAX_SHINGLES_IN_REQUEST)
         break;
   }

   if (shinglelist.size() > 0)
   {
      res = true;
      today_out_rqst.Increment();
   }

   t0 = CShingleTime::GetMs() - t0;
   if (t0 > 1)
   {
      if ( (LogsGroup != NULL) && (LogsGroup->GetSendAnswerLog() != NULL) )
         LogsGroup->GetSendAnswerLog()->WriteMessage("GETREC % 5u: mt=%u, mc=%u, bt=%u, bc=%u, et=%u, ec=%u\n", t0, t1, t2, t3, t4, t5, t6);
   }

   return res;
}
*/

void TProxyQueue::Midnight() {
    MidnightMutex.Acquire();

    yesterday_in = today_in.Value();
    yesterday_out = today_out.Value();
    yesterday_lost = today_lost.Value();
    yesterday_in_rqst = today_in_rqst.Value();
    yesterday_out_rqst = today_out_rqst.Value();
    today_in.Swap(0);
    today_out.Swap(0);
    today_lost.Swap(0);
    today_in_rqst.Swap(0);
    today_out_rqst.Swap(0);

    MidnightMutex.Release();
}

ui32 TProxyQueue::GetTodayCount() {
    ui32 res = 0;

    m_Mutex.Acquire();

    res = queuedata.size();

    m_Mutex.Release();

    return res;
}

void TProxyQueue::SendEvent() {
    if (m_Sema != NULL)
        m_Sema->Release();
}

void TProxyQueue::WaitEvent() {
    if (m_Sema != NULL) {
        if (!m_stop_event)
            m_Sema->Acquire();
    }
}

void TProxyQueue::UnBlockAllEvent(int thread_count) {
    m_stop_event = true;
    if (thread_count > 0) {
        for (int i = 0; i < thread_count; i++)
            SendEvent();
    } else
        SendEvent();
}

void TProxyQueue::Shutdown() {
    UnBlockAllEvent(thread_count);
}

//*******************************************************************************************************************************************
//                                                             TProxyPoolThreads
//*******************************************************************************************************************************************

TProxyPoolThreads::TProxyPoolThreads() {
    rcv_buffer = NULL;
    LogsGroup = NULL;
    m_server_id = "";
    m_host = "";
    m_port = 0;
    m_fullhost = "";
    m_url = "";
    m_action = "";
    m_GeneralObject = NULL;
}

TProxyPoolThreads::~TProxyPoolThreads() {
    if (rcv_buffer != NULL) {
        delete[] rcv_buffer;
        rcv_buffer = NULL;
    }
}

void TProxyPoolThreads::Init(const TString& server_id, TGeneralObject* GeneralObjectA, TString& host, ui16 port, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec, TLogsGroup* LogsGroupA) {
    m_server_id = server_id;
    m_GeneralObject = GeneralObjectA;
    LogsGroup = LogsGroupA;
    rcv_buffer = new char[RCV_BUFFER_SIZE];
    SetHostData(host, port, ConnectTimeOutMSec, GetTimeOutMSec);
}

void TProxyPoolThreads::SetHostData(TString& host, ui16 port, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec) {
    m_HostDataMutex.Acquire();

    TKWStroka ws;

    m_fullhost = host;
    ws = GetHost(m_fullhost);
    m_host = ws.host;
    m_ConnectTimeOut = TDuration::MilliSeconds(ConnectTimeOutMSec);
    m_GetTimeOut = TDuration::MilliSeconds(GetTimeOutMSec);
    m_url = ws.url;
    m_action = ws.action;
    m_port = port;

    m_HostDataMutex.Release();
}

TKWStroka TProxyPoolThreads::GetHost(const TString& host){
    TKWStroka res;
    TString http_s1 = "http://";
    TString http_s2 = "HTTP://";
    const char* p = NULL;
    const char* ps = NULL;

    p = strstr(host.c_str(), http_s1.c_str());
    if (p == NULL) {
        p = strstr(host.c_str(), http_s2.c_str());
        if (p == NULL)
            p = host.c_str();
        else
            p = p + http_s2.length();
    } else
        p = p + http_s1.length();
    if (p != NULL) {
        ps = strstr(p, "/");
        if (ps != NULL) {
            res.host = TString(p, ps - p);
            if ((ps + 1) != NULL) {
                res.url = TString(ps + 1);
                res.action = res.url;
                if (!res.action.empty()) {
                    p = strchr(res.action.c_str(), '/');
                    if (p == NULL)
                        p = strchr(res.action.c_str(), '\\');
                    if (p != NULL)
                        res.action = TString(p + 1);
                }
            }
        } else {
            res.host = TString(p);
            res.url = "";
        }
    }

    return res;
}

TString ModifyResponce(const TString& s) {
    TString res = "";
    char* buff = NULL;
    int buffsize = 0;

    buffsize = s.length();
    if (buffsize > 0) {
        buff = new char[buffsize + 1];
        if (buff != NULL) {
            memcpy(buff, s.c_str(), buffsize);
            buff[buffsize] = 0x00;
            for (int k = 0; k < buffsize; k++) {
                if (buff[k] < ' ')  // убираем переносы строк, что записать в одну строку в лог
                    buff[k] = '.';
            }
            res = TString(buff);

            delete[] buff;
            buff = NULL;
        }
    }

    return res;
};

void TProxyPoolThreads::GetRequestToRemoteServer(TShinglePutDataList& shinglelist, TPrintBuff& PBUFF) {
    if (!m_host.empty() && (m_port != 0)) {
        m_statdata.today.IncAllMailCount();

        if (rcv_buffer != NULL) {
            m_HostDataMutex.Acquire();

            bool m_Result;
            ui32 BeginProcessTime = 0;
            ui16 m_HttpStatus = 0;
            TString request_url = "";
            TString full_request_url = "";
            TString txt = "";
            int err = 0;
            TString printshlist = "";
            TString responce = "";
            TString server_id = "";
            TString request_id = "";
            TShingleStatList shingle_list;

            memset(rcv_buffer, 0, RCV_BUFFER_SIZE);
            request_url = GetRequest(shinglelist);
            full_request_url = m_host + ":" + IntToStroka(m_port) + "/" + request_url;

            BeginProcessTime = CShingleTime::GetMs();


            TMemoryOutput writer(rcv_buffer, RCV_BUFFER_SIZE);
            TLimitedOutput<TLimitedOutputOverflowPolicy::Silent>  limitedOutput(writer, RCV_BUFFER_SIZE-1);

            {
                NCurl::TRequestContext requestContext;
                requestContext.SetHost(full_request_url);
                requestContext.SetPort(m_port);
                requestContext.SetRequestTimeout(m_GetTimeOut);
                requestContext.SetConnectTimeout(m_ConnectTimeOut);

                NCurl::TSimpleArtifacts artifacts;
                try{
                    curl.Setup(std::move(requestContext));
                    curl.Perform(artifacts);
                    m_Result = true;
                    m_HttpStatus = artifacts.code;
                } catch (...) {
                    m_Result = false;
                }
            }

            BeginProcessTime = CShingleTime::GetMs() - BeginProcessTime;

            if (true == m_Result) {
                if (200 == m_HttpStatus) {
                    m_statdata.today.IncRequest200Count();
                    responce = TString(rcv_buffer);

                    server_id = NShingleStatParser::GetServerIDFromHeaders(responce);
                    request_id = NShingleStatParser::GetRequestIDFromHeaders(responce);

                    if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                        PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PROXYCLIENT: MESS! %u Request to server: OK (HttpStatus:200) - request='%s', responce(SrvID:%s,RqstID:%s)='%s'\n", BeginProcessTime, full_request_url.c_str(), server_id.c_str(), request_id.c_str(), ModifyResponce(responce).c_str());

                    if (server_id != m_server_id) {
                        if (NShingleStatParser::ParseShinglesData(responce, shingle_list)) {
                            TString restext = "";
                            TShingleStatListIt it;

                            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                                PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "SrvID='%s', RqstID='%s', Parse shingles OK (count=%d)", server_id.c_str(), request_id.c_str(), shingle_list.size());

                            if ((m_GeneralObject != NULL) && (m_GeneralObject->ShinglesStorage != NULL))
                                m_GeneralObject->ShinglesStorage->ProxySetShingles("proxypool", shingle_list);

                            it = shingle_list.begin();
                            while (it != shingle_list.end()) {
                                restext = restext + (*it).GetFullAnswer() + "\n";

                                ++it;
                            }

                            if ((LogsGroup != NULL) && (LogsGroup->GetDebugMode()) && (LogsGroup->GetTestLog() != NULL))
                                LogsGroup->GetTestLog()->WriteMessageAndData("******** SrvID='%s' RqstID='%s' ********\n%s\n", server_id.c_str(), request_id.c_str(), restext.c_str());
                        } else {
                            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                                PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "SrvID='%s', RqstID='%s', Parse shingles FAILED (count=%d)", server_id.c_str(), request_id.c_str(), shingle_list.size());
                        }
                    } else {
                        m_statdata.cycle_itself = true;
                        if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                            PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "SrvID='%s', RqstID='%s', No parse shingles - cycle ITSELF", server_id.c_str(), request_id.c_str());
                    }

                } else if ((400 <= m_HttpStatus) && (m_HttpStatus < 500)) {
                    responce = TString(rcv_buffer);
                    server_id = NShingleStatParser::GetServerIDFromHeaders(responce);
                    request_id = NShingleStatParser::GetRequestIDFromHeaders(responce);

                    if (m_HttpStatus == 404)
                        m_statdata.today.IncRequest404Count();
                    else
                        m_statdata.today.IncRequest400500Count();
                    if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                        PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PROXYCLIENT: ERR! %u Request to server: HttpStatus:%u - request='%s', responce(SrvID:%s,RqstID:%s)='%s'\n", BeginProcessTime, m_HttpStatus, full_request_url.c_str(), server_id.c_str(), request_id.c_str(), ModifyResponce(responce).c_str());
                } else {
                    m_statdata.today.IncRequestOtherCount();
                    if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                        PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PROXYCLIENT: ERR! %u Request to server: HttpStatus:%u - request='%s'\n", BeginProcessTime, m_HttpStatus, full_request_url.c_str());
                }
            } else {
                if (false == m_Result) {
                    m_statdata.today.IncRequestError();
                    if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                        PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PROXYCLIENT: ERR! %u Request to server: request error (%d) - '%s'\n", BeginProcessTime, err, full_request_url.c_str());
                } else if (false == m_Result) {
                    m_statdata.today.IncRequestTimeout();
                    if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                        PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PROXYCLIENT: ERR! %u Request to server: request timeout - '%s'\n", BeginProcessTime, full_request_url.c_str());
                } else if (false == m_Result) {
                    m_statdata.today.IncRequsetBufferOverflow();
                    if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                        PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PROXYCLIENT: ERR! %u Request to server: request buffer overflow - '%s'\n", BeginProcessTime, full_request_url.c_str());
                }
            }

            m_HostDataMutex.Release();
        }
    } else {
        if (m_host.empty()) {
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PROXYCLIENT: ERR! no defined host\n");
        } else if (m_port == 0) {
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PROXYCLIENT: ERR! no defined port\n");
        }
    }
}

TString TProxyPoolThreads::GetRequest(TShinglePutDataList& shinglelist) {
    TString res = "";
    TShinglePutDataListIt it;
    TString put_text = "";
    TString get_text = "";
    THashMap<TString, bool> sthash;
    THashMap<TString, bool>::iterator stit;
    char tbuff[25];
    TString pairshtype = "";

    if ((!m_url.empty()) && (shinglelist.size() > 0)) {
        res = m_url;
        if ((res[res.length() - 1] != '/') && (res[res.length() - 1] != '?'))
            res = res + "?";

        // формируем put-составляющую запроса
        put_text = "";
        it = shinglelist.begin();
        while (it != shinglelist.end()) {
            if ((*it).m_is_put) {
                put_text = put_text + (*it).GetRequest();

                snprintf(tbuff, sizeof(tbuff) - 1, "%016" PRIx64 "-%03d", (*it).m_shingle, (*it).m_type);
                pairshtype = TString(tbuff);

                stit = sthash.find(pairshtype);
                if (stit == sthash.end())
                    sthash.insert(THashMap<TString, bool>::value_type(pairshtype, true));
            }

            ++it;
        }
        // формируем get-составляющую запроса (если шингл с таким типом есть в put, то не добавляем в запрос;
        // если шингл с таким типом уже добавлен в get - второй раз не добавляем)
        get_text = "";
        it = shinglelist.begin();
        while (it != shinglelist.end()) {
            if (!(*it).m_is_put) {
                snprintf(tbuff, sizeof(tbuff) - 1, "%016" PRIx64 "-%03d", (*it).m_shingle, (*it).m_type);
                pairshtype = TString(tbuff);

                stit = sthash.find(pairshtype);
                if (stit == sthash.end()) {
                    sthash.insert(THashMap<TString, bool>::value_type(pairshtype, false));

                    get_text = get_text + (*it).GetRequest();
                }
            }

            ++it;
        }

        if (!put_text.empty())
            res = res + "shprxput=" + put_text;
        if (!get_text.empty())
            res = res + "shprxget=" + get_text;
    }

    return res;
}

TProxyStatData TProxyPoolThreads::GetStat() {
    return m_statdata;
}

TString TProxyPoolThreads::GetExampleRequest() {
    TString res = "";
    time_t currenttime = time(NULL);
    TString emptytext = "firstrequest";
    TString rnumb = "##1234567";
    TShinglePutDataList shinglelist;

    shinglelist.push_back(TShinglePutData(false, 0x00000001, 0, 0, UNKNOWN, PERSUNDEF, 0));
    shinglelist.push_back(TShinglePutData(false, 0x00000002, 0, 0, UNKNOWN, PERSUNDEF, 0));
    shinglelist.push_back(TShinglePutData(false, 0x00000003, 3, 0, UNKNOWN, PERSUNDEF, 0));
    shinglelist.push_back(TShinglePutData(false, 0x00000004, 4, 0, UNKNOWN, PERSUNDEF, 0));
    shinglelist.push_back(TShinglePutData(false, 0x00000005, 5, 0, UNKNOWN, PERSUNDEF, 0));

    res = m_host + ":" + IntToStroka(m_port) + "/" + GetRequest(shinglelist);

    return res;
}

void TProxyPoolThreads::Midnight() {
    m_statdata.Midnight();
}

bool TProxyPoolThreads::NoDefinedHostOrPort() {
    bool res = false;

    m_HostDataMutex.Acquire();

    if ((m_fullhost.empty()) || (m_port == 0))
        res = true;

    m_HostDataMutex.Release();

    return res;
}

//*******************************************************************************************************************************************
//                                                             TProxyPool
//*******************************************************************************************************************************************

void ProxyProcM(void* par) {
    int thread_index = -1;
    TProxyPool* ss = (TProxyPool*)par;
    int n = 0;
    TPrintBuff PBUFF;

    if (ss != NULL) {
        thread_index = ss->IncrementThreadCount();
        ss->WriteThreadIDToLog(thread_index);

        while (!ss->IsShouldStopThreads()) {
            ss->ObrabRequest(thread_index, PBUFF);
        }

        ss->DecrementThreadCount();
    }
}

TProxyPool::TProxyPool() {
    config = NULL;
    enable = false;
    m_real_thread_count = 0;
    m_stop_threads = false;
    thread_count = 0;

    m_host = "";
    m_port = 0;
    m_connecttimeout = 0;
    m_requesttimeout = 0;
    m_put_action_listname = "";
    m_put_action = PPA_UNKNOWN;

    m_server_id = "";
    m_GeneralObject = NULL;

    m_proxy_put_trust_list = NULL;
}

TProxyPool::~TProxyPool() {
    TProxyThreadListIt tid;
    TProxyPoolThreadsListIt iit;

    SetStopThreads();
    while (!IsStopThreads())
        usleep(1000);

    if (m_proxy_put_trust_list != NULL) {
        delete m_proxy_put_trust_list;
        m_proxy_put_trust_list = NULL;
    }

    tid = threadlist.begin();
    while (tid != threadlist.end()) {
        if ((*tid) != NULL) {
            delete (*tid);
            (*tid) = NULL;
        }

        ++tid;
    }

    iit = itemlist.begin();
    while (iit != itemlist.end()) {
        if ((*iit) != NULL) {
            delete (*iit);
            (*iit) = NULL;
        }

        ++iit;
    }
}

bool TProxyPool::InitBeforeFork(const TString& server_id, TKConfig* configA, TLogsGroup* LogsGroupA) {
    bool res = false;
    TString put_action = "";
    TString configdata = "";

    config = configA;
    LogsGroup = LogsGroupA;

    m_server_id = server_id;
    if (config != NULL) {
        enable = config->ReadBool("proxy", "enable", false);
        thread_count = config->ReadInteger("proxy", "thread_count", 0);
        m_host = config->ReadStroka("proxy", "host", "");
        m_port = config->ReadInteger("proxy", "port", 0);
        m_connecttimeout = config->ReadInteger("proxy", "connecttimeout", 0);
        m_requesttimeout = config->ReadInteger("proxy", "requesttimeout", 0);
        m_put_action_listname = config->ReadStroka("proxy", "trust_put_list", "");
        put_action = config->ReadStroka("proxy", "trust_put", "");
        if (put_action == "allowall")
            m_put_action = PPA_ALLOW_ALL;
        else if (put_action == "forbidall")
            m_put_action = PPA_FORBID_ALL;
        else if (put_action == "allowlist")
            m_put_action = PPA_ALLOW_LIST;
        else
            m_put_action = PPA_UNKNOWN;

        res = true;
    }

    if (thread_count > MAX_THREAD_COUNT)
        thread_count = MAX_THREAD_COUNT;
    if (thread_count < 2)
        thread_count = 2;

    configdata = configdata + "PROXYCLIENT: init with following data\n";
    configdata = configdata + "PROXYCLIENT: enable=" + BoolToStroka2(enable) + "\n";
    configdata = configdata + "PROXYCLIENT: thread_count=" + IntToStroka(thread_count) + "\n";
    configdata = configdata + "PROXYCLIENT: host='" + m_host + "'\n";
    configdata = configdata + "PROXYCLIENT: port=" + IntToStroka(m_port) + "\n";
    configdata = configdata + "PROXYCLIENT: connecttimeout=" + IntToStroka(m_connecttimeout) + "\n";
    configdata = configdata + "PROXYCLIENT: requesttimeout=" + IntToStroka(m_requesttimeout) + "\n";
    configdata = configdata + "PROXYCLIENT: trust_put_list='" + m_put_action_listname + "'\n";
    switch (m_put_action) {
        case PPA_ALLOW_ALL:
            configdata = configdata + "PROXYCLIENT: trust_put=PPA_ALLOW_ALL\n";
            break;
        case PPA_FORBID_ALL:
            configdata = configdata + "PROXYCLIENT: trust_put=PPA_FORBID_ALL\n";
            break;
        case PPA_ALLOW_LIST:
            configdata = configdata + "PROXYCLIENT: trust_put=PPA_ALLOW_LIST\n";
            break;
        default:
            configdata = configdata + "PROXYCLIENT: trust_put=PPA_UNKNOWN\n";
    };
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", configdata.c_str());

    if (!m_put_action_listname.empty()) {
        m_proxy_put_trust_list = new TNetKIPv6("PUTTRUSTLIST");
        if (m_proxy_put_trust_list != NULL) {
            TLogClass* lc = NULL;

            if (LogsGroup != NULL)
                lc = LogsGroup->GetProxyLog();

            m_proxy_put_trust_list->Init(m_put_action_listname, lc);
            m_proxy_put_trust_list->ReloadFileList();
        }
    }

    queue.Init(LogsGroup, thread_count);

    return res;
}

bool TProxyPool::InitAfterFork(TGeneralObject* GeneralObjectA) {
    bool res = true;
    TProxyPoolThreads* pritem = NULL;
    TThread* prthread = NULL;

    m_GeneralObject = GeneralObjectA;
    ResetStopThreads();
    if (enable) {
        for (int i = 0; i < thread_count; i++) {
            pritem = new TProxyPoolThreads();
            if (pritem != NULL) {
                pritem->Init(m_server_id, m_GeneralObject, m_host, m_port, m_connecttimeout, m_requesttimeout, LogsGroup);
                itemlist.push_back(pritem);

                prthread = new TThread((TThread::TThreadProc)&ProxyProcM, this);
                if (prthread != NULL) {
                    prthread->Start();
                    threadlist.push_back(prthread);
                }
            }
        }
    }

    return res;
}

void TProxyPool::AddRequest(TShinglePutDataList& shinglelist, const TString& abonent_ip, int thread_index) {
    if ((enable) && (shinglelist.size() > 0)) {
        TKIPv6 ip = TKIPv6(abonent_ip.c_str());

        switch (m_put_action) {
            case PPA_ALLOW_ALL:
                queue.AddRecord(shinglelist, thread_index);
                break;
            case PPA_FORBID_ALL:
                forbid_request.AddRequest();
                break;
            case PPA_ALLOW_LIST:
                if (m_proxy_put_trust_list != NULL) {
                    if ((!ip.Undefined()) && (m_proxy_put_trust_list->IsInNet(ip)))
                        queue.AddRecord(shinglelist, thread_index);
                    else
                        forbid_request.AddRequest();
                } else
                    forbid_request.AddRequest();
                break;
            default:
                forbid_request.AddRequest();
        };
    }
}

bool TProxyPool::ObrabRequest(int index, TPrintBuff& PBUFF) {
    bool res = true;

    if ((index >= 0) && (index < m_real_thread_count)) {
        ui64 shingle = 0;
        TShinglePutDataList shinglelist;

        shinglelist.clear();
        if (!queue.GetRecord(shinglelist, index)) {
            res = false;
        } else {
            PBUFF.Clear();

            // if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
            //    PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "*****%s*****\n", rnumb.c_str());
            if (itemlist[index] != NULL)
                itemlist[index]->GetRequestToRemoteServer(shinglelist, PBUFF);
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "\n");

            if ((LogsGroup != NULL) && (LogsGroup->GetDebugMode()) && (LogsGroup->GetProxyLog() != NULL))
                LogsGroup->GetProxyLog()->WriteMessageAndDataBUFF(PBUFF.printbuff, PBUFF.in_printbuff);
        }
    }

    return res;
}

void TProxyPool::Midnight() {
    TProxyPoolThreadsListIt it;

    it = itemlist.begin();
    while (it != itemlist.end()) {
        if ((*it) != NULL)
            (*it)->Midnight();

        ++it;
    }

    queue.Midnight();
    forbid_request.Midnight();
}

TProxyStatData TProxyPool::GetStat() {
    TProxyStatData res, tres;
    TProxyPoolThreadsListIt it;

    it = itemlist.begin();
    while (it != itemlist.end()) {
        if ((*it) != NULL) {
            tres = (*it)->GetStat();
            res += tres;
            if (tres.cycle_itself)
                res.cycle_itself = true;
        }

        ++it;
    }

    res.enable_client = enable;
    res.threads = m_real_thread_count;
    res.today.queue_in = queue.GetTodayIN();
    res.today.queue_count = queue.GetTodayCount();
    res.today.queue_lost = queue.GetTodayLost();
    res.today.queue_out = queue.GetTodayOUT();
    res.today.queue_in_rqst = queue.GetTodayINRqst();
    res.today.queue_out_rqst = queue.GetTodayOUTRqst();

    res.yesterday.queue_in = queue.GetYesterdayIN();
    res.yesterday.queue_count = 0;
    res.yesterday.queue_lost = queue.GetYesterdayLost();
    res.yesterday.queue_out = queue.GetYesterdayOUT();
    res.yesterday.queue_in_rqst = queue.GetYesterdayINRqst();
    res.yesterday.queue_out_rqst = queue.GetYesterdayOUTRqst();

    res.proxy_put_forbid_today = forbid_request.GetTodayRequest();
    res.proxy_put_forbid_yesterday = forbid_request.GetYesterdayRequest();

    switch (m_put_action) {
        case PPA_ALLOW_ALL:
            res.put_action = "ALLOW_ALL";
            break;
        case PPA_FORBID_ALL:
            res.put_action = "FORBID_ALL";
            break;
        case PPA_ALLOW_LIST:
            res.put_action = "ALLOW_LIST";
            break;
        default:
            res.put_action = "UNKNOWN";
    };

    return res;
}

int TProxyPool::IncrementThreadCount() {
    int res = 0;

    m_MutexThreads.Acquire();

    m_real_thread_count++;
    if ((m_real_thread_count - 1) >= 0)
        res = m_real_thread_count - 1;

    m_MutexThreads.Release();

    return res;
}

void TProxyPool::DecrementThreadCount() {
    m_MutexThreads.Acquire();

    if (m_real_thread_count > 0)
        m_real_thread_count--;

    m_MutexThreads.Release();
}

void TProxyPool::ResetStopThreads() {
    m_MutexThreads.Acquire();

    m_stop_threads = false;

    m_MutexThreads.Release();
}

void TProxyPool::SetStopThreads() {
    m_MutexThreads.Acquire();

    m_stop_threads = true;

    m_MutexThreads.Release();
}

bool TProxyPool::IsShouldStopThreads() {
    return m_stop_threads;
}

bool TProxyPool::IsStopThreads() {
    bool res = false;

    if (m_real_thread_count <= 0)
        res = true;

    return res;
}

int TProxyPool::ReadThreadsCount() {
    return m_real_thread_count;
}

TString TProxyPool::GetExampleRequest() {
    TString res = "";

    if ((itemlist.size() > 0) && (itemlist[0] != NULL))
        res = itemlist[0]->GetExampleRequest();
    else
        res = "no item";

    return res;
}

void TProxyPool::Shutdown() {
    queue.Shutdown();
}

void TProxyPool::EventTick() {
    forbid_request.CalcCPS();
}

void TProxyPool::WriteThreadIDToLog(int thread_index) {
    int thread_id = -1;

#ifndef _win_
    thread_id = syscall(SYS_gettid);
#endif

    if ((LogsGroup != NULL) && (LogsGroup->GetDebugInfoLog() != NULL))
        LogsGroup->GetDebugInfoLog()->WriteMessageAndDataStatus(KMESSAGE, "THREADID % 9d: PROXY THREAD_INDEX_%02d", thread_id, thread_index);
}

//*******************************************************************************************************************************************
