#pragma once

#include "util/generic/string.h"
#include "util/generic/hash.h"
#include <library/cpp/cgiparam/cgiparam.h>
#include <mail/so/spamstop/tools/so-common/shconn.h>
#include <mail/so/spamstop/tools/so-clients/tshinglerenv.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/unnamedsem.h>
#include <mail/so/spamstop/tools/so-common/tkipv6classes.h>
#include <list>
#include <vector>
#include "tlogsgroup.h"
#include "tshinglesclasses.h"
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include <mail/so/libs/curl/curl.h>
#include <util/system/thread.h>

//*******************************************************************************************************************************************
//                                                               TProxyQueue
//*******************************************************************************************************************************************

struct TShinglePutData {
    bool m_is_put;
    ui64 m_shingle;
    ui16 m_type;    // если m_type <0xFFFF, то это данные по шинглам, если ==0xFFFF, то по стораджу
    ui16 m_count;
    TShingleSpamType m_spamtype;
    TPersType m_pers;
    ui64 m_att_shingle;

    TShinglePutData() {
        Clear();
    }

    TShinglePutData(bool is_put, ui64 shingle, ui16 type, ui16 count, TShingleSpamType spamtype, TPersType pers, ui64 att_shingle)  // конструктор для передачи шинглов
    {
        m_is_put = is_put;
        m_shingle = shingle;
        m_type = type;
        m_count = count;
        m_spamtype = spamtype;
        m_pers = pers;
        m_att_shingle = att_shingle;
    }

    TShinglePutData(ui64 shingle)   // конструктор для передачи стораджа
    {
        m_is_put = false;
        m_shingle = shingle;
        m_type = 0xFFFF;
        m_count = 0;
        m_spamtype = UNKNOWN;
        m_pers = PERSUNDEF;
        m_att_shingle = 0;
    }

    void Clear() {
        m_is_put = false;
        m_shingle = 0;
        m_type = 0;
        m_count = 0;
        m_spamtype = UNKNOWN;
        m_pers = PERSUNDEF;
        m_att_shingle = 0;
    }

    TString GetRequest() {
        TString res = "";
        char buff[512];

        buff[sizeof(buff) - 1] = 0x00;
        if (m_is_put) {
            // put - shingle-type=count-spamtype-pers,attendant_shingle&shingle-type=count-spamtype,attendant_shingle&
            if (m_att_shingle == 0)
                snprintf(buff, sizeof(buff) - 1, "%" PRIx64 "-%d=%d-%d-%d&", m_shingle, m_type, m_count, (int)m_spamtype, (int)m_pers);
            else
                snprintf(buff, sizeof(buff) - 1, "%" PRIx64 "-%d=%d-%d-%d,%" PRIx64 "&", m_shingle, m_type, m_count, (int)m_spamtype, (int)m_pers, m_att_shingle);
        } else {
            // get - shingle-type=&shingle-type=&
            snprintf(buff, sizeof(buff) - 1, "%" PRIx64 "-%d=&", m_shingle, m_type);
        }
        res = TString(buff);

        return res;
    }
};

typedef std::list<TShinglePutData> TShinglePutDataList;
typedef TShinglePutDataList::iterator TShinglePutDataListIt;

class TProxyQueue {
private:
    static const ui16 MAX_COUNT_TYPES = MAX_COUNT_SHINGLES_TYPE;
    static const ui32 MAX_QUEUE_SIZE = 20000;
    static const int MAX_SHINGLES_IN_REQUEST = 200;

private:
    // TShingleShortInfoHash queuedata[MAX_COUNT_TYPES];
    TShinglePutDataList queuedata;
    TMutex m_Mutex;
    TUnnamedSemaphore* m_Sema;
    bool m_stop_event;
    int thread_count;
    TLogsGroup* LogsGroup;

    TKAtomic today_in;
    TKAtomic today_out;
    TKAtomic today_in_rqst;
    TKAtomic today_out_rqst;
    TKAtomic today_lost;
    ui64 yesterday_in;
    ui64 yesterday_out;
    ui64 yesterday_in_rqst;
    ui64 yesterday_out_rqst;
    ui64 yesterday_lost;
    TMutex MidnightMutex;
    float procent_queue_full;

    void SendEvent();
    void WaitEvent();
    void UnBlockAllEvent(int thread_count);

public:
    TProxyQueue();
    ~TProxyQueue();

    void Init(TLogsGroup* LogsGroupA, int thread_countA);

    bool AddRecord(TShinglePutDataList& shinglelist, int thread_index);
    bool GetRecord(TShinglePutDataList& shinglelist, int thread_index);
    void Midnight();
    void Shutdown();

    ui64 GetTodayIN() {
        return today_in.Value();
    }
    ui64 GetTodayOUT() {
        return today_out.Value();
    }
    ui64 GetTodayINRqst() {
        return today_in_rqst.Value();
    }
    ui64 GetTodayOUTRqst() {
        return today_out_rqst.Value();
    }
    ui64 GetTodayLost() {
        return today_lost.Value();
    }
    ui32 GetTodayCount();
    ui64 GetYesterdayIN() {
        return yesterday_in;
    }
    ui64 GetYesterdayOUT() {
        return yesterday_out;
    }
    ui64 GetYesterdayINRqst() {
        return yesterday_in_rqst;
    }
    ui64 GetYesterdayOUTRqst() {
        return yesterday_out_rqst;
    }
    ui64 GetYesterdayLost() {
        return yesterday_lost;
    }
};

//*******************************************************************************************************************************************
//                                                             TProxyStatDataItem
//*******************************************************************************************************************************************

struct TProxyStatDataItem {
    //�� ��������
    ui32 all_mail_count;
    ui32 excludehosts_mail_count;
    ui32 old_mail_count;
    ui32 connect_error;
    ui32 connect_timeout;
    ui32 request_200_count;
    ui32 request_404_count;
    ui32 request_400500_count;
    ui32 request_other_count;
    ui32 request_error;
    ui32 request_timeout;
    ui32 request_buffer_overflow;
    //�� �������
    ui64 queue_in;
    ui32 queue_count;
    ui64 queue_lost;
    ui64 queue_out;
    ui64 queue_in_rqst;
    ui64 queue_out_rqst;

    TProxyStatDataItem() {
        Clear();
    }

    void IncAllMailCount() {
        all_mail_count = IncMax32(all_mail_count, 1);
    }
    void IncExcludeHostsMailCount() {
        excludehosts_mail_count = IncMax32(excludehosts_mail_count, 1);
    }
    void IncOldMailCount() {
        old_mail_count = IncMax32(old_mail_count, 1);
    }
    void IncConnectError() {
        connect_error = IncMax32(connect_error, 1);
    }
    void IncConnectTimeout() {
        connect_timeout = IncMax32(connect_timeout, 1);
    }
    void IncRequest200Count() {
        request_200_count = IncMax32(request_200_count, 1);
    }
    void IncRequest404Count() {
        request_404_count = IncMax32(request_404_count, 1);
    }
    void IncRequest400500Count() {
        request_400500_count = IncMax32(request_400500_count, 1);
    }
    void IncRequestOtherCount() {
        request_other_count = IncMax32(request_other_count, 1);
    }
    void IncRequestError() {
        request_error = IncMax32(request_error, 1);
    }
    void IncRequestTimeout() {
        request_timeout = IncMax32(request_timeout, 1);
    }
    void IncRequsetBufferOverflow() {
        request_buffer_overflow = IncMax32(request_buffer_overflow, 1);
    }

    void Clear() {
        all_mail_count = 0;
        excludehosts_mail_count = 0;
        old_mail_count = 0;
        connect_error = 0;
        connect_timeout = 0;
        request_200_count = 0;
        request_404_count = 0;
        request_400500_count = 0;
        request_other_count = 0;
        request_error = 0;
        request_timeout = 0;
        request_buffer_overflow = 0;
        queue_in = 0;
        queue_count = 0;
        queue_lost = 0;
        queue_out = 0;
        queue_in_rqst = 0;
        queue_out_rqst = 0;
    }

    TProxyStatDataItem& operator+=(const TProxyStatDataItem& obj) {
        this->all_mail_count = IncMax32(this->all_mail_count, obj.all_mail_count);
        this->excludehosts_mail_count = IncMax32(this->excludehosts_mail_count, obj.excludehosts_mail_count);
        this->old_mail_count = IncMax32(this->old_mail_count, obj.old_mail_count);
        this->connect_error = IncMax32(this->connect_error, obj.connect_error);
        this->connect_timeout = IncMax32(this->connect_timeout, obj.connect_timeout);
        this->request_200_count = IncMax32(this->request_200_count, obj.request_200_count);
        this->request_404_count = IncMax32(this->request_404_count, obj.request_404_count);
        this->request_400500_count = IncMax32(this->request_400500_count, obj.request_400500_count);
        this->request_other_count = IncMax32(this->request_other_count, obj.request_other_count);
        this->request_error = IncMax32(this->request_error, obj.request_error);
        this->request_timeout = IncMax32(this->request_timeout, obj.request_timeout);
        this->request_buffer_overflow = IncMax32(this->request_buffer_overflow, obj.request_buffer_overflow);

        this->queue_in = IncMax64(this->queue_in, obj.queue_in);
        this->queue_count = IncMax32(this->queue_count, obj.queue_count);
        this->queue_lost = IncMax64(this->queue_lost, obj.queue_lost);
        this->queue_out = IncMax64(this->queue_out, obj.queue_out);
        this->queue_in_rqst = IncMax64(this->queue_in_rqst, obj.queue_in_rqst);
        this->queue_out_rqst = IncMax64(this->queue_out_rqst, obj.queue_out_rqst);

        return *this;
    }

    TProxyStatDataItem& operator-=(const TProxyStatDataItem& obj) {
        this->all_mail_count = Minus32(this->all_mail_count, obj.all_mail_count);
        this->excludehosts_mail_count = Minus32(this->excludehosts_mail_count, obj.excludehosts_mail_count);
        this->old_mail_count = Minus32(this->old_mail_count, obj.old_mail_count);
        this->connect_error = Minus32(this->connect_error, obj.connect_error);
        this->connect_timeout = Minus32(this->connect_timeout, obj.connect_timeout);
        this->request_200_count = Minus32(this->request_200_count, obj.request_200_count);
        this->request_404_count = Minus32(this->request_404_count, obj.request_404_count);
        this->request_400500_count = Minus32(this->request_400500_count, obj.request_400500_count);
        this->request_other_count = Minus32(this->request_other_count, obj.request_other_count);
        this->request_error = Minus32(this->request_error, obj.request_error);
        this->request_timeout = Minus32(this->request_timeout, obj.request_timeout);
        this->request_buffer_overflow = Minus32(this->request_buffer_overflow, obj.request_buffer_overflow);

        this->queue_in = Minus64(this->queue_in, obj.queue_in);
        this->queue_count = Minus32(this->queue_count, obj.queue_count);
        this->queue_lost = Minus64(this->queue_lost, obj.queue_lost);
        this->queue_out = Minus64(this->queue_out, obj.queue_out);
        this->queue_in_rqst = Minus64(this->queue_in_rqst, obj.queue_in_rqst);
        this->queue_out_rqst = Minus64(this->queue_out_rqst, obj.queue_out_rqst);

        return *this;
    }
};

struct TProxyStatData {
    ui16 threads;
    bool enable_client;
    TProxyStatDataItem today;
    TProxyStatDataItem yesterday;
    bool cycle_itself;
    TString put_action;
    ui64 proxy_put_forbid_today;        // отклоненные запросы к прокси
    ui64 proxy_put_forbid_yesterday;    // отклоненные запросы к прокси

    TProxyStatData() {
        threads = 0;
        enable_client = false;
        cycle_itself = false;
        put_action = "";
        proxy_put_forbid_today = 0;
        proxy_put_forbid_yesterday = 0;
    }

    void Midnight() {
        yesterday = today;
        today.Clear();
    }
    TProxyStatData& operator+=(const TProxyStatData& obj) {
        this->today += obj.today;
        this->yesterday += obj.yesterday;

        return *this;
    }

    TProxyStatData& operator-=(const TProxyStatData& obj) {
        this->today -= obj.today;
        this->yesterday -= obj.yesterday;

        return *this;
    }
};

struct TKWStroka {
    TString host;
    TString url;
    TString action;

    TKWStroka() {
        host = "";
        url = "";
        action = "";
    }
};

//*******************************************************************************************************************************************
//                                                             TProxyPoolThreads
//*******************************************************************************************************************************************

class TGeneralObject;
class TProxyPoolThreads {
private:
    static const ui32 RCV_BUFFER_SIZE = 65535;

    NCurl::TCurl curl;
    char* rcv_buffer;
    TLogsGroup* LogsGroup;
    TGeneralObject* m_GeneralObject;
    TString m_server_id;
    TMutex m_HostDataMutex;
    TString m_host;
    TString m_url;
    TDuration m_ConnectTimeOut = TDuration::MilliSeconds(100), m_GetTimeOut = TDuration::MilliSeconds(200);
    TString m_action;
    ui16 m_port;
    TString m_fullhost;
    TProxyStatData m_statdata;

    TKWStroka GetHost(const TString& host);

public:
    TProxyPoolThreads();
    ~TProxyPoolThreads();

    void Init(const TString& server_id, TGeneralObject* GeneralObjectA, TString& host, ui16 port, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec, TLogsGroup* LogsGroupA);
    void SetHostData(TString& host, ui16 port, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec);
    void GetRequestToRemoteServer(TShinglePutDataList& shinglelist, TPrintBuff& PBUFF);
    TString GetRequest(TShinglePutDataList& shinglelist);
    TProxyStatData GetStat();
    TString GetExampleRequest();
    void Midnight();
    bool NoDefinedHostOrPort();
};

//*******************************************************************************************************************************************
//                                                             TProxyPool
//*******************************************************************************************************************************************

typedef std::vector<TProxyPoolThreads*> TProxyPoolThreadsList;
typedef TProxyPoolThreadsList::iterator TProxyPoolThreadsListIt;

typedef std::vector<TThread*> TProxyThreadList;
typedef TProxyThreadList::iterator TProxyThreadListIt;

class TProxyPool {
private:
    static const ui32 MAX_THREAD_COUNT = 32;
    static const ui32 MAX_QUEUE_SIZE = 1000;
    enum TProxyPutAction { PPA_UNKNOWN,
                           PPA_ALLOW_ALL,
                           PPA_FORBID_ALL,
                           PPA_ALLOW_LIST };

private:
    TKConfig* config;
    TLogsGroup* LogsGroup;
    int thread_count;
    bool enable;    // работает прокси или нет
    TString m_server_id;
    TGeneralObject* m_GeneralObject;

    TString m_host;
    ui16 m_port;
    ui32 m_connecttimeout;
    ui32 m_requesttimeout;
    TString m_put_action_listname;
    TProxyPutAction m_put_action;

    int m_real_thread_count;
    bool m_stop_threads;
    TMutex m_MutexThreads;

    TProxyPoolThreadsList itemlist;
    TProxyThreadList threadlist;
    TProxyQueue queue;

    TNetKIPv6* m_proxy_put_trust_list;  // находятся адреса, которым можно делать put в главный шинглер
    TTrafficCounter forbid_request;

public:
    int IncrementThreadCount();     // инкрементировать кол-во работающих потоков
    void DecrementThreadCount();    // декрементировать кол-во работающих потоков
    void ResetStopThreads();        // сбросить сигнал остановки потоков
    void SetStopThreads();          // послать сигнал на остановку работы потоков
    bool IsShouldStopThreads();     // true - нужно завершить работу в потоке
    bool IsStopThreads();           // true - все потоки остановились (счетчик обнулился)
    int ReadThreadsCount();         // реальное число запущенных в работу потоков

    bool ObrabRequest(int index, TPrintBuff& PBUFF);

public:
    TProxyPool();
    ~TProxyPool();

    bool InitBeforeFork(const TString& server_id, TKConfig* configA, TLogsGroup* LogsGroupA);
    bool InitAfterFork(TGeneralObject* GeneralObjectA);
    void Midnight();
    void Shutdown();
    void EventTick();
    TProxyStatData GetStat();
    TString GetExampleRequest();
    void WriteThreadIDToLog(int thread_index);

    void AddRequest(TShinglePutDataList& shinglelist, const TString& abonent_ip, int thread_index);
};

//*******************************************************************************************************************************************
