#include <mail/so/spamstop/tools/so-common/limited_output.h>
#include <util/stream/mem.h>
#include "trplclientspool.h"

#include "tshinglestorage.h"

//*******************************************************************************************************************************************
//                                                               TRPLQueue
//*******************************************************************************************************************************************

TRPLQueue::TRPLQueue() {
    today_in.Swap(0);
    today_up.Swap(0);
    today_out.Swap(0);
    today_in_rqst.Swap(0);
    today_out_rqst.Swap(0);
    today_lost.Swap(0);
    yesterday_in = 0;
    yesterday_up = 0;
    yesterday_out = 0;
    yesterday_in_rqst = 0;
    yesterday_out_rqst = 0;
    yesterday_lost = 0;
    m_Sema = NULL;
    m_stop_event = false;
    thread_count = 1;
    m_last_return_data = 0;
    inqueue_count = 0;
    m_need_return_data_time_today = 0;
    m_need_return_data_count_today = 0;
    m_need_return_data_time_yesterday = 0;
    m_need_return_data_count_yesterday = 0;
    m_max_queue_size = MAX_QUEUE_SIZE;
    m_max_shingles_in_request = MAX_SHINGLES_IN_REQUEST;
    m_min_shingles_in_request = GETDATA_MIN_COUNT;
    m_timeout_create_sendblock = GETDATA_TIMEOUT_MS;
}

TRPLQueue::~TRPLQueue() {
    if (m_Sema != NULL) {
        delete m_Sema;
        m_Sema = NULL;
    }
}

void TRPLQueue::Init(int thread_countA, ui32 max_queue_sizeA, ui32 max_shingles_in_requestA, ui32 min_shingles_in_requestA, ui32 timeout_create_sendblockA) {
    thread_count = thread_countA;
    m_max_queue_size = max_queue_sizeA;
    m_max_shingles_in_request = max_shingles_in_requestA;
    m_min_shingles_in_request = min_shingles_in_requestA;
    m_timeout_create_sendblock = timeout_create_sendblockA;
    if (m_Sema == NULL)
        m_Sema = new TUnnamedSemaphore(thread_count);
}

bool TRPLQueue::AddRecord(TShingleExtInfoRPLList& shinglelist) {
    bool res = false;
    TShingleShortInfoRPLHashIt it;
    ui32 rec_count = 0;
    TShingleExtInfoRPLListIt sit;
    ui32 count = 0;
    TShingleExtInfoRPL seirpl_t;

    if (shinglelist.size() > 0) {
        today_in_rqst.Increment();

        count = shinglelist.size();
        sit = shinglelist.begin();
        while (sit != shinglelist.end()) {
            seirpl_t = (*sit);
            if (((*sit).type >= 0) && ((*sit).type < MAX_COUNT_TYPES)) {
                today_in.Increment();

                m_Mutex.Acquire();

                if ((*sit).value.m_att_shingle == 0) // если uniq-шингл не задан, то добавляем в очередь-хэш, чтобы иметь возможность объединять счетчики в запросе
                {
                    it = queuedata[(*sit).type].find((*sit).shingle);
                    if (it != queuedata[(*sit).type].end()) {
                        (*it).second.m_ham = IncMax16((*it).second.m_ham, (*sit).value.m_ham);
                        (*it).second.m_dlv = IncMax16((*it).second.m_dlv, (*sit).value.m_dlv);
                        (*it).second.m_spam = IncMax16((*it).second.m_spam, (*sit).value.m_spam);
                        (*it).second.m_persham = IncMax16((*it).second.m_persham, (*sit).value.m_persham);
                        (*it).second.m_persspam = IncMax16((*it).second.m_persspam, (*sit).value.m_persspam);
                        (*it).second.m_att_shingle = (*sit).value.m_att_shingle;           // неважно, т.к. сюда не попадают записи с ненулевым uniq-шинглом
                        (*it).second.m_att_shingle_type = (*sit).value.m_att_shingle_type; // неважно, т.к. сюда не попадают записи с ненулевым uniq-шинглом
                        (*it).second.m_spamtype = (*sit).value.m_spamtype;                 // неважно, т.к. сюда не попадают записи с ненулевым uniq-шинглом
                        (*it).second.m_pers = (*sit).value.m_pers;                         // неважно, т.к. сюда не попадают записи с ненулевым uniq-шинглом
                        (*it).second.m_follow = (*sit).value.m_follow;

                        today_up.Increment();

                    } else {
                        rec_count = queuedata[(*sit).type].size();
                        if (rec_count < m_max_queue_size) {
                            queuedata[(*sit).type][(*sit).shingle] = TShingleShortInfoRPL((*sit).value.m_att_shingle, (*sit).value.m_att_shingle_type, (*sit).value.m_spamtype, (*sit).value.m_pers, (*sit).value.m_ham, (*sit).value.m_dlv, (*sit).value.m_spam, (*sit).value.m_persham, (*sit).value.m_persspam, (*sit).value.m_follow);
                            inqueue_count = IncMax32(inqueue_count, 1);

                        } else {
                            today_lost.Increment();
                        }
                    }

                } else  // если uniq-шингл задан, то добавляем в очередь-лист, чтобы не потереть att_shingle при объединении счетчиков
                {
                    rec_count = queue_list.size();
                    if (rec_count < m_max_queue_size) {
                        queue_list.push_back((*sit));
                        inqueue_count = IncMax32(inqueue_count, 1);

                    } else {
                        today_lost.Increment();
                    }
                }

                m_Mutex.Release();

                res = true;
            }

            ++sit;
        }

        SendEvent();
    }

    return res;
}

bool TRPLQueue::GetRecord(TShingleExtInfoRPLList& shinglelist) {
    bool res = false;
    TShingleShortInfoRPLHashIt it;
    TShingleExtInfoRPLListIt sit;
    int count = 0;
    ui32 a1 = 0, a2 = 0, a3 = 0, a4 = 0;
    ui32 elapsed_msec = 0;
    bool need_return_data_time = false;
    bool need_return_data_count = false;

    shinglelist.clear();
    WaitEvent();

    // посчитаем, нужно ли возвращать данные (достаточно ли их для отправки блоком) по времени
    elapsed_msec = CShingleTime::GetMs() - m_last_return_data;
    if (elapsed_msec >= m_timeout_create_sendblock)
        need_return_data_time = true;   // вышло время с момента последней отправки

    // посчитаем, нужно ли возвращать данные (достаточно ли их для отправки блоком) по количеству
    if (inqueue_count >= m_min_shingles_in_request)
        need_return_data_count = true; // данных в очереди достаточно, чтобы сформировать блок на отправку

    // отправляем данные
    if (need_return_data_time || need_return_data_count) {
        m_Mutex.Acquire();

        // сначала забираем данные из списка (m_att_shingle != 0)
        sit = queue_list.begin();
        while (sit != queue_list.end()) {
            shinglelist.push_back(*sit);
            queue_list.erase(sit++);

            today_out.Increment();

            if (shinglelist.size() >= m_max_shingles_in_request)
                break;
        }

        // потом забираем данные из хэша (m_att_shingle == 0)
        if (shinglelist.size() < m_max_shingles_in_request) {
            for (int i = 0; i < MAX_COUNT_TYPES; i++) {
                if (shinglelist.size() >= m_max_shingles_in_request)
                    break;

                if (queuedata[i].size() > 0) {
                    a1 = CShingleTime::GetMs();

                    it = queuedata[i].begin();
                    a2 = CShingleTime::GetMs() - a1;
                    while (it != queuedata[i].end()) {
                        a3 = CShingleTime::GetMs();
                        shinglelist.push_back(TShingleExtInfoRPL((*it).first, i, (*it).second.m_ham, (*it).second.m_dlv, (*it).second.m_spam, (*it).second.m_persham, (*it).second.m_persspam, (*it).second.m_att_shingle, (*it).second.m_att_shingle_type, (*it).second.m_spamtype, (*it).second.m_pers, (*it).second.m_follow));
                        a3 = CShingleTime::GetMs() - a3;

                        a4 = CShingleTime::GetMs();
                        queuedata[i].erase(it++);
                        a4 = CShingleTime::GetMs() - a4;

                        today_out.Increment();

                        if (shinglelist.size() >= m_max_shingles_in_request)
                            break;
                    }

                    a1 = CShingleTime::GetMs() - a1;

                    // if ( (a1 > 1) && (LogsGroup != NULL) && (LogsGroup->GetSendAnswerLog() != NULL) )
                    //    LogsGroup->GetSendAnswerLog()->WriteMessageAndData("GRTD(d%02d,p%02d):%u-%u-%u-%u", dirnumb, partnumb, a1, a2, a3, a4);
                }

                if (shinglelist.size() >= m_max_shingles_in_request)
                    break;
            }
        }

        if (shinglelist.size() > 0) {
            if (need_return_data_time)
                m_need_return_data_time_today = IncMax64(m_need_return_data_time_today, 1);

            if (need_return_data_count)
                m_need_return_data_count_today = IncMax64(m_need_return_data_count_today, 1);
        }

        // корректируем счетчик кол-ва записей в очереди
        if (shinglelist.size() < m_max_shingles_in_request) {
            // если мы не смогли набрать записей на полный блок для отправки, значит в очереди записей больше нет
            inqueue_count = 0;

        } else {
            inqueue_count = Minus32(inqueue_count, shinglelist.size());
        }

        // корректируем время последней отправки
        m_last_return_data = CShingleTime::GetMs();

        m_Mutex.Release();
    }

    if (shinglelist.size() > 0) {
        count = shinglelist.size();
        res = true;
        today_out_rqst.Increment();
    }

    return res;
}

void TRPLQueue::Midnight() {
    MidnightMutex.Acquire();

    yesterday_in = today_in.Value();
    yesterday_up = today_up.Value();
    yesterday_out = today_out.Value();
    yesterday_lost = today_lost.Value();
    yesterday_in_rqst = today_in_rqst.Value();
    yesterday_out_rqst = today_out_rqst.Value();
    today_in.Swap(0);
    today_up.Swap(0);
    today_out.Swap(0);
    today_lost.Swap(0);
    today_in_rqst.Swap(0);
    today_out_rqst.Swap(0);

    MidnightMutex.Release();

    m_Mutex.Acquire();

    m_need_return_data_time_yesterday = m_need_return_data_time_today;
    m_need_return_data_time_today = 0;
    m_need_return_data_count_yesterday = m_need_return_data_count_today;
    m_need_return_data_count_today = 0;

    m_Mutex.Release();
}

ui32 TRPLQueue::GetTodayCount() {
    ui32 res = 0;
    ui32 value = 0;

    for (int i = 0; i < MAX_COUNT_TYPES; i++) {
        value = queuedata[i].size();
        res = IncMax32(res, value);
    }

    return res;
}

void TRPLQueue::SendEvent() {
    if (m_Sema != NULL)
        m_Sema->Release();
}

void TRPLQueue::WaitEvent() {
    if (m_Sema != NULL) {
        if (!m_stop_event)
            m_Sema->Acquire();
    }
}

void TRPLQueue::UnBlockAllEvent(int thread_count) {
    m_stop_event = true;
    if (thread_count > 0) {
        for (int i = 0; i < thread_count; i++)
            SendEvent();
    } else
        SendEvent();
}

void TRPLQueue::Shutdown() {
    UnBlockAllEvent(thread_count);
}

//*******************************************************************************************************************************************
//                                                             TRPLPoolThreads
//*******************************************************************************************************************************************

TRPLPoolThreads::TRPLPoolThreads() {
    dirnumb = -1;
    old = false;
    rcv_buffer = NULL;
    LogsGroup = NULL;
    m_server_id = "";
    m_host = "";
    m_port = 0;
    m_fullhost = "";
    m_url = "";
    m_action = "";
    m_GeneralObject = NULL;
}

TRPLPoolThreads::~TRPLPoolThreads() {
    if (rcv_buffer != NULL) {
        delete[] rcv_buffer;
        rcv_buffer = NULL;
    }
}

void TRPLPoolThreads::Init(int dirnumbA, bool oldA, const TString& server_id, void* GeneralObjectA, TString& host, ui16 port, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec, TLogsGroup* LogsGroupA, TItselfClass* itself_objA) {
    dirnumb = dirnumbA;
    old = oldA;
    itself_obj = itself_objA;
    m_server_id = server_id;
    m_GeneralObject = GeneralObjectA;
    LogsGroup = LogsGroupA;
    rcv_buffer = new char[RCV_BUFFER_SIZE];
    SetHostData(host, port, ConnectTimeOutMSec, GetTimeOutMSec);
}

void TRPLPoolThreads::SetHostData(TString& host, ui16 port, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec) {
    m_HostDataMutex.Acquire();

    TKWStrokaRPL ws;

    m_fullhost = host;
    ws = GetHost(m_fullhost);
    m_host = ws.host;
    m_url = ws.url;
    m_action = ws.action;
    m_port = port;

    m_ConnectTimeOut = TDuration::MilliSeconds(ConnectTimeOutMSec);
    m_GetTimeOut = TDuration::MilliSeconds(GetTimeOutMSec);
    // m_initstatus = shconnobj.Init(m_host.c_str(), m_port, 0, ConnectTimeOutMSec, 0, GetTimeOutMSec);

    m_HostDataMutex.Release();
}

TKWStrokaRPL TRPLPoolThreads::GetHost(const TString& host) {
    TKWStrokaRPL res;
    TString http_s1 = "http://";
    TString http_s2 = "HTTP://";
    const char* p = NULL;
    const char* ps = NULL;

    p = strstr(host.c_str(), http_s1.c_str());
    if (p == NULL) {
        p = strstr(host.c_str(), http_s2.c_str());
        if (p == NULL)
            p = host.c_str();
        else
            p = p + http_s2.length();
    } else
        p = p + http_s1.length();
    if (p != NULL) {
        ps = strstr(p, "/");
        if (ps != NULL) {
            res.host = TString(p, ps - p);
            if ((ps + 1) != NULL) {
                res.url = TString(ps + 1);
                res.action = res.url;
                if (!res.action.empty()) {
                    p = strchr(res.action.c_str(), '/');
                    if (p == NULL)
                        p = strchr(res.action.c_str(), '\\');
                    if (p != NULL)
                        res.action = TString(p + 1);
                }
            }
        } else {
            res.host = TString(p);
            res.url = "";
        }
    }

    return res;
}

TString TRPLPoolThreads::ModifyResponce(const TString& s) {
    TString res = "";
    char* buff = NULL;
    int buffsize = 0;

    buffsize = s.length();
    if (buffsize > 0) {
        buff = new char[buffsize + 1];
        if (buff != NULL) {
            memcpy(buff, s.c_str(), buffsize);
            buff[buffsize] = 0x00;
            for (int k = 0; k < buffsize; k++) {
                if (buff[k] < ' ')  // убираем переносы строк, что записать в одну строку в лог
                    buff[k] = '.';
            }
            res = TString(buff);

            delete[] buff;
            buff = NULL;
        }
    }

    return res;
};

void TRPLPoolThreads::PrintFollowInfo(TShingleExtInfoRPLList& shinglelist, const TString& text) {
    TShingleExtInfoRPLListIt it;
    TString text_t = "";
    const int count_symb_max = 10;
    int count = 0;

    if (text.length() < count_symb_max) {
        count = count_symb_max - text.length();
        for (int i = 0; i < count; i++)
            text_t = text_t + " ";
        text_t = text + text_t;

    } else {
        text_t = text;
    }

    // печатаем отладочную информацию по шинглам из хэша отслеживающих шинглов
    it = shinglelist.begin();
    while (it != shinglelist.end()) {
        if (((*it).value.m_follow) && (LogsGroup != NULL) && (LogsGroup->GetFollowShinglesLog() != NULL))
            LogsGroup->GetFollowShinglesLog()->WriteMessageAndData("%s %016" PRIx64 "-%03d    RPL-%02d %s [%s]", LogsGroup->GetServerID().c_str(), (*it).shingle, (*it).type, dirnumb, text_t.c_str(), (*it).value.GetFollowInfo().c_str());

        ++it;
    }
}

void TRPLPoolThreads::GetRequestToRemoteServer(TShingleExtInfoRPLList& shinglelist, TPrintBuff& PBUFF) {
    if ((itself_obj != NULL) && (!itself_obj->ItSelf())) {
        if (!m_host.empty() && (m_port != 0)) {
            m_statdata.today.IncAllMailCount();

            if (rcv_buffer != NULL) {
                m_HostDataMutex.Acquire();

                bool m_Result;
                ui32 BeginProcessTime = 0;
                ui16 m_HttpStatus = 0;
                TString request_url = "";
                TString full_request_url = "";
                ui32 datalen = 0;
                TString txt = "";
                time_t dlv_time = 0;
                int err = 0;
                TString printshlist = "";
                TString responce = "";
                TString remote_server_id = "";
                TString server_id_headers = "";
                TString server_id_body = "";
                TString request_id = "";
                TShingleStatList shingle_list;

                m_statdata.today.IncConnectOK();

                memset(rcv_buffer, 0, RCV_BUFFER_SIZE);
                request_url = GetRequest(shinglelist);
                full_request_url = m_host + ":" + IntToStroka(m_port) + "/" + request_url;

                BeginProcessTime = CShingleTime::GetMs();

                TMemoryOutput writer(rcv_buffer, RCV_BUFFER_SIZE);
                TLimitedOutput<TLimitedOutputOverflowPolicy::Silent>  limitedOutput(writer, RCV_BUFFER_SIZE-1);

                {
                    NCurl::TRequestContext requestContext;
                    requestContext.SetHost(full_request_url);
                    requestContext.SetPort(m_port);
                    requestContext.SetRequestTimeout(m_GetTimeOut);
                    requestContext.SetConnectTimeout(m_ConnectTimeOut);

                    NCurl::TSimpleArtifacts artifacts;
                    try{
                        curl.Setup(std::move(requestContext));
                        curl.Perform(artifacts);
                        m_Result = true;
                        m_HttpStatus = artifacts.code;
                    } catch (...) {
                        m_Result = false;
                    }
                }

                BeginProcessTime = CShingleTime::GetMs() - BeginProcessTime;

                if (true == m_Result) {
                    if (200 == m_HttpStatus) {
                        m_statdata.today.IncRequest200Count();
                        responce = TString(rcv_buffer);

                        if (old) {
                            remote_server_id = "old";

                        } else {
                            server_id_headers = NShingleStatParser::GetServerIDFromHeaders(responce);
                            request_id = NShingleStatParser::GetRequestIDFromHeaders(responce);
                            server_id_body = NShingleStatParser::GetServerIDFromBody(responce);

                            if (!server_id_body.empty())
                                remote_server_id = server_id_body;
                            else
                                remote_server_id = server_id_headers;
                        }

                        if (remote_server_id == m_server_id) {
                            if (itself_obj != NULL)
                                itself_obj->SetItSelf(remote_server_id);
                        } else {
                            if (itself_obj != NULL)
                                itself_obj->SetSrvID(remote_server_id);
                        }

                        m_statdata.remote_srvid = remote_server_id;

                        PrintFollowInfo(shinglelist, "OK(200)");

                        //����� � ���
                        if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                            PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "RPLCLIENT-%02d: MESS! %u Request to server: OK (HttpStatus:200) - request='%s', responce(SrvID:%s,RqstID:%s)='%s'\n", dirnumb + 1, BeginProcessTime, full_request_url.c_str(), remote_server_id.c_str(), request_id.c_str(), ModifyResponce(responce).c_str());

                    } else if ((400 <= m_HttpStatus) && (m_HttpStatus < 500)) {
                        responce = TString(rcv_buffer);

                        if (old) {
                            remote_server_id = "old";

                        } else {
                            server_id_headers = NShingleStatParser::GetServerIDFromHeaders(responce);
                            request_id = NShingleStatParser::GetRequestIDFromHeaders(responce);
                            server_id_body = NShingleStatParser::GetServerIDFromBody(responce);

                            if (!server_id_body.empty())
                                remote_server_id = server_id_body;
                            else
                                remote_server_id = server_id_headers;
                        }

                        PrintFollowInfo(shinglelist, "RC(" + IntToStroka(m_HttpStatus) + ")");

                        if ((m_HttpStatus >= 400) && (m_HttpStatus < 500))
                            m_statdata.today.IncRequest4xxCount();
                        else
                            m_statdata.today.IncRequest5xxCount();
                        if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                            PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "RPLCLIENT-%02d: ERR! %u Request to server: HttpStatus:%u - request='%s', responce(SrvID:%s,RqstID:%s)='%s'\n", dirnumb + 1, BeginProcessTime, m_HttpStatus, full_request_url.c_str(), remote_server_id.c_str(), request_id.c_str(), ModifyResponce(responce).c_str());
                    } else {
                        m_statdata.today.IncRequestOtherCount();

                        PrintFollowInfo(shinglelist, "RC(" + IntToStroka(m_HttpStatus) + ")");

                        if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                            PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "RPLCLIENT-%02d: ERR! %u Request to server: HttpStatus:%u - request='%s'\n", dirnumb + 1, BeginProcessTime, m_HttpStatus, full_request_url.c_str());
                    }
                } else {
                    if (false == m_Result) {
                        m_statdata.today.IncRequestError();

                        PrintFollowInfo(shinglelist, "RE  ");

                        if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                            PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "RPLCLIENT-%02d: ERR! %u Request to server: request error (%d) - '%s'\n", dirnumb + 1, BeginProcessTime, err, full_request_url.c_str());

                    } else if (false == m_Result) {
                        m_statdata.today.IncRequestTimeout();

                        PrintFollowInfo(shinglelist, "RT  ");

                        if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                            PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "RPLCLIENT-%02d: ERR! %u Request to server: request timeout - '%s'\n", dirnumb + 1, BeginProcessTime, full_request_url.c_str());

                    } else if (false == m_Result) {
                        m_statdata.today.IncRequsetBufferOverflow();

                        PrintFollowInfo(shinglelist, "RBO ");

                        if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                            PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "RPLCLIENT-%02d: ERR! %u Request to server: request buffer overflow - '%s'\n", dirnumb + 1, BeginProcessTime, full_request_url.c_str());
                    }
                }


                m_HostDataMutex.Release();
            }
        } else {
            if (m_host.empty()) {
                PrintFollowInfo(shinglelist, "NOHOST");

                if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                    PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "RPLCLIENT-%02d: ERR! no defined host\n", dirnumb + 1);

            } else if (m_port == 0) {
                PrintFollowInfo(shinglelist, "NOPORT");

                if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                    PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "RPLCLIENT-%02d: ERR! no defined port\n", dirnumb + 1);
            }
        }

    } else {
        PrintFollowInfo(shinglelist, "ITSELF");

        if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
            PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "RPLCLIENT-%02d: ITSELF, skeep.\n", dirnumb + 1);
    }
}

TString TRPLPoolThreads::GetRequestNew(TShingleExtInfoRPLList& shinglelist) {
    // shingle-type=hamcount-spamcount-dlvcount,attendant_shingle&shingle-type=hamcount-spamcount-dlvcount,attendant_shingle&
    TString res = "";
    const char* p = NULL;
    TString modrnumb = "";
    const char* p1 = NULL;
    const char* p2 = NULL;
    TShingleExtInfoRPLListIt it;
    TString ttext = "";
    char tbuff[256];

    if ((!m_url.empty()) && (shinglelist.size() > 0)) {
        res = m_url;
        if ((res[res.length() - 1] != '/') && (res[res.length() - 1] != '?'))
            res = res + "?";
        res = res + "srvid=" + m_server_id + "&";
        res = res + "shrpl=";

        it = shinglelist.begin();
        while (it != shinglelist.end()) {
            if (/*((*it).shingle != 0) &&*/ ((*it).type >= 0) && ((*it).type < MAX_COUNT_SHINGLES_TYPE)) {
                memset(tbuff, 0, sizeof(tbuff));
                if ((*it).value.m_att_shingle != 0)
                    snprintf(tbuff, sizeof(tbuff) - 1, "%016" PRIx64 "-%d=%d-%d-%d-%d-%d,%016" PRIx64 "-%d-%d-%d", (*it).shingle, (*it).type, (*it).value.m_ham, (*it).value.m_spam, (*it).value.m_dlv, (*it).value.m_persham, (*it).value.m_persspam, (*it).value.m_att_shingle, (*it).value.m_att_shingle_type, (int)(*it).value.m_spamtype, (int)(*it).value.m_pers);
                else
                    snprintf(tbuff, sizeof(tbuff) - 1, "%016" PRIx64 "-%d=%d-%d-%d-%d-%d", (*it).shingle, (*it).type, (*it).value.m_ham, (*it).value.m_spam, (*it).value.m_dlv, (*it).value.m_persham, (*it).value.m_persspam);
                ttext = TString(tbuff);

                res = res + ttext + "&";
            }

            ++it;
        }
    }

    return res;
}

TString TRPLPoolThreads::GetRequestOld(TShingleExtInfoRPLList& shinglelist) {
    // sh=rplput?<type=1>shingle&ham&dlv&spam-shingle&ham&dlv&spam</type><type=2>shingle&ham&dlv&spam-shingle&ham&dlv&spam</type>

    TString res = "";
    const int OLD_TYPES_COUNT = 32;
    TShingleExtInfoRPLListIt it;
    TString ttext = "";
    char tbuff[256];
    TString typesrequest[OLD_TYPES_COUNT];

    if ((!m_url.empty()) && (shinglelist.size() > 0)) {
        res = m_url;
        if ((res[res.length() - 1] != '/') && (res[res.length() - 1] != '?'))
            res = res + "?";

        for (int i = 0; i < OLD_TYPES_COUNT; i++) {
            typesrequest[i] = "";
        }

        it = shinglelist.begin();
        while (it != shinglelist.end()) {
            if (((*it).shingle != 0) && ((*it).type >= 0) && ((*it).type < OLD_TYPES_COUNT)) {
                memset(tbuff, 0, sizeof(tbuff));
                snprintf(tbuff, sizeof(tbuff) - 1, "%" PRIx64 "&%d&%d&%d", (*it).shingle, (*it).value.m_ham, (*it).value.m_dlv, (*it).value.m_spam);
                ttext = TString(tbuff);

                if (!(typesrequest[(*it).type]).empty())
                    typesrequest[(*it).type] = typesrequest[(*it).type] + "-" + ttext;
                else
                    typesrequest[(*it).type] = typesrequest[(*it).type] + ttext;
            }

            ++it;
        }

        for (int i = 0; i < OLD_TYPES_COUNT; i++) {
            if (!(typesrequest[i]).empty())
                res = res + "<type=" + IntToStroka(i) + ">" + typesrequest[i] + "</type>";
        }
    }

    return res;
}

TString TRPLPoolThreads::GetRequest(TShingleExtInfoRPLList& shinglelist) {
    TString res = "";

    if (old)
        res = GetRequestOld(shinglelist);
    else
        res = GetRequestNew(shinglelist);

    return res;
}

TRPLStatData TRPLPoolThreads::GetStat() {
    return m_statdata;
}

TString TRPLPoolThreads::GetShortURL() {
    TString res = "";
    TString tres = "";

    tres = m_url;
    if ((tres[tres.length() - 1] != '/') && (tres[tres.length() - 1] != '?'))
        tres = tres + "?";
    if (!old) {
        tres = tres + "srvid=" + m_server_id + "&";
        tres = tres + "shrpl=*";
    }

    res = m_host + ":" + IntToStroka(m_port) + "/" + tres;

    return res;
}

TString TRPLPoolThreads::GetExampleRequest() {
    TString res = "";
    TShingleExtInfoRPLList shinglelist;
    TString tstr = "";
    TString tstr_mod = "";

    shinglelist.push_back(TShingleExtInfoRPL(0x00000001, 1, 1, 2, 3, 1, 0, 0, 0, MALIC, PERSHAM, false));
    shinglelist.push_back(TShingleExtInfoRPL(0x00000002, 2, 4, 5, 6, 0, 1, 0, 0, SPAM, PERSSPAM, false));

    tstr = GetRequest(shinglelist);

    for (int i = 0; i < tstr.length(); i++) {
        if (tstr[i] == '<')
            tstr_mod = tstr_mod + "&lt;";
        else if (tstr[i] == '>')
            tstr_mod = tstr_mod + "&gt;";
        else
            tstr_mod = tstr_mod + tstr[i];
    }

    res = m_host + ":" + IntToStroka(m_port) + "/" + tstr_mod;

    return res;
}

void TRPLPoolThreads::Midnight() {
    m_statdata.Midnight();
}

bool TRPLPoolThreads::NoDefinedHostOrPort() {
    bool res = false;

    m_HostDataMutex.Acquire();

    if ((m_fullhost.empty()) || (m_port == 0))
        res = true;

    m_HostDataMutex.Release();

    return res;
}

//*******************************************************************************************************************************************
//                                                             TRPLPoolDirect
//*******************************************************************************************************************************************

void RPLProcM(void* par) {
    int thread_index = -1;
    TRPLPoolDirect* ss = (TRPLPoolDirect*)par;
    int n = 0;
    TPrintBuff PBUFF;

    if (ss != NULL) {
        thread_index = ss->IncrementThreadCount();
        ss->WriteThreadIDToLog(thread_index);

        while (!ss->IsShouldStopThreads()) {
            ss->ObrabRequest(thread_index, PBUFF);
        }

        ss->DecrementThreadCount();
    }
}

TRPLPoolDirect::TRPLPoolDirect() {
    dirnumb = -1;
    enable = false;
    old = false;
    m_real_thread_count = 0;
    m_stop_threads = false;
    thread_count = 0;

    m_host = "";
    m_port = 0;
    m_connecttimeout = 0;
    m_requesttimeout = 0;

    m_server_id = "";
    m_GeneralObject = NULL;
}

TRPLPoolDirect::~TRPLPoolDirect() {
    TRPLThreadListIt tid;
    TRPLPoolThreadsListIt iit;

    SetStopThreads();
    while (!IsStopThreads())
        usleep(1000);

    tid = threadlist.begin();
    while (tid != threadlist.end()) {
        if ((*tid) != NULL) {
            delete (*tid);
            (*tid) = NULL;
        }

        ++tid;
    }

    iit = itemlist.begin();
    while (iit != itemlist.end()) {
        if ((*iit) != NULL) {
            delete (*iit);
            (*iit) = NULL;
        }

        ++iit;
    }
}

bool TRPLPoolDirect::InitBeforeFork(int dirnumbA, const TString& server_id, TLogsGroup* LogsGroupA, bool enableA, int thread_countA, const TString& hostA, int portA, int connecttimeoutA, int requesttimeoutA, bool oldA, ui32 max_queue_sizeA, ui32 max_shingles_in_requestA, ui32 min_shingles_in_requestA, ui32 timeout_create_sendblockA) {
    bool res = true;

    dirnumb = dirnumbA;
    LogsGroup = LogsGroupA;
    m_server_id = server_id;

    enable = enableA;
    old = oldA;
    thread_count = thread_countA;
    m_host = hostA;
    m_port = portA;
    m_connecttimeout = connecttimeoutA;
    m_requesttimeout = requesttimeoutA;

    if (thread_count > MAX_THREAD_COUNT)
        thread_count = MAX_THREAD_COUNT;
    if (thread_count < 2)
        thread_count = 2;

    queue.Init(thread_count, max_queue_sizeA, max_shingles_in_requestA, min_shingles_in_requestA, timeout_create_sendblockA);

    return res;
}

bool TRPLPoolDirect::InitAfterFork(void* GeneralObjectA) {
    bool res = true;
    TRPLPoolThreads* pritem = NULL;
    TThread* prthread = NULL;

    m_GeneralObject = GeneralObjectA;
    ResetStopThreads();
    if (enable) {
        for (int i = 0; i < thread_count; i++) {
            pritem = new TRPLPoolThreads();
            if (pritem != NULL) {
                pritem->Init(dirnumb, old, m_server_id, m_GeneralObject, m_host, m_port, m_connecttimeout, m_requesttimeout, LogsGroup, &itself_obj);
                itemlist.push_back(pritem);

                prthread = new TThread((TThread::TThreadProc)&RPLProcM, this);
                if (prthread != NULL) {
                    prthread->Start();
                    threadlist.push_back(prthread);
                }
            }
        }
    }

    return res;
}

void TRPLPoolDirect::AddRequest(TShingleExtInfoRPLList& shinglelist) {
    if ((enable) && (shinglelist.size() > 0)) {
        if (!itself_obj.ItSelf())
            queue.AddRecord(shinglelist);
        else
            PrintFollowInfo(shinglelist, "ITSELF");
    }
}

bool TRPLPoolDirect::ObrabRequest(int index, TPrintBuff& PBUFF) {
    bool res = true;

    if ((index >= 0) && (index < m_real_thread_count)) {
        TShingleShortInfoRPL value;
        TShingleExtInfoRPLList shinglelist;
  TShingleExtInfoRPLListIt it;

        shinglelist.clear();
        if (!queue.GetRecord(shinglelist /*, dirnumb, index, LogsGroup*/)) {
            res = false;
            // данных на передачу нет, значит есть смысл подождать их накопление (событие бросать не будем, бросим позже
            // через EventTick(), чтобы выгрести застрявшие)

  }
  else {
   PBUFF.Clear();

   // if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
   //    PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "*****%s*****\n", rnumb.c_str());
   if (itemlist[index] != NULL)
    itemlist[index]->GetRequestToRemoteServer(shinglelist, PBUFF);
   // if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
   //    PBUFF.in_printbuff += snprintf(PBUFF.printbuff + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "\n");

   if ((LogsGroup != NULL) && (LogsGroup->GetDebugMode()) && (LogsGroup->GetReplicLog() != NULL))
    LogsGroup->GetReplicLog()->WriteMessageAndDataBUFF(PBUFF.printbuff, PBUFF.in_printbuff);

   it = shinglelist.begin();
   while (it != shinglelist.end())
   {
    if (((*it).shingle == 0) && ((*it).type == 0))
    {
     if (!(LogsGroup->GetDebugMode()))
     {
      if ((LogsGroup != NULL) && (LogsGroup->GetReplicLog() != NULL))
      {
       LogsGroup->GetReplicLog()->WriteMessageAndDataBUFF(PBUFF.printbuff, PBUFF.in_printbuff);
       LogsGroup->GetReplicLog()->FFlush();
      }

     }
     else
     {
      if ((LogsGroup != NULL) && (LogsGroup->GetReplicLog() != NULL))
       LogsGroup->GetReplicLog()->FFlush();

     }

     break;
    }

    ++it;
   }

            queue.SendEventFunc();  // возможно есть ещё данные, бросим событие, чтобы их выгрести
        }
    }

    return res;
}

void TRPLPoolDirect::Midnight() {
    TRPLPoolThreadsListIt it;

    it = itemlist.begin();
    while (it != itemlist.end()) {
        if ((*it) != NULL)
            (*it)->Midnight();

        ++it;
    }

    queue.Midnight();
}

TRPLStatData TRPLPoolDirect::GetStat() {
    TRPLStatData res, tres;
    TRPLPoolThreadsListIt it;
    TString remote_srvid = "";

    it = itemlist.begin();
    while (it != itemlist.end()) {
        if ((*it) != NULL) {
            tres = (*it)->GetStat();
            res += tres;
        }

        ++it;
    }

    res.enable_client = enable;
    res.old = old;
    res.threads = m_real_thread_count;
    res.host = GetShortURL();
    res.port = m_port;

    if (itself_obj.ItSelfStat())
        res.remote_srvid = "ITSELF (" + IntToStroka(itself_obj.GetElapsedTime()) + ")";
    else
        res.remote_srvid = itself_obj.GetRemoteServerID();

    res.today.queue_in = queue.GetTodayIN();
    res.today.queue_up = queue.GetTodayUP();
    res.today.queue_count = queue.GetTodayCount();
    res.today.queue_lost = queue.GetTodayLost();
    res.today.queue_out = queue.GetTodayOUT();
    res.today.queue_in_rqst = queue.GetTodayINRqst();
    res.today.queue_out_rqst = queue.GetTodayOUTRqst();

    res.yesterday.queue_in = queue.GetYesterdayIN();
    res.yesterday.queue_up = queue.GetYesterdayUP();
    res.yesterday.queue_count = 0;
    res.yesterday.queue_lost = queue.GetYesterdayLost();
    res.yesterday.queue_out = queue.GetYesterdayOUT();
    res.yesterday.queue_in_rqst = queue.GetYesterdayINRqst();
    res.yesterday.queue_out_rqst = queue.GetYesterdayOUTRqst();

    res.max_queue_size = queue.m_max_queue_size;
    res.max_shingles_in_request = queue.m_max_shingles_in_request;
    res.min_shingles_in_request = queue.m_min_shingles_in_request;
    res.timeout_create_sendblock = queue.m_timeout_create_sendblock;

    res.need_return_data_time_today = queue.m_need_return_data_time_today;
    res.need_return_data_count_today = queue.m_need_return_data_count_today;
    res.need_return_data_time_yesterday = queue.m_need_return_data_time_yesterday;
    res.need_return_data_count_yesterday = queue.m_need_return_data_count_yesterday;
    res.inqueue_count = queue.inqueue_count;

    return res;
}

int TRPLPoolDirect::IncrementThreadCount() {
    int res = 0;

    m_MutexThreads.Acquire();

    m_real_thread_count++;
    if ((m_real_thread_count - 1) >= 0)
        res = m_real_thread_count - 1;

    m_MutexThreads.Release();

    return res;
}

void TRPLPoolDirect::DecrementThreadCount() {
    m_MutexThreads.Acquire();

    if (m_real_thread_count > 0)
        m_real_thread_count--;

    m_MutexThreads.Release();
}

void TRPLPoolDirect::ResetStopThreads() {
    m_MutexThreads.Acquire();

    m_stop_threads = false;

    m_MutexThreads.Release();
}

void TRPLPoolDirect::SetStopThreads() {
    m_MutexThreads.Acquire();

    m_stop_threads = true;

    m_MutexThreads.Release();
}

bool TRPLPoolDirect::IsShouldStopThreads() {
    return m_stop_threads;
}

bool TRPLPoolDirect::IsStopThreads() {
    bool res = false;

    if (m_real_thread_count <= 0)
        res = true;

    return res;
}

int TRPLPoolDirect::ReadThreadsCount() {
    return m_real_thread_count;
}

void TRPLPoolDirect::WriteThreadIDToLog(int thread_index) {
    int thread_id = -1;

#ifndef _win_
    thread_id = syscall(SYS_gettid);
#endif

    if ((LogsGroup != NULL) && (LogsGroup->GetDebugInfoLog() != NULL))
        LogsGroup->GetDebugInfoLog()->WriteMessageAndDataStatus(KMESSAGE, "THREADID % 9d: RPL DIR_%02d THREAD_INDEX_%02d", thread_id, dirnumb, thread_index);
}

void TRPLPoolDirect::PrintFollowInfo(TShingleExtInfoRPLList& shinglelist, const TString& text) {
    TShingleExtInfoRPLListIt it;
    TString text_t = "";
    const int count_symb_max = 10;
    int count = 0;

    if (text.length() < count_symb_max) {
        count = count_symb_max - text.length();
        for (int i = 0; i < count; i++)
            text_t = text_t + " ";
        text_t = text + text_t;

    } else {
        text_t = text;
    }

    // печатаем отладочную информацию по шинглам из хэша отслеживающих шинглов
    it = shinglelist.begin();
    while (it != shinglelist.end()) {
        if (((*it).value.m_follow) && (LogsGroup != NULL) && (LogsGroup->GetFollowShinglesLog() != NULL))
            LogsGroup->GetFollowShinglesLog()->WriteMessageAndData("%s %016" PRIx64 "-%03d    RPL-%02d %s [%s]", LogsGroup->GetServerID().c_str(), (*it).shingle, (*it).type, dirnumb, text_t.c_str(), (*it).value.GetFollowInfo().c_str());

        ++it;
    }
}

TString TRPLPoolDirect::GetShortURL() {
    TString res = "";

    if ((itemlist.size() > 0) && (itemlist[0] != NULL))
        res = itemlist[0]->GetShortURL();
    else
        res = "no item";

    return res;
}

TString TRPLPoolDirect::GetExampleRequest() {
    TString res = "";

    if ((itemlist.size() > 0) && (itemlist[0] != NULL))
        res = itemlist[0]->GetExampleRequest();
    else
        res = "no item";

    return res;
}

void TRPLPoolDirect::Shutdown() {
    queue.Shutdown();
}

void TRPLPoolDirect::EventTick() {
    queue.SendEventFunc();  // возможно есть данные, бросим событие, чтобы попробовать их выгрести
}

//*******************************************************************************************************************************************
//                                                             TRPLMain
//*******************************************************************************************************************************************

TRPLMain::TRPLMain() {
    LogsGroup = NULL;
    for (int i = 0; i < MAX_DIRECTS_COUNT; i++)
        directs_data[i] = NULL;
}

TRPLMain::~TRPLMain() {
    for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
        if (directs_data[i] != NULL) {
            delete directs_data[i];
            directs_data[i] = NULL;
        }
    }
}

bool TRPLMain::InitBeforeFork(const TString& server_id, TKConfig* configA, TLogsGroup* LogsGroupA) {
    bool res = true;
    bool enable = false;
    int thread_count = 1;
    TString host = "";
    int port = 0;
    int connecttimeout = 0;
    int requesttimeout = 0;
    bool old = false;
    TRPLPoolDirect* direct_item = NULL;
    TString configdata = "";

    LogsGroup = LogsGroupA;
    if (configA != NULL) {
        configdata = configdata + "RPLCLIENT: init with following data\n";

        ui32 max_queue_size = configA->ReadInteger("rpl", "max_queue_size", TRPLQueue::MAX_QUEUE_SIZE);
        ui32 max_shingles_in_request = configA->ReadInteger("rpl", "max_shingles_in_request", TRPLQueue::MAX_SHINGLES_IN_REQUEST);
        ui32 min_shingles_in_request = configA->ReadInteger("rpl", "min_shingles_in_request", TRPLQueue::GETDATA_MIN_COUNT);
        ui32 timeout_create_sendblock = configA->ReadInteger("rpl", "timeout_create_sendblock", TRPLQueue::GETDATA_TIMEOUT_MS);

        for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
            enable = configA->ReadBool("rpl-" + IntToStroka2(i + 1), "enable", false);
            old = configA->ReadBool("rpl-" + IntToStroka2(i + 1), "old", false);
            thread_count = configA->ReadInteger("rpl-" + IntToStroka2(i + 1), "thread_count", 2);
            host = configA->ReadStroka("rpl-" + IntToStroka2(i + 1), "host", "");
            port = configA->ReadInteger("rpl-" + IntToStroka2(i + 1), "port", 80);
            connecttimeout = configA->ReadInteger("rpl-" + IntToStroka2(i + 1), "connecttimeout", 100);
            requesttimeout = configA->ReadInteger("rpl-" + IntToStroka2(i + 1), "requesttimeout", 200);

            configdata = configdata + "RPLCLIENT-" + IntToStroka2(i + 1) + ": enable=" + BoolToStroka2(enable) + "\n";
            if (enable) {
                configdata = configdata + "RPLCLIENT-" + IntToStroka2(i + 1) + ": old=" + BoolToStroka2(old) + "\n";
                configdata = configdata + "RPLCLIENT-" + IntToStroka2(i + 1) + ": thread_count=" + IntToStroka(thread_count) + "\n";
                configdata = configdata + "RPLCLIENT-" + IntToStroka2(i + 1) + ": host='" + host + "'\n";
                configdata = configdata + "RPLCLIENT-" + IntToStroka2(i + 1) + ": port=" + IntToStroka(port) + "\n";
                configdata = configdata + "RPLCLIENT-" + IntToStroka2(i + 1) + ": connecttimeout=" + IntToStroka(connecttimeout) + "\n";
                configdata = configdata + "RPLCLIENT-" + IntToStroka2(i + 1) + ": requesttimeout=" + IntToStroka(requesttimeout) + "\n";
            }

            if (enable && ((thread_count == 0) || (host.empty()) || (port == 0))) {
                if ((LogsGroup != NULL) && (LogsGroup->GetReplicLog() != NULL))
                    LogsGroup->GetReplicLog()->WriteMessageAndDataStatus(KERROR, "DIR-%02d: bad thread_count or host or port.", i + 1);

                res = false;
                break;
            }

            direct_item = new TRPLPoolDirect();
            if (direct_item != NULL) {
                if (direct_item->InitBeforeFork(i, server_id, LogsGroup, enable, thread_count, host, port, connecttimeout, requesttimeout, old, max_queue_size, max_shingles_in_request, min_shingles_in_request, timeout_create_sendblock)) {
                    directs_data[i] = direct_item;

                } else {
                    if ((LogsGroup != NULL) && (LogsGroup->GetReplicLog() != NULL))
                        LogsGroup->GetReplicLog()->WriteMessageAndDataStatus(KERROR, "DIR-%02d: bad initialization.", i + 1);
                    res = false;
                    break;
                }
            } else {
                if ((LogsGroup != NULL) && (LogsGroup->GetReplicLog() != NULL))
                    LogsGroup->GetReplicLog()->WriteMessageAndDataStatus(KERROR, "DIR-%02d: bad create item", i + 1);
                res = false;
                break;
            }
        }

        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", configdata.c_str());
    }

    return res;
}

bool TRPLMain::InitAfterFork(void* GeneralObjectA) {
    bool res = true;

    for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
        if (directs_data[i] != NULL) {
            if (!directs_data[i]->InitAfterFork(GeneralObjectA)) {
                if ((LogsGroup != NULL) && (LogsGroup->GetReplicLog() != NULL))
                    LogsGroup->GetReplicLog()->WriteMessageAndDataStatus(KERROR, "DIR-%02d: bad after fork initialize.", i + 1);
                res = false;
                break;
            }
        }
    }

 //test direction
 TShingleExtInfoRPLList testshinglelist;

 testshinglelist.push_back(TShingleExtInfoRPL(0, 0, 1, 1, 1, 1, 1, 0, 0, UNKNOWN, PERSUNDEF, false));
 AddRequest(testshinglelist);

    return res;
}

void TRPLMain::Midnight() {
    for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
        if (directs_data[i] != NULL)
            directs_data[i]->Midnight();
    }
}

void TRPLMain::Shutdown() {
    for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
        if (directs_data[i] != NULL)
            directs_data[i]->Shutdown();
    }
}

void TRPLMain::EventTick() {
    for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
        if (directs_data[i] != NULL)
            directs_data[i]->EventTick();
    }
}

TRPLStatDataSummary TRPLMain::GetStat() {
    TRPLStatDataSummary res;

    for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
        if (directs_data[i] != NULL)
            res.data[i] = directs_data[i]->GetStat();
    }
    res.max_count = MAX_DIRECTS_COUNT;

    return res;
}

TString TRPLMain::GetExampleRequest(int type) {
    TString res = "";

    /*for (int i = 0; i < MAX_DIRECTS_COUNT; i++)
   {
      if (directs_data[i] != NULL)
      {
         res = directs_data[i]->GetExampleRequest();
         break;
      }
   }*/

    if ((type >= 0) && (type < MAX_DIRECTS_COUNT))
        res = directs_data[type]->GetExampleRequest();

    return res;
}

void TRPLMain::AddRequest(TShingleExtInfoRPLList& shinglelist) {
    for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
        if (directs_data[i] != NULL)
            directs_data[i]->AddRequest(shinglelist);
    }
}

void TRPLMain::AddRequest(TShingleExtInfoRPL shingle_data, const TString& debugstr) {
    TShingleExtInfoRPLList shinglelist;

    if ((LogsGroup != NULL) && (LogsGroup->GetTestLog() != NULL))
        LogsGroup->GetTestLog()->WriteMessageAndData("'%s' -> %s\n", debugstr.c_str(), shingle_data.toLog().c_str());

    shinglelist.push_back(shingle_data);
    for (int i = 0; i < MAX_DIRECTS_COUNT; i++) {
        if (directs_data[i] != NULL)
            directs_data[i]->AddRequest(shinglelist);
    }
}

//*******************************************************************************************************************************************
