#pragma once

#include "util/system/mutex.h"
#include "util/generic/string.h"
#include "util/system/defaults.h"
#include "util/generic/hash.h"
#include "tlogsgroup.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/tkcounterclass.h>
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include "tshinglesclasses.h"
#include "tgeneralclasses.h"
#include "tproxyclientspool.h"
#include "trplclientspool.h"
#include "tsimplestorage.h"
#include <mail/so/spamstop/tools/so-clients/tshinglerenv.h>
#include <vector>
#include <list>

enum TProtokolType { VP_OLD,
                     VP_NEW };
enum TCleanupType { CT_NEW,
                    CT_DEL };

TString TCleanupTypeToStroka(TCleanupType type);

//********************************************************************************************************************************
//                                                TTimeDistributedWriteClass
//********************************************************************************************************************************

class TTimeDistributedWriteClass {
private:
    ui32 m_part_count;
    ui32 m_period_sec;
    ui32 m_lastwritebuffer[MAX_COUNT_SHINGLES_TYPE];
    ui32 m_lastwrite;
    TMutex m_Mutex;

public:
    TTimeDistributedWriteClass();
    ~TTimeDistributedWriteClass();

    void Init(ui32 part_count, ui32 period_sec);
    int NeedWriteDump();    // возвращает индекс части, которую нужно сохранить, либо -1
};

//********************************************************************************************************************************
//                                                TDeleteObjectMain
//********************************************************************************************************************************

struct TDeleteStruct {
    int type;
    int part;
    TShingleDataTEHash* heavy_hash;
    TShingleDataSingleHash* ordinary_yesterday;
    TShingleDataSingleHash* ordinary_today;
    TString op_ident;

    TDeleteStruct() {
        Clear();
    }

    void Clear() {
        type = -1;
        part = -1;
        heavy_hash = NULL;
        ordinary_yesterday = NULL;
        ordinary_today = NULL;
        op_ident = "???";
    }
};

typedef std::list<TDeleteStruct> TDeleteStructList;
typedef TDeleteStructList::iterator TDeleteStructListIt;

class TDeleteObjectMain {
private:
    TDeleteStructList datalist;
    TMutex m_Mutex;
    TLogsGroup* LogsGroup;

public:
    TDeleteObjectMain();
    ~TDeleteObjectMain();

    void Init(TLogsGroup* LogsGroupA);

    void Add(TDeleteStruct ds);
    bool DeleteAllData();
};

//********************************************************************************************************************************
//                                                 TBusyCache
//********************************************************************************************************************************

struct TBusyMonStat {
    TDiffCounter m_get;
    TDiffCounter m_get_heavy;
    TDiffCounter m_put;
    TDiffCounter m_putm;
    TDiffCounter m_setm;
    TDiffCounter m_setweight;

    TString GetDiff() {
        TString res = "";
        char buff[512];

        memset(buff, 0, sizeof(buff));
        snprintf(buff, sizeof(buff), "%u-%u-%u-%u-%u-%u", m_get.GetDiff(), m_get_heavy.GetDiff(), m_put.GetDiff(), m_putm.GetDiff(), m_setm.GetDiff(), m_setweight.GetDiff());
        res = TString(buff);

        return res;
    }
};

enum TBusyCacheType { BC_UNKNOWN,
                      BC_PUT,
                      BC_PUTM,
                      BC_SETM,
                      BC_SETWEIGHT };

struct TBusyCacheItem {
    TBusyCacheType m_type;
    ui64 m_shingle;
    ui16 m_t_ham;
    ui16 m_t_dlv;
    ui16 m_t_spam;
    ui16 m_t_persham;
    ui16 m_t_persspam;
    float m_t_weight;
    ui16 m_y_ham;
    ui16 m_y_dlv;
    ui16 m_y_spam;
    ui16 m_y_persham;
    ui16 m_y_persspam;
    float m_y_weight;
    ui64 m_att_shingle;
    int m_att_shingle_type;
    bool m_no_replic;

    TBusyCacheItem() {
        Clear();
    }

    //PUT
    TBusyCacheItem(ui64 shingle, ui16 count, TShingleSpamType spamtype, ui64 att_shingle, int att_shingle_type, TPersType pers, bool no_replic) {
        Clear();
        m_type = BC_PUT;
        m_shingle = shingle;
        m_t_ham = count;
        m_t_dlv = spamtype;
        m_t_spam = pers;
        m_att_shingle = att_shingle;
        m_att_shingle_type = att_shingle_type;
        m_no_replic = no_replic;
    }

    //PUTM
    TBusyCacheItem(ui64 shingle, ui16 ham, ui16 dlv, ui16 spam, ui16 persham, ui16 persspam, ui64 att_shingle, int att_shingle_type) {
        Clear();
        m_type = BC_PUTM;
        m_shingle = shingle;
        m_t_ham = ham;
        m_t_dlv = dlv;
        m_t_spam = spam;
        m_t_persham = persham;
        m_t_persspam = persspam;
        m_att_shingle = att_shingle;
        m_att_shingle_type = att_shingle_type;
    }

    //SETM
    TBusyCacheItem(ui64 shingle, ui16 t_ham, ui16 t_dlv, ui16 t_spam, ui16 t_persham, ui16 t_persspam, float t_weight, ui16 y_ham, ui16 y_dlv, ui16 y_spam, ui16 y_persham, ui16 y_persspam, float y_weight, ui64 att_shingle, int att_shingle_type) {
        Clear();
        m_type = BC_SETM;
        m_shingle = shingle;
        m_t_ham = t_ham;
        m_t_dlv = t_dlv;
        m_t_spam = t_spam;
        m_t_persham = t_persham;
        m_t_persspam = t_persspam;
        m_t_weight = t_weight;
        m_y_ham = y_ham;
        m_y_dlv = y_dlv;
        m_y_spam = y_spam;
        m_y_persham = y_persham;
        m_y_persspam = y_persspam;
        m_y_weight = y_weight;
        m_att_shingle = att_shingle;
        m_att_shingle_type = att_shingle_type;
    }

    //SETWEIGHT
    TBusyCacheItem(ui64 shingle, float weight) {
        Clear();
        m_type = BC_SETWEIGHT;
        m_shingle = shingle;
        m_t_weight = weight;
    }

    void Clear() {
        m_type = BC_UNKNOWN;
        m_shingle = 0;
        m_t_ham = 0;
        m_t_dlv = 0;
        m_t_spam = 0;
        m_t_persham = 0;
        m_t_persspam = 0;
        m_t_weight = 0;
        m_y_ham = 0;
        m_y_dlv = 0;
        m_y_spam = 0;
        m_y_persham = 0;
        m_y_persspam = 0;
        m_y_weight = 0;
        m_att_shingle = 0;
        m_att_shingle_type = 0;
        m_no_replic = false;
    }
};

typedef std::list<TBusyCacheItem> TBusyCacheItemList;
typedef TBusyCacheItemList::iterator TBusyCacheItemListIt;

struct TBusyCacheStat {
    ui32 m_count;
    ui64 m_today_put;
    ui64 m_today_putm;
    ui64 m_today_setm;
    ui64 m_today_setweight;
    ui64 m_today_get;
    ui64 m_today_get_heavy;
    ui64 m_today_lost_put;
    ui64 m_today_lost_putm;
    ui64 m_today_lost_setm;
    ui64 m_today_lost_setweight;
    ui64 m_yesterday_put;
    ui64 m_yesterday_putm;
    ui64 m_yesterday_setm;
    ui64 m_yesterday_setweight;
    ui64 m_yesterday_get;
    ui64 m_yesterday_get_heavy;
    ui64 m_yesterday_lost_put;
    ui64 m_yesterday_lost_putm;
    ui64 m_yesterday_lost_setm;
    ui64 m_yesterday_lost_setweight;

    TBusyCacheStat() {
        Clear();
    }

    void Clear() {
        m_count = 0;
        m_today_put = 0;
        m_today_putm = 0;
        m_today_setm = 0;
        m_today_setweight = 0;
        m_today_get = 0;
        m_today_get_heavy = 0;
        m_today_lost_put = 0;
        m_today_lost_putm = 0;
        m_today_lost_setm = 0;
        m_today_lost_setweight = 0;
        m_yesterday_put = 0;
        m_yesterday_putm = 0;
        m_yesterday_setm = 0;
        m_yesterday_setweight = 0;
        m_yesterday_get = 0;
        m_yesterday_get_heavy = 0;
        m_yesterday_lost_put = 0;
        m_yesterday_lost_putm = 0;
        m_yesterday_lost_setm = 0;
        m_yesterday_lost_setweight = 0;
    }

    void Midnight() {
        m_count = 0;
        m_yesterday_put = m_today_put;
        m_yesterday_putm = m_today_putm;
        m_yesterday_setm = m_today_setm;
        m_yesterday_setweight = m_today_setweight;
        m_yesterday_get = m_today_get;
        m_yesterday_get_heavy = m_today_get_heavy;
        m_yesterday_lost_put = m_today_lost_put;
        m_yesterday_lost_putm = m_today_lost_putm;
        m_yesterday_lost_setm = m_today_lost_setm;
        m_yesterday_lost_setweight = m_today_lost_setweight;
        m_today_put = 0;
        m_today_putm = 0;
        m_today_setm = 0;
        m_today_setweight = 0;
        m_today_get = 0;
        m_today_get_heavy = 0;
        m_today_lost_put = 0;
        m_today_lost_putm = 0;
        m_today_lost_setm = 0;
        m_today_lost_setweight = 0;
    }
};

class TBusyCache {
private:
    static const int MAX_SIZE_BUSYCACHE = 50000;

private:
    TBusyCacheItemList busycache;
    TMutex BusyCacheMutex;
    TBusyCacheStat statdata;
    TBusyMonStat* m_busy_monstat;

public:
    TBusyCache();
    ~TBusyCache();

    void Init(TBusyMonStat* busy_monstat);
    void Add(const TBusyCacheItem& value);
    bool Get(TBusyCacheItem& value);
    void Midnight();
    TBusyCacheStat GetStat();
    bool IsEmpty();
    void AddBusygetStat();
    void AddBusygetStatFindHeavy();
};

//********************************************************************************************************************************
//                                                TShingleStorageItem
//********************************************************************************************************************************

typedef THashMap<ui64, ui64> TFollowShingleHash;
typedef TFollowShingleHash::iterator TFollowShingleHashIt;

enum TBusyType { TBT_UNKNOWN,
                 TBT_CLEANUP,
                 TBT_MIDNIGHT,
                 TBT_WRITEDUMP };

struct TOrdinaryPointers {
    bool exists_today;
    bool exists_yesterday;
    TShingleDataSingleHashIt t_it;
    TShingleDataSingleHashIt y_it;

    TOrdinaryPointers() {
        Clear();
    }

    void Clear() {
        exists_today = false;
        exists_yesterday = false;
    }
};

struct TSHTypePartStat {
    ui32 today_count;
    ui32 yesterday_count;
    ui32 heavy_count;
    time_t last_cleanup;
    time_t last_midnight;
    time_t last_save;
    ui32 last_cleanup_during;
    ui32 last_midnight_during;
    ui32 last_save_during;
    ui32 rpl_today_shingles_count;
    ui32 rpl_yesterday_shingles_count;
    ui32 today_cleanup_count;
    TBusyCacheStat busycachestat;
    TBusyType busytype;

    TSHTypePartStat() {
        Clear();
    }

    void Clear() {
        today_count = 0;
        yesterday_count = 0;
        heavy_count = 0;
        last_cleanup = 0;
        last_midnight = 0;
        last_save = 0;
        last_cleanup_during = 0;
        last_midnight_during = 0;
        last_save_during = 0;
        rpl_today_shingles_count = 0;
        rpl_yesterday_shingles_count = 0;
        today_cleanup_count = 0;
        busycachestat.Clear();
        busytype = TBT_UNKNOWN;
    }
};

class TShingleStorageItem {
public:
    static const ui32 HEAVY_TRESHOLD_DEFAULT = 20;
    static const ui32 MAX_SIZE_PART_ORDINARYHASH_DEFAULT = 1000000;
    static const ui32 SAVE_TRESHOLD_DEFAULT = 0;
    static const ui32 CLEANUP_TRESHOLD_DEFAULT = 1;
    static const ui32 RPLDIFF_VALUE_DEFAULT = 5;
    static const ui32 SHUTDOWN_SAVE_TRESHOLD_DEFAULT = 0;

private:
    bool m_shutdown;
    TMutex m_shutdown_mutex;
    TShingleDataTEHash* m_heavy_hash;
    TShingleDataSingleHash* m_ordinary_today;
    TShingleDataSingleHash* m_ordinary_yesterday;
    TLogsGroup* LogsGroup;
    TDeleteObjectMain* delobj;
    int m_part;
    int m_type;
    TRPLMain* RPLPool;
    TMutex m_MutexOrdinary;
    TMutex m_MutexHeavy;
    TMutex m_MutexOrdinaryBusy;
    ui32 m_tick_busy;
    TMutex m_MutexHeavyBusy;
    bool m_busy_ordinary;
    TBusyType m_busytype;
    TKAtomic m_atomic_ord;
    TString m_dumpfilename;
    TBusyCache busycacheobj;
    TFollowShingleHash* m_followhash;
    TTrafficCounter m_replic_shingles_count;
    ui32 m_koef_div;
    TBusyMonStat* m_busy_monstat;

    TMutex m_event_mutex;
    bool m_need_cleanup;
    bool m_need_writedump;
    bool m_need_midnight;
    time_t m_last_cleanup;
    time_t m_last_midnight;
    time_t m_last_save;
    ui32 m_last_cleanup_during;
    ui32 m_last_midnight_during;
    ui32 m_last_save_during;

    ui32 m_heavy_treshold;
    ui32 m_max_size_ordinary_hash;
    ui32 m_save_treshold;
    ui32 m_cleanup_treshold;
    ui32 m_rpldiff_value;
    TCleanupType m_cleanup_type;
    ui32 m_shutdown_save_treshold;
    ui32 m_today_cleanup_count;
    TSOSERVDBG_LOCKTYPE m_lock_type;
    TPrevRequestTiming m_prev_timing;

    void LockOrdinary(const TSOSERVDBG_LOCKTYPE lock_type);
    void UnLockOrdinary();
    ui32 SetBusyOrdinary(bool busyA, ui32& during, TBusyType busytype);
    bool GetBusyOrdinary();

    void LockHeavy();
    void UnLockHeavy();
    TOrdinaryPointers FindShingleInOrdinaryHash(ui64 shingle, ui32& tick_today, ui32& tick_yesterday);

    bool GetShutdownPriznak() {
        return m_shutdown;
    }
    void WriteExitStep(const TString& text);

    TShingleStat PutA(const TString& abonent_ip, ui64 shingle, ui16 count, TShingleSpamType spamtype, ui64 att_shingle, int att_shingle_type, TPersType pers, ui32 heavytreshold, const TString& debugstr, bool no_replic);
    TShingleStat PutMA(ui64 shingle, ui16 ham, ui16 dlv, ui16 spam, ui16 persham, ui16 persspam, ui64 att_shingle, int att_shingle_type, ui32 heavytreshold);
    TShingleStat SetMA(ui64 shingle, ui16 t_ham, ui16 t_dlv, ui16 t_spam, ui16 t_persham, ui16 t_persspam, float t_weight, ui16 y_ham, ui16 y_dlv, ui16 y_spam, ui16 y_persham, ui16 y_persspam, float y_weight, ui64 att_shingle, int att_shingle_type, ui32 heavytreshold);
    int SetWeightA(ui64 shingle, float weight);
    void ApplyBusyCacheEvent();
    bool ExistsFollowShingle(ui64 shingle, ui32& tick);
    ui32 WriteDumpA(ui32 treshold);

public:
    TShingleStorageItem();
    ~TShingleStorageItem();

    bool Init(int part, int type, const TString& dumpfilename, TLogsGroup* LogsGroupA, TDeleteObjectMain* delobjA, ui32 rpldiff_value, ui32 heavy_treshold, ui32 max_size_ohash, ui32 save_treshold, ui32 cleanup_treshold, TRPLMain* RPLPoolA, TFollowShingleHash* followhashA, ui32 koef_div, TBusyMonStat* busy_monstat, TCleanupType cleanup_type, ui32 shutdown_save_treshold);
    TShingleStat Put(const TString& abonent_ip, ui64 shingle, ui16 count, TShingleSpamType spamtype, ui64 att_shingle, int att_shingle_type, TPersType pers, const TString& debugstr, bool no_replic, bool is_putm);
    TShingleStat PutM(const TString& abonent_ip, ui64 shingle, ui16 ham, ui16 dlv, ui16 spam, ui16 persham, ui16 persspam, ui64 att_shingle, int att_shingle_type);
    TShingleStat SetM(const TString& abonent_ip, ui64 shingle, ui16 t_ham, ui16 t_dlv, ui16 t_spam, ui16 t_persham, ui16 t_persspam, float t_weight, ui16 y_ham, ui16 y_dlv, ui16 y_spam, ui16 y_persham, ui16 y_persspam, float y_weight, ui64 att_shingle, int att_shingle_type);
    TShingleStat Get(const TString& abonent_ip, ui64 shingle, bool is_second);
    bool ClearShingleA(const TString& abonent_ip, ui64 shingle, bool& busy);
    int SetWeight(const TString& abonent_ip, ui64 shingle, float weight);
    TSHTypePartStat GetStat();
    void ShedulerAction();
    void SetWriteDumpEvent();
    void SetMidnightEvent();
    void SetCleanupEvent();
    ui32 ShutdownWriteDump();
    ui32 PeriodWriteDump();
    ui32 Cleanup();
    ui32 Midnight();
    void Shutdown();
    void SetLastMidnightTime(ui32 value);
    void SetLastCleanupTime(ui32 value);

    void AddTodayDumpItem(ui64 shingle, ui16 t_ham, ui16 t_dlv, ui16 t_spam, ui16 t_persham, ui16 t_persspam, float t_weight, bool& exists);
    void AddYesterdayDumpItem(ui64 shingle, ui16 y_ham, ui16 y_dlv, ui16 y_spam, ui16 y_persham, ui16 y_persspam, float y_weight, bool& exists);
    void AddHeavyDumpItem(ui64 shingle, ui16 t_ham, ui16 t_dlv, ui16 t_spam, ui16 t_persham, ui16 t_persspam, float t_weight, ui16 y_ham, ui16 y_dlv, ui16 y_spam, ui16 y_persham, ui16 y_persspam, float y_weight, bool& exists);
};

typedef std::vector<TShingleStorageItem*> TShingleStorageItemVector;
typedef TShingleStorageItemVector::iterator TShingleStorageItemVectorIt;

//********************************************************************************************************************************
//                                     TShingleStorageV (части одного типа шинглов)
//********************************************************************************************************************************

struct TFollowShingles {
    ui64 m_shingle;
    int m_type;
    ui64 m_get_count;

    TFollowShingles(ui64 shingle, int type, ui64 get_count) {
        m_shingle = shingle;
        m_type = type;
        m_get_count = get_count;
    }
};

typedef std::list<TFollowShingles> TFollowShinglesList;
typedef TFollowShinglesList::iterator TFollowShinglesListIt;

struct TSHTypeStat {
    TSHTypePartStat partdata[SHINGLES_PART_COUNT_MAX];
    int real_part_count;
    ui32 rpl_diff_value;
    ui32 heavy_treshold;
    ui32 max_size_ohash;
    ui32 save_treshold;
    ui32 cleanup_treshold;
    TString dumpfilename;
    bool load_dump_at_startup;
    TString res_loaddump;
    ui32 midnight_koef_div;
    TCleanupType cleanup_type;
    ui32 shutdown_save_treshold;

    TSHTypeStat() {
        Clear();
    }

    void Clear() {
        for (int i = 0; i < SHINGLES_PART_COUNT_MAX; i++)
            partdata[i].Clear();
        real_part_count = 0;
        rpl_diff_value = 0;
        heavy_treshold = 0;
        max_size_ohash = 0;
        save_treshold = 0;
        cleanup_treshold = 0;
        dumpfilename = "";
        load_dump_at_startup = false;
        res_loaddump = "";
        midnight_koef_div = 0;
        cleanup_type = CT_NEW;
        shutdown_save_treshold = 0;
    }

    float TodayCleanupSummary() {
        float res = 0;
        ui32 summcount = 0;

        for (int i = 0; i < real_part_count; i++)
            summcount += partdata[i].today_cleanup_count;

        res = (float)summcount / (float)real_part_count;

        return res;
    }

    ui64 TodayCountSummary() {
        ui64 res = 0;

        for (int i = 0; i < real_part_count; i++)
            res += partdata[i].today_count;

        return res;
    }

    ui64 YesterdayCountSummary() {
        ui64 res = 0;

        for (int i = 0; i < real_part_count; i++)
            res += partdata[i].yesterday_count;

        return res;
    }

    ui64 HeavyCountSummary() {
        ui64 res = 0;

        for (int i = 0; i < real_part_count; i++)
            res += partdata[i].heavy_count;

        return res;
    }

    ui64 RPLTodayCountSummary() {
        ui64 res = 0;

        for (int i = 0; i < real_part_count; i++)
            res += partdata[i].rpl_today_shingles_count;

        return res;
    }

    ui64 RPLYesterdayCountSummary() {
        ui64 res = 0;

        for (int i = 0; i < real_part_count; i++)
            res += partdata[i].rpl_yesterday_shingles_count;

        return res;
    }

    time_t LastCleanupSummary() {
        time_t res = 0;

        for (int i = 0; i < real_part_count; i++) {
            if (partdata[i].last_cleanup > res)
                res = partdata[i].last_cleanup;
        }

        return res;
    }

    time_t LastMidnightSummary() {
        time_t res = 0;

        for (int i = 0; i < real_part_count; i++) {
            if (partdata[i].last_midnight > res)
                res = partdata[i].last_midnight;
        }

        return res;
    }

    time_t LastSaveSummary() {
        time_t res = 0;

        for (int i = 0; i < real_part_count; i++) {
            if (partdata[i].last_save > res)
                res = partdata[i].last_save;
        }

        return res;
    }

    bool Busy() {
        bool res = false;

        for (int i = 0; i < real_part_count; i++) {
            if (partdata[i].busytype != TBT_UNKNOWN) {
                res = true;
                break;
            }
        }

        return res;
    }
};

class TShingleStorageV {
public:
    static const ui8 PART_COUNT_MAX = SHINGLES_PART_COUNT_MAX;
    static const bool LOAD_AT_STARTUP_DEFAULT = true;

private:
    TShingleStorageItemVector m_data;
    ui16 m_partcount;
    TLogsGroup* LogsGroup;
    TRPLMain* RPLPool;
    int m_type;
    TDeleteObjectMain* delobj;
    TFollowShingleHash m_followhash;
    TMutex m_followmutex;
    ui32 m_midnight_koef_div;

    ui32 m_rpldiff_value;
    ui32 m_heavy_treshold;
    ui32 m_max_size_ohash;
    ui32 m_save_treshold;
    ui32 m_cleanup_treshold;
    TString m_dumpfilename;
    bool m_loaddump_at_startup;
    TString res_loaddump;
    TCleanupType m_cleanup_type;
    ui32 m_shutdown_save_treshold;

    ui8 GetPartNumber(ui64 shingle);
    void AddTodayDumpItem(ui64 shingle, ui16 t_ham, ui16 t_dlv, ui16 t_spam, ui16 t_persham, ui16 t_persspam, float t_weight, bool& exists);
    void AddYesterdayDumpItem(ui64 shingle, ui16 y_ham, ui16 y_dlv, ui16 y_spam, ui16 y_persham, ui16 y_persspam, float y_weight, bool& exists);
    void AddHeavyDumpItem(ui64 shingle, ui16 t_ham, ui16 t_dlv, ui16 t_spam, ui16 t_persham, ui16 t_persspam, float t_weight, ui16 y_ham, ui16 y_dlv, ui16 y_spam, ui16 y_persham, ui16 y_persspam, float y_weight, bool& exists);
    void WriteDumpToClose();
    void WriteExitStep(const TString& text);
    bool ReadDump(ui32& lastmidnighttime);

public:
    TShingleStorageV();
    ~TShingleStorageV();

    bool Init(int type, ui8 partcountA, TLogsGroup* LogsGroupA, TDeleteObjectMain* delobjA, ui32 rpldiff_value, ui32 heavy_treshold, ui32 max_size_ohash, ui32 save_treshold, ui32 cleanup_treshold, const TString& dumpfilenameA, bool loaddump_at_startupA, TRPLMain* RPLPoolA, ui32 koef_div, TBusyMonStat* busy_monstat, TCleanupType cleanup_type, ui32 shutdown_save_treshold);

    TShingleStat Put(const TString& abonent_ip, ui64 shingle, ui16 count, TShingleSpamType spamtype, ui64 att_shingle, int att_shingle_type, TPersType pers, const TString& debugstr, bool no_replic, bool is_putm);
    TShingleStat PutM(const TString& abonent_ip, ui64 shingle, ui16 ham, ui16 dlv, ui16 spam, ui16 persham, ui16 persspam, ui64 att_shingle, int att_shingle_type);
    TShingleStat SetM(const TString& abonent_ip, ui64 shingle, ui16 t_ham, ui16 t_dlv, ui16 t_spam, ui16 t_persham, ui16 t_persspam, float t_weight, ui16 y_ham, ui16 y_dlv, ui16 y_spam, ui16 y_persham, ui16 y_persspam, float y_weight, ui64 att_shingle, int att_shingle_type);
    TShingleStat Get(const TString& abonent_ip, ui64 shingle, bool is_second);
    bool ClearShingleA(const TString& abonent_ip, ui64 shingle, bool& busy);
    int SetWeight(const TString& abonent_ip, ui64 shingle, float weight);
    TSHTypeStat GetStat();
    void ShedulerAction();
    void SetCleanupEvent();
    void SetWriteDumpEvent();
    void SetMidnightEvent();
    void Shutdown();
    bool ReadDumpStorage(bool loaddump_at_startup, ui32& lastmidnighttime);

    void CorrectLastMidnightTime(ui32 value);

    bool ExistsFollowShingle(ui64 shingle, ui32& tick);
    bool AddFollowShingle(ui64 shingle);
    bool DeleteFollowShingle(ui64 shingle);
    void GetListFollowShingles(TFollowShinglesList& list);
};

//********************************************************************************************************************************
//                                       TShingleStorageMain (хранилище типов шинглов)
//********************************************************************************************************************************

struct TShingleStorageStat {
    TSHTypeStat typesdata[MAX_COUNT_SHINGLES_TYPE];
    TSimpleStorageStat storage_stat;
    time_t lastwritedumpevent;
    int writedumptype;
    int periodwritedumpsec;
    ui32 periodwritedumpsec_slow;

    TShingleStorageStat() {
        Clear();
    }

    void Clear() {
        for (int i = 0; i < MAX_COUNT_SHINGLES_TYPE; i++)
            typesdata[i].Clear();
        storage_stat.Clear();
        lastwritedumpevent = 0;
        periodwritedumpsec = 0;
        writedumptype = 0;
        periodwritedumpsec_slow = 0;
    }

    ui64 TodayCountSummary() {
        ui64 res = 0;

        for (int i = 0; i < MAX_COUNT_SHINGLES_TYPE; i++)
            res += typesdata[i].TodayCountSummary();

        return res;
    }

    ui64 YesterdayCountSummary() {
        ui64 res = 0;

        for (int i = 0; i < MAX_COUNT_SHINGLES_TYPE; i++)
            res += typesdata[i].YesterdayCountSummary();

        return res;
    }

    ui64 HeavyCountSummary() {
        ui64 res = 0;

        for (int i = 0; i < MAX_COUNT_SHINGLES_TYPE; i++)
            res += typesdata[i].HeavyCountSummary();

        return res;
    }
};

class TShingleStorageMain {
public:
    struct TWStroka {
        TString m_answer;
        TString m_debug;

        TWStroka() {
            Clear();
        }

        void Clear() {
            m_answer = "";
            m_debug = "";
        }
    };

public:
    static const ui16 MAX_COUNT_TYPES = MAX_COUNT_SHINGLES_TYPE;

    struct TReqstParamsStruct {
        TString first;
        TString second;

        TReqstParamsStruct() {
            Clear();
        }

        TReqstParamsStruct(const TString& keyA, const TString& valueA) {
            first = keyA;
            second = valueA;
        }

        void Clear() {
            first = "";
            second = "";
        }
    };

    typedef THashMap<TString, TString> TReqstParams;
    typedef std::list<TReqstParamsStruct> TReqstParamsList;

private:
    TShingleStorageV* typesdata[MAX_COUNT_TYPES];
    TLogsGroup* LogsGroup;
    TKConfig* config;
    TShinglerSrvMode mode;
    TString m_server_id;
    TProxyPool* PoolProxy;
    TRPLMain* RPLPool;
    TSimpleStorage* SSObj;
    TDeleteObjectMain delobj;
    TTrafficControl oldrequest_all;
    TTrafficControl newrequest_all;
    TTrafficCounter shingles_shget_old;
    TTrafficCounter shingles_shput_old;
    TTrafficCounter shingles_stget_old;
    TTrafficCounter shingles_shget_new;
    TTrafficCounter shingles_shput_new;
    TTrafficCounter shingles_stget_new;
    TTrafficCounter shingles_rpl;
    TTrafficControl request_rpl;
    TTrafficControl request_prx;
    TTrafficCounter shingles_prxget;
    TTrafficCounter shingles_prxput;
    TString weights_dir_name;
    TString weights_filename;
    int weights_type;
    TTimeDistributedWriteClass wd_obg;
    int writedumptype;
    int periodwritedumpsec;
    ui32 periodwritedumpsec_slow;
    time_t m_last_load_weight;
    time_t m_last_writedumpevent;
    TMutex m_actionmutex;
    TString m_followsh_filename;
    ui32 m_koef_div;
    TDelayByPart m_cluster_delayobj;
    TDelayByPart m_rpl_delayobj;
    TDelayByPart m_cluster_delayobj_days;
    TDelayByPart m_rpl_delayobj_days;
    TDelayByPart m_prx_delayobj;
    TBusyMonStat m_busy_monstat;

    ui32 m_longdelayms;
    TMutex m_longdelayMutex;

    // bool ParseRequestParamsBase(const TString &request, TReqstParams &paramlist, char record_delimiter, char keyvalue_delimiter);
    bool ParseRequestParamsBaseList(const TString& request, TReqstParamsList& paramlist, char record_delimiter, char keyvalue_delimiter);
    TShingleStat Put(const TString& abonent_ip, ui64 shingle, ui16 type, ui16 count, TShingleSpamType spamtype, ui64 att_shingle, int att_shingle_type, TPersType pers, const TString& debugstr);
    TShingleStat PutM(const TString& abonent_ip, ui64 shingle, ui16 type, ui16 ham, ui16 dlv, ui16 spam, ui16 persham, ui16 persspam, ui64 att_shingle, int att_shingle_type, TShingleSpamType att_spamtype, TPersType att_pers);
    TShingleStat SetM(const TString& abonent_ip, ui64 shingle, ui16 type, ui16 t_ham, ui16 t_dlv, ui16 t_spam, ui16 t_persham, ui16 t_persspam, float t_weight, ui16 y_ham, ui16 y_dlv, ui16 y_spam, ui16 y_persham, ui16 y_persspam, float y_weight, ui64 att_shingle, int att_shingle_type);
    TShingleStat Get(const TString& abonent_ip, ui64 shingle, ui16 type, ui64 att_shingle, int att_shingle_type);
    bool ClearShingleA(const TString& abonent_ip, ui64 shingle, ui16 type, bool& busy);
    int SetWeight(const TString& abonent_ip, ui64 shingle, ui16 type, float weight);
    TShingleStat GetStorage(ui64 shingle);
    TShingleStat AddStorage(ui64 shingle, const TString& stdata);
    bool ParseRequestA(const TString& NumbRequest, const char* s, TWStroka& result, bool old, const TString& abonent_ip, int thread_index, TProtokolType prtype);
    TWStroka ParseShGetRequest(const TString& NumbRequest, const char* ident, const TString& request, bool old, const TString& abonent_ip, int thread_index, TProtokolType prtype);
    TWStroka ParseShPutRequest(const TString& NumbRequest, const char* ident, const TString& request, bool old, const TString& abonent_ip, int thread_index, TProtokolType prtype);
    TWStroka ParseStGetRequest(const TString& NumbRequest, const char* ident, const TString& request, bool old, const TString& abonent_ip, int thread_index, TProtokolType prtype);
    TWStroka ParseShRplRequest(const TString& NumbRequest, const TString& abonent_ip, const char* ident, const TString& request, const TString& remote_srv_ident);
    TWStroka ParseShPrxGetRequest(const TString& NumbRequest, const TString& abonent_ip, const char* ident, const TString& request);
    TWStroka ParseShPrxPutRequest(const TString& NumbRequest, const TString& abonent_ip, const char* ident, const TString& request);
    TString ConvertToShGetRequest(const TString& request);
    TString ConvertToShPutRequest(const TString& request);
    TString ConvertToStGetRequest(const TString& request);

    void ReadFollowShingles(const TString& filename);
    void WriteExitStep(const TString& text);

public:
    // Sheduler
    ui16 m_SleepTime;
    TThread* m_Sheduler;
    bool m_StopSheduler;
    bool m_StartSheduler;
    bool m_stop;
    TMutex m_Mutex;

    bool IsStop() {
        return m_stop;
    }
    bool ShedulerShouldStop() {
        return m_StopSheduler;
    }
    bool ShedulerStopped();
    void ShedulerStopped(bool Stopped);
    void Sleep();
    void ShedulerAction();
    void StartSheduler();
    void StopSheduler();
    void Close();

    void SaveFollowShingles();

public:
    TShingleStorageMain();
    ~TShingleStorageMain();

    bool InitBeforeFork(const TString& server_id, TLogsGroup* LogsGroupA, TKConfig* configA, TShinglerSrvMode modeA, TProxyPool* PoolProxyA, TRPLMain* RPLPoolA, TSimpleStorage* SSObjA);
    bool InitAfterFork();
    bool ParseRequest(const TString& NumbRequest, const char* s, TWStroka& result, const TString& abonent_ip, int thread_index);
    bool ParseRequestOld(const TString& NumbRequest, const char* s, TWStroka& result, const TString& abonent_ip, int thread_index);
    void ProxySetShingles(const TString& abonent_ip, TShingleStatList& shingle_list);
    TShingleStat GetPublic(const TString& abonent_ip, ui64 shingle, ui16 type);
    bool ClearShingle(const TString& abonent_ip, ui64 shingle, ui16 type, bool& busy);

    TTrafficControl* GetOldTrafficControl() {
        return &oldrequest_all;
    }
    TTrafficCounter* GetShGetTrafficControlOld() {
        return &shingles_shget_old;
    }
    TTrafficCounter* GetShPutTrafficControlOld() {
        return &shingles_shput_old;
    }
    TTrafficCounter* GetStGetTrafficControlOld() {
        return &shingles_stget_old;
    }

    TTrafficControl* GetNewTrafficControl() {
        return &newrequest_all;
    }
    TTrafficCounter* GetShGetTrafficControlNew() {
        return &shingles_shget_new;
    }
    TTrafficCounter* GetShPutTrafficControlNew() {
        return &shingles_shput_new;
    }
    TTrafficCounter* GetStGetTrafficControlNew() {
        return &shingles_stget_new;
    }

    TTrafficControl* GetRplTrafficControlRequest() {
        return &request_rpl;
    }
    TTrafficCounter* GetRplTrafficControlShingles() {
        return &shingles_rpl;
    }

    TTrafficControl* GetPrxTrafficControl() {
        return &request_prx;
    }
    TTrafficCounter* GetPrxGetTrafficControl() {
        return &shingles_prxget;
    }
    TTrafficCounter* GetPrxPutTrafficControl() {
        return &shingles_prxput;
    }

    TDelayByPart* GetClusterDelayObj() {
        return &m_cluster_delayobj;
    }
    TDelayByPart* GetRplDelayObj() {
        return &m_rpl_delayobj;
    }
    TDelayByPart* GetClusterDelayObjDays() {
        return &m_cluster_delayobj_days;
    }
    TDelayByPart* GetRplDelayObjDays() {
        return &m_rpl_delayobj_days;
    }
    TDelayByPart* GetPrxDelayObj() {
        return &m_prx_delayobj;
    }
    TBusyMonStat* GetBusyMonstatObj() {
        return &m_busy_monstat;
    }

    void Midnight();
    void EventTick();
    void Shutdown();
    void GetStat(TShingleStorageStat& value);
    void SetWriteDumpEvent();
    void Cleanup(int type);
    void WritedumpTickEvent();
    void Writedump(int type);
    bool LoadWeights();
    void WriteThreadIDToLog();

    bool ExistsFollowShingle(ui64 shingle, int type, ui32& tick);
    bool AddFollowShingle(ui64 shingle, int type);
    bool DeleteFollowShingle(ui64 shingle, int type);
    void GetListFollowShingles(TFollowShinglesList& list);

    void SetLongDelayMs(ui32 delay_ms);
    ui32 GetLongDelayMs();
};

//********************************************************************************************************************************
