#include "tshinglestorage.h"
#include <library/cpp/testing/unittest/registar.h>
Y_UNIT_TEST_SUITE(ShinglerCntStor) {
    Y_UNIT_TEST(ShinglerCntTestHam) {
        TKConfig config;
        TShingleStorageMain shinstor;
        bool parse_res = false;
        TShingleStorageMain::TWStroka parse_result_get = TShingleStorageMain::TWStroka();
        TShingleStorageMain::TWStroka parse_result_put = TShingleStorageMain::TWStroka();
        TString request_get = "shinrqst?shget=1111111111111111-1=&2222222222222222-2=&3333333333333333-3=&4444444444444444-4=&5555555555555555-5=&6666666666666666-6=&7777777777777777-7=&8888888888888888-8=&9999999999999999-9=&1010101010101010-10=&1717171717171717-17=&1919191919191919-19=&9090909090909090-90=&1271271271271271-127=&stget=3737373737373737=&4848484848484848=";
        TString request_put = "shinrqst?shput=1111111111111111-1=1-0-0&2222222222222222-2=1-0-0&3333333333333333-3=1-0-0&4444444444444444-4=1-0-0&5555555555555555-5=1-0-0&6666666666666666-6=1-0-0&7777777777777777-7=1-0-0&8888888888888888-8=1-0-0&9999999999999999-9=2-0-0&1010101010101010-10=1-0-0&1717171717171717-17=1-0-0,1919191919191919-19=1-0-0&9090909090909090-90=1-0-0&1271271271271271-127=1-0-0&";
        TString answer_get = "<SH: 1111111111111111-1 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 2222222222222222-2 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 3333333333333333-3 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 4444444444444444-4 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 5555555555555555-5 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 6666666666666666-6 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 7777777777777777-7 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 8888888888888888-8 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 9999999999999999-9 empty='0' ti='2,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1010101010101010-10 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1717171717171717-17 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1919191919191919-19 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 9090909090909090-90 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1271271271271271-127 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><ST: 3737373737373737 empty='1' std=''><ST: 4848484848484848 empty='1' std=''>";
        TString answer_put = "<SH: 1111111111111111-1 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 2222222222222222-2 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 3333333333333333-3 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 4444444444444444-4 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 5555555555555555-5 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 6666666666666666-6 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 7777777777777777-7 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 8888888888888888-8 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 9999999999999999-9 empty='0' ti='2,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1010101010101010-10 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1717171717171717-17 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' unsh='1919191919191919-19' unemp='0' unti='1,0,0,0,0,0.000000' unyi='0,0,0,0,0,0.000000' unpr='oe' lmt='0' ><SH: 9090909090909090-90 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1271271271271271-127 empty='0' ti='1,0,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' >";
        config.AddParam("shingle", "load_dump_at_startup", "0");
        config.AddParam("shingle", "writedump_type", "0");
        shinstor.InitBeforeFork("unittest", NULL, &config, MSHINGLER, NULL, NULL, NULL);
        parse_res = shinstor.ParseRequest("##1234567", request_put.c_str(), parse_result_put, "127.0.0.1", 0);
        UNIT_ASSERT_EQUAL(parse_res, true);
        parse_res = parse_result_put.m_answer == answer_put;
        UNIT_ASSERT_EQUAL(parse_res, true);
        parse_res = shinstor.ParseRequest("##1234567", request_get.c_str(), parse_result_get, "127.0.0.1", 0);
        UNIT_ASSERT_EQUAL(parse_res, true);
        parse_res = parse_result_get.m_answer == answer_get;
        UNIT_ASSERT_EQUAL(parse_res, true);
    }
    Y_UNIT_TEST(ShinglerCntTestMalic) {
        TKConfig config;
        TShingleStorageMain shinstor;
        bool parse_res = false;
        TShingleStorageMain::TWStroka parse_result_get = TShingleStorageMain::TWStroka();
        TShingleStorageMain::TWStroka parse_result_put = TShingleStorageMain::TWStroka();
        TString request_get = "shinrqst?shget=1111111111111111-1=&2222222222222222-2=&3333333333333333-3=&4444444444444444-4=&5555555555555555-5=&6666666666666666-6=&7777777777777777-7=&8888888888888888-8=&9999999999999999-9=&1010101010101010-10=&1717171717171717-17=&1919191919191919-19=&9090909090909090-90=&1271271271271271-127=&stget=3737373737373737=&4848484848484848=";
        TString request_put = "shinrqst?shput=1111111111111111-1=1-1-0&2222222222222222-2=1-1-0&3333333333333333-3=1-1-0&4444444444444444-4=1-1-0&5555555555555555-5=1-1-0&6666666666666666-6=1-1-0&7777777777777777-7=1-1-0&8888888888888888-8=1-1-0&9999999999999999-9=2-1-0&1010101010101010-10=1-1-0&1717171717171717-17=1-1-0,1919191919191919-19=1-1-0&9090909090909090-90=1-1-0&1271271271271271-127=1-1-0&";
        TString answer_get = "<SH: 1111111111111111-1 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 2222222222222222-2 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 3333333333333333-3 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 4444444444444444-4 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 5555555555555555-5 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 6666666666666666-6 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 7777777777777777-7 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 8888888888888888-8 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 9999999999999999-9 empty='0' ti='0,2,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1010101010101010-10 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1717171717171717-17 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1919191919191919-19 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 9090909090909090-90 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1271271271271271-127 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><ST: 3737373737373737 empty='1' std=''><ST: 4848484848484848 empty='1' std=''>";
        TString answer_put = "<SH: 1111111111111111-1 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 2222222222222222-2 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 3333333333333333-3 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 4444444444444444-4 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 5555555555555555-5 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 6666666666666666-6 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 7777777777777777-7 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 8888888888888888-8 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 9999999999999999-9 empty='0' ti='0,2,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1010101010101010-10 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1717171717171717-17 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' unsh='1919191919191919-19' unemp='0' unti='0,1,0,0,0,0.000000' unyi='0,0,0,0,0,0.000000' unpr='oe' lmt='0' ><SH: 9090909090909090-90 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1271271271271271-127 empty='0' ti='0,1,0,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' >";
        config.AddParam("shingle", "load_dump_at_startup", "0");
        config.AddParam("shingle", "writedump_type", "0");
        shinstor.InitBeforeFork("unittest", NULL, &config, MSHINGLER, NULL, NULL, NULL);
        parse_res = shinstor.ParseRequest("##1234567", request_put.c_str(), parse_result_put, "127.0.0.1", 0);
        UNIT_ASSERT_EQUAL(parse_res, true);
        parse_res = parse_result_put.m_answer == answer_put;
        UNIT_ASSERT_EQUAL(parse_res, true);
        parse_res = shinstor.ParseRequest("##1234567", request_get.c_str(), parse_result_get, "127.0.0.1", 0);
        UNIT_ASSERT_EQUAL(parse_res, true);
        parse_res = parse_result_get.m_answer == answer_get;
        UNIT_ASSERT_EQUAL(parse_res, true);
    }
    Y_UNIT_TEST(ShinglerCntTestSpam) {
        TKConfig config;
        TShingleStorageMain shinstor;
        bool parse_res = false;
        TShingleStorageMain::TWStroka parse_result_get = TShingleStorageMain::TWStroka();
        TShingleStorageMain::TWStroka parse_result_put = TShingleStorageMain::TWStroka();
        TString request_get = "shinrqst?shget=1111111111111111-1=&2222222222222222-2=&3333333333333333-3=&4444444444444444-4=&5555555555555555-5=&6666666666666666-6=&7777777777777777-7=&8888888888888888-8=&9999999999999999-9=&1010101010101010-10=&1717171717171717-17=&1919191919191919-19=&9090909090909090-90=&1271271271271271-127=&stget=3737373737373737=&4848484848484848=";
        TString request_put = "shinrqst?shput=1111111111111111-1=1-2-0&2222222222222222-2=1-2-0&3333333333333333-3=1-2-0&4444444444444444-4=1-2-0&5555555555555555-5=1-2-0&6666666666666666-6=1-2-0&7777777777777777-7=1-2-0&8888888888888888-8=1-2-0&9999999999999999-9=2-2-0&1010101010101010-10=1-2-0&1717171717171717-17=1-2-0,1919191919191919-19=1-2-0&9090909090909090-90=1-2-0&1271271271271271-127=1-2-0&";
        TString answer_get = "<SH: 1111111111111111-1 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 2222222222222222-2 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 3333333333333333-3 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 4444444444444444-4 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 5555555555555555-5 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 6666666666666666-6 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 7777777777777777-7 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 8888888888888888-8 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 9999999999999999-9 empty='0' ti='0,0,2,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1010101010101010-10 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1717171717171717-17 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1919191919191919-19 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 9090909090909090-90 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1271271271271271-127 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><ST: 3737373737373737 empty='1' std=''><ST: 4848484848484848 empty='1' std=''>";
        TString answer_put = "<SH: 1111111111111111-1 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 2222222222222222-2 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 3333333333333333-3 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 4444444444444444-4 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 5555555555555555-5 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 6666666666666666-6 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 7777777777777777-7 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 8888888888888888-8 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 9999999999999999-9 empty='0' ti='0,0,2,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1010101010101010-10 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1717171717171717-17 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' unsh='1919191919191919-19' unemp='0' unti='0,0,1,0,0,0.000000' unyi='0,0,0,0,0,0.000000' unpr='oe' lmt='0' ><SH: 9090909090909090-90 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' ><SH: 1271271271271271-127 empty='0' ti='0,0,1,0,0,0.000000' yi='0,0,0,0,0,0.000000' ak='0.000000' pr='oe' lmt='0' >";
        config.AddParam("shingle", "load_dump_at_startup", "0");
        config.AddParam("shingle", "writedump_type", "0");
        shinstor.InitBeforeFork("unittest", NULL, &config, MSHINGLER, NULL, NULL, NULL);
        parse_res = shinstor.ParseRequest("##1234567", request_put.c_str(), parse_result_put, "127.0.0.1", 0);
        UNIT_ASSERT_EQUAL(parse_res, true);
        parse_res = parse_result_put.m_answer == answer_put;
        UNIT_ASSERT_EQUAL(parse_res, true);
        parse_res = shinstor.ParseRequest("##1234567", request_get.c_str(), parse_result_get, "127.0.0.1", 0);
        UNIT_ASSERT_EQUAL(parse_res, true);
        parse_res = parse_result_get.m_answer == answer_get;
        UNIT_ASSERT_EQUAL(parse_res, true);
    }
}
